/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction;

import com.jbidwatcher.util.Currency;
import com.jbidwatcher.util.db.ActiveRecord;
import com.jbidwatcher.util.db.Table;
import java.util.List;

public class AuctionSnipe
extends ActiveRecord {
    private static Table sDB = null;

    public Currency getAmount() {
        return this.getMonetary("amount");
    }

    public int getQuantity() {
        return this.getInteger("quantity", 1);
    }

    public long getDelta() {
        return this.getInteger("delta").intValue();
    }

    public int getUserId() {
        return this.getInteger("user_id");
    }

    public String getStatus() {
        return this.getString("status");
    }

    public boolean isNegative() {
        return this.getAmount().getValue() < 0.0;
    }

    public static AuctionSnipe create(Currency amount, int quantity, long delta) {
        AuctionSnipe snipe = new AuctionSnipe();
        snipe.setMonetary("amount", amount);
        snipe.setInteger("quantity", quantity);
        snipe.setInteger("delta", (int)delta);
        snipe.saveDB();
        return snipe;
    }

    protected static String getTableName() {
        return "snipes";
    }

    @Override
    protected Table getDatabase() {
        if (sDB == null) {
            sDB = AuctionSnipe.openDB(AuctionSnipe.getTableName());
        }
        return sDB;
    }

    public static AuctionSnipe find(String id) {
        return AuctionSnipe.findFirstBy("id", id);
    }

    public static AuctionSnipe findFirstBy(String key, String value) {
        return (AuctionSnipe)ActiveRecord.findFirstBy(AuctionSnipe.class, key, value);
    }

    public static boolean deleteAll(List<AuctionSnipe> toDelete) {
        if (toDelete.isEmpty()) {
            return true;
        }
        String snipes = AuctionSnipe.makeCommaList(toDelete);
        return toDelete.get(0).getDatabase().deleteBy("id IN (" + snipes + ")");
    }
}

