/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction.server.ebay;

import com.jbidwatcher.auction.LoginManager;
import com.jbidwatcher.auction.server.ebay.ebayCleaner;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.html.AbstractURLPager;
import com.jbidwatcher.util.html.JHTML;
import com.jbidwatcher.util.html.URLPagerIterator;
import com.jbidwatcher.util.http.CookieJar;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class EbayAuctionURLPager
extends AbstractURLPager {
    private static final String URLSTYLE_HTTP_STR = "search.dll";
    private static final int URLSTYLE_HTTP = 0;
    private static final int URLSTYLE_EBAY = 1;
    private static final int ITEMS_PER_PAGE = 100;
    private ebayCleaner mCleaner = new ebayCleaner();
    private LoginManager mLogin;
    private int urlStyle;
    private JHTML lastPage;
    private boolean itemCountSet;

    public EbayAuctionURLPager(String url, LoginManager aucServ) {
        this.setURL(url);
        this.setItemsPerPage(100);
        this.mLogin = aucServ;
        this.getPage(1);
    }

    @Override
    protected void setURL(String url) {
        this.urlString = url;
        if (url.indexOf("ebay.") != -1) {
            if (url.indexOf(URLSTYLE_HTTP_STR) != -1) {
                this.urlStyle = 0;
                this.removePattern("&frpp=[0-9]*");
                this.removePattern("&skip=[0-9]*");
            } else {
                this.urlStyle = 1;
                this.removePattern("QQfrppZ[0-9]*");
                this.removePattern("QQfrtsZ[0-9]*");
            }
        }
    }

    private void removePattern(String regex) {
        this.urlString = this.urlString.replaceAll("(?i)" + regex, "");
    }

    private String getPageURL(int pageNumber) {
        if (this.urlString.indexOf("ebay.") == -1) {
            return this.urlString;
        }
        if (this.urlStyle == 0) {
            return this.urlString + "&frpp=" + this.getItemsPerPage() + "&skip=" + (pageNumber - 1) * this.getItemsPerPage();
        }
        if (this.urlStyle == 1) {
            return this.urlString + "QQfrppZ" + this.getItemsPerPage() + "QQfrtsZ" + (pageNumber - 1) * this.getItemsPerPage();
        }
        JConfig.log().logMessage("Unknown URLSTYLE: " + this.urlStyle);
        return null;
    }

    protected JHTML getPage(String pageURL) {
        JHTML htmlDocument;
        if (pageURL == null) {
            return null;
        }
        CookieJar cj = this.mLogin.getNecessaryCookie(false);
        String cookies = null;
        if (cj != null) {
            cookies = cj.toString();
        }
        if ((htmlDocument = new JHTML(pageURL, cookies, this.mCleaner)).isLoaded()) {
            return htmlDocument;
        }
        return null;
    }

    @Override
    public JHTML getPage(int pageNumber) {
        if (pageNumber < 1 || this.itemCountSet && pageNumber > this.size()) {
            throw new NoSuchElementException();
        }
        if (pageNumber == this.lastPageNumber) {
            return this.lastPage;
        }
        this.lastPageNumber = pageNumber;
        this.lastPage = this.getPage(this.getPageURL(pageNumber));
        if (pageNumber == 1 && !this.itemCountSet) {
            this.setItemCount();
        }
        return this.lastPage;
    }

    private void setItemCount() {
        if (this.lastPage == null) {
            this.setItemCount(0);
            this.itemCountSet = true;
        } else {
            String count = this.lastPage.getContentBeforeContent("items found for");
            if (count == null) {
                count = this.lastPage.getContentBeforeContent("items found in");
            }
            try {
                this.setItemCount(Integer.parseInt(count));
            }
            catch (NumberFormatException e) {
                JConfig.log().logMessage("Unable to find item count on page! URL: " + this.getPageURL(1));
            }
            this.itemCountSet = true;
        }
    }

    @Override
    public ListIterator listIterator(int index) {
        return new URLPagerIterator(this, index);
    }
}

