/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.my;

import com.cyberfox.util.config.ErrorHandler;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.EntryCorral;
import com.jbidwatcher.my.My;
import com.jbidwatcher.util.Parameters;
import com.jbidwatcher.util.StringTools;
import com.jbidwatcher.util.ZoneDate;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.html.JHTML;
import com.jbidwatcher.util.http.ClientHttpRequest;
import com.jbidwatcher.util.http.Http;
import com.jbidwatcher.util.http.HttpInterface;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.MessageQueue;
import com.jbidwatcher.util.queue.SuperQueue;
import com.jbidwatcher.util.xml.XMLElement;
import com.jbidwatcher.util.xml.XMLInterface;
import com.jbidwatcher.util.xml.XMLSerialize;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Map;
import org.json.simple.JSONObject;

@Singleton
public class MyJBidwatcher {
    private final EntryCorral entryCorral;
    private HttpInterface mNet = null;
    private static final String LOG_UPLOAD_URL = "my.jbidwatcher.com/upload/log";
    private static final String ITEM_UPLOAD_URL = "my.jbidwatcher.com/upload/listing";
    private static final String SYNC_UPLOAD_URL = "my.jbidwatcher.com/upload/sync";
    private static final String THUMBNAIL_UPLOAD_URL = "my.jbidwatcher.com/upload/thumbnail";
    private String mSyncQueueURL = null;
    private String mReportQueueURL = null;
    private boolean mUseSSL = false;
    private boolean mUploadHTML = false;
    private boolean mUseServerParser = false;
    private boolean mReadSnipesFromServer = false;
    private ZoneDate mExpiry;

    private String url(String url) {
        if (this.mUseSSL) {
            return "https://" + url;
        }
        return "http://" + url;
    }

    private HttpInterface http() {
        if (this.mNet == null) {
            this.mNet = new Http();
        }
        this.mNet.setAuthInfo(JConfig.queryConfiguration("my.jbidwatcher.id"), JConfig.queryConfiguration("my.jbidwatcher.key"));
        return this.mNet;
    }

    public String sendLogFile(String email, String desc) {
        JConfig.log().pause();
        File fp = JConfig.log().closeLog();
        String result = this.sendFile(fp, this.url(LOG_UPLOAD_URL), email, desc);
        JConfig.log().openLog(fp);
        JConfig.log().resume();
        return result;
    }

    private static String createFormSource(String formBase, String email, String desc) {
        try {
            String parameters = "";
            if (email != null && email.length() != 0) {
                parameters = "?email=" + URLEncoder.encode(email, "UTF-8");
            }
            if (desc != null && desc.length() != 0) {
                parameters = parameters + (parameters.length() == 0 ? (char)'?' : '&');
                parameters = parameters + "description=" + URLEncoder.encode(desc, "UTF-8");
            }
            formBase = formBase + parameters;
        }
        catch (Exception e) {
            formBase = formBase + "email=teh%40fail.com&description=Failed+to+encode+description";
        }
        return formBase;
    }

    public String sendFile(File fp, String formBase, String email, String desc) {
        String formSource = MyJBidwatcher.createFormSource(formBase, email, desc);
        if (fp != null) {
            return this.uploadFile(fp, formSource);
        }
        return null;
    }

    private String uploadFile(File f, String feedForm) {
        String result = null;
        try {
            StringBuffer sample = this.http().get(feedForm);
            if (sample == null) {
                JConfig.log().logDebug("Failed to get S3 upload form from " + feedForm);
            } else {
                JHTML jh = new JHTML(sample);
                JHTML.Form form = jh.getFormWithInput("AWSAccessKeyId");
                if (form != null) {
                    form.delInput("upload");
                    String url = form.getAction();
                    ClientHttpRequest chr = new ClientHttpRequest(JConfig.getURL(url));
                    chr.setParameters(form.getCGIMap());
                    chr.setParameter("file", f);
                    HttpURLConnection huc = chr.post();
                    InputStream resp = this.http().getStream(huc);
                    result = StringTools.cat(resp);
                    resp.close();
                }
            }
        }
        catch (IOException e) {
            JConfig.log().handleDebugException("Trying to upload a file to S3", e);
        }
        return result;
    }

    public String recognizeBidpage(String identifier, StringBuffer page) {
        if (MyJBidwatcher.canParse()) {
            Parameters p = new Parameters();
            if (identifier != null) {
                p.put("item", identifier);
            }
            p.put("body", page);
            String url = this.url("my.jbidwatcher.com/services/recognize");
            return this.http().postTo(url, p);
        }
        return null;
    }

    public String reportException(String sb) {
        Parameters p = new Parameters();
        p.put("body", sb);
        String url = this.url("my.jbidwatcher.com/services/report_exception");
        return this.http().postTo(url, p);
    }

    public void postXML(String queue, XMLSerialize ae) {
        XMLElement xmlWrapper = new XMLElement("message");
        XMLElement user = new XMLElement("user");
        XMLElement access_key = new XMLElement("key");
        user.setContents(JConfig.queryConfiguration("my.jbidwatcher.id"));
        access_key.setContents(JConfig.queryConfiguration("my.jbidwatcher.key"));
        xmlWrapper.addChild(user);
        xmlWrapper.addChild(access_key);
        xmlWrapper.addChild(ae.toXML());
        String aucXML = xmlWrapper.toString();
        if (queue != null) {
            this.http().putTo(queue, aucXML);
        }
    }

    public void postXML(String queue, String body) {
        XMLElement xmlWrapper = new XMLElement("message");
        XMLElement user = new XMLElement("user");
        XMLElement access_key = new XMLElement("key");
        user.setContents(JConfig.queryConfiguration("my.jbidwatcher.id"));
        access_key.setContents(JConfig.queryConfiguration("my.jbidwatcher.key"));
        XMLElement data = new XMLElement("data");
        xmlWrapper.addChild(user);
        xmlWrapper.addChild(access_key);
        data.setContents(body);
        xmlWrapper.addChild(data);
        String aucXML = xmlWrapper.toString();
        if (queue != null) {
            this.http().putTo(queue, aucXML);
        }
    }

    void checkUpdated(String pair) {
        String[] params = pair.split(",");
        String identifier = params[0];
        boolean changed = Boolean.parseBoolean(params[1]);
        My status = My.findByIdentifier(identifier);
        if (status == null || status.getDate("last_synced_at") == null || changed) {
            this.entryCorral.takeForWrite(identifier);
            this.entryCorral.erase(identifier);
            MQFactory.getConcrete("upload").enqueue(identifier);
        }
    }

    @Inject
    private MyJBidwatcher(EntryCorral corral) {
        this.entryCorral = corral;
        MQFactory.getConcrete("my_account").registerListener(new MessageQueue.Listener(){

            @Override
            public void messageAction(Object deQ) {
                String cmd = (String)deQ;
                if (cmd.equals("ACCOUNT")) {
                    MyJBidwatcher.this.getAccountInfo();
                    MQFactory.getConcrete("my").registerListener(new MessageQueue.Listener(){

                        @Override
                        public void messageAction(Object deQ) {
                            String cmd = (String)deQ;
                            if (JConfig.queryConfiguration("my.jbidwatcher.enabled", "false").equals("true")) {
                                if (cmd.equals("ACCOUNT")) {
                                    MyJBidwatcher.this.getAccountInfo();
                                }
                                if (cmd.startsWith("UPDATE ")) {
                                    MyJBidwatcher.this.checkUpdated(cmd.substring(7));
                                }
                                if (cmd.startsWith("SYNC ")) {
                                    MyJBidwatcher.this.uploadAuctionList(cmd.substring(5));
                                }
                            }
                        }
                    });
                }
            }
        });
        SuperQueue.getInstance().preQueue("ACCOUNT", "my_account", System.currentTimeMillis(), 86400000L);
        MQFactory.getConcrete("upload").registerListener(new MessageQueue.Listener(){

            @Override
            public void messageAction(Object deQ) {
                if (JConfig.queryConfiguration("my.jbidwatcher.id") != null && MyJBidwatcher.this.mSyncQueueURL != null && MyJBidwatcher.canSync()) {
                    AuctionEntry ae = (AuctionEntry)MyJBidwatcher.this.entryCorral.takeForRead((String)deQ);
                    MyJBidwatcher.this.uploadSync(ae);
                    MyJBidwatcher.this.uploadThumbnail(ae);
                    MyJBidwatcher.this.uploadAuctionHTML(ae, "uploadhtml");
                }
            }
        });
        if (JConfig.queryConfiguration("my.jbidwatcher.id") != null) {
            MQFactory.getConcrete("report").registerListener(new MessageQueue.Listener(){

                @Override
                public void messageAction(Object deQ) {
                    AuctionEntry ae = (AuctionEntry)MyJBidwatcher.this.entryCorral.takeForRead((String)deQ);
                    MyJBidwatcher.this.uploadAuctionHTML(ae, "report");
                }
            });
        }
        JConfig.log().addHandler(new ErrorHandler(){

            @Override
            public void close() {
            }

            @Override
            public void addLog(String s) {
            }

            @Override
            public void exception(String log, String message, String trace) {
                if (message == null) {
                    message = "(no message)";
                }
                if (JConfig.queryConfiguration("my.jbidwatcher.id") != null && JConfig.queryConfiguration("logging.remote", "false").equals("true")) {
                    MyJBidwatcher.this.reportException(log + "\n" + message + "\n" + trace);
                }
            }
        });
    }

    private void uploadSync(AuctionEntry ae) {
        this.postXML(this.mSyncQueueURL, JSONObject.toJSONString((Map)ae.getBacking()));
        String identifier = ae.getIdentifier();
        My status = My.findByIdentifier(identifier);
        if (status == null) {
            status = new My(identifier);
        }
        status.setDate("last_synced_at", new Date());
        status.saveDB();
    }

    private void uploadAuctionList(String fname) {
        if (MyJBidwatcher.canSync()) {
            File fp = new File(fname);
            if (fp.exists()) {
                this.sendFile(fp, this.url(SYNC_UPLOAD_URL), JConfig.queryConfiguration("my.jbidwatcher.id"), "synchronize");
                MQFactory.getConcrete("Swing").enqueue("NOTIFY Finished synchronizing auctions to My JBidwatcher");
            } else {
                MQFactory.getConcrete("Swing").enqueue("NOTIFY No auctions file to synchronize to My JBidwatcher");
            }
        } else {
            MQFactory.getConcrete("Swing").enqueue("NOTIFY Synchronizing auctions to My JBidwatcher is disabled");
        }
    }

    private void uploadThumbnail(AuctionEntry ae) {
        if (MyJBidwatcher.canSync()) {
            File fp;
            String identifier = ae.getIdentifier();
            My status = My.findByIdentifier(identifier);
            if (status == null) {
                status = new My(identifier);
            }
            String thumbnailFile = ae.getThumbnail();
            if (!status.getBoolean("thumbnail_uploaded") && thumbnailFile != null && (fp = new File(thumbnailFile = thumbnailFile.substring(5))).exists()) {
                String result = this.sendFile(fp, this.url(THUMBNAIL_UPLOAD_URL), JConfig.queryConfiguration("my.jbidwatcher.id"), "thumbnail");
                if (result == null) {
                    JConfig.log().logMessage("Failed to upload thumbnail for " + identifier);
                } else {
                    status.setBoolean("thumbnail_uploaded", true);
                    status.saveDB();
                }
            }
        }
    }

    private void uploadAuctionHTML(AuctionEntry ae, String uploadType) {
        if (MyJBidwatcher.canUploadHTML()) {
            String s3Result = this.sendFile(JConfig.getContentFile(ae.getIdentifier()), this.url(ITEM_UPLOAD_URL), JConfig.queryConfiguration("my.jbidwatcher.id"), ae.getLastStatus());
            XMLElement root = new XMLElement(uploadType);
            XMLElement s3Key = new XMLElement("s3");
            s3Key.setContents(s3Result);
            XMLElement auction = new XMLElement("auction");
            auction.setContents(JSONObject.toJSONString((Map)ae.getBacking()));
            root.addChild(auction);
            this.postXML(this.mReportQueueURL, root);
            My status = My.findByIdentifier(ae.getIdentifier());
            String identifier = ae.getIdentifier();
            if (status == null) {
                status = new My(identifier);
            }
            status.setDate("last_uploaded_html", new Date());
            status.saveDB();
        }
    }

    private static boolean canUploadHTML() {
        return MyJBidwatcher.allow("uploadhtml");
    }

    private static boolean canSync() {
        return MyJBidwatcher.allow("sync");
    }

    private static boolean canParse() {
        return MyJBidwatcher.allow("parser");
    }

    private static boolean canGetSnipes() {
        return MyJBidwatcher.allow("snipes");
    }

    private static boolean allow(String type) {
        return JConfig.queryConfiguration("my.jbidwatcher.allow." + type, "false").equals("true") && JConfig.queryConfiguration("my.jbidwatcher." + type, "false").equals("true");
    }

    public boolean getAccountInfo() {
        return this.getAccountInfo(JConfig.queryConfiguration("my.jbidwatcher.id"), JConfig.queryConfiguration("my.jbidwatcher.key"));
    }

    public boolean getAccountInfo(String username, String password) {
        if (username == null || password == null) {
            return false;
        }
        if (username.length() == 0 || password.length() == 0) {
            return false;
        }
        StringBuffer sb = MyJBidwatcher.getRawAccountXML(username, password);
        if (sb == null) {
            return false;
        }
        XMLElement xml = new XMLElement();
        xml.parseString(sb.toString());
        XMLElement sync = xml.getChild("syncq");
        XMLElement snipe = xml.getChild("snipeq");
        XMLElement expires = xml.getChild("expiry");
        XMLElement listingsRemaining = xml.getChild("listings");
        XMLElement categoriesRemaining = xml.getChild("categories");
        XMLElement reporting = xml.getChild("reportq");
        XMLElement snipesListen = xml.getChild("snipes");
        XMLElement ssl = xml.getChild("ssl");
        XMLElement uploadHTML = xml.getChild("uploadhtml");
        XMLElement serverParser = xml.getChild("parser");
        this.checkExpiration(expires);
        JConfig.setConfiguration("my.jbidwatcher.allow.listings", listingsRemaining.getContents());
        JConfig.setConfiguration("my.jbidwatcher.allow.categories", categoriesRemaining.getContents());
        this.mSyncQueueURL = sync == null ? null : sync.getContents();
        JConfig.setConfiguration("my.jbidwatcher.allow.sync", Boolean.toString(this.mSyncQueueURL != null));
        this.mReportQueueURL = reporting == null ? null : reporting.getContents();
        this.mUseSSL = MyJBidwatcher.getBoolean(ssl);
        JConfig.setConfiguration("my.jbidwatcher.allow.ssl", Boolean.toString(this.mUseSSL));
        this.mReadSnipesFromServer = MyJBidwatcher.getBoolean(snipesListen);
        JConfig.setConfiguration("my.jbidwatcher.allow.snipes", Boolean.toString(this.mReadSnipesFromServer));
        this.mUploadHTML = MyJBidwatcher.getBoolean(uploadHTML);
        JConfig.setConfiguration("my.jbidwatcher.allow.uploadhtml", Boolean.toString(this.mUploadHTML));
        this.mUseServerParser = MyJBidwatcher.getBoolean(serverParser);
        JConfig.setConfiguration("my.jbidwatcher.allow.parser", Boolean.toString(this.mUseServerParser));
        return this.mSyncQueueURL != null && this.mReportQueueURL != null;
    }

    private void checkExpiration(XMLInterface expires) {
        if (expires != null) {
            String date = expires.getContents();
            this.mExpiry = StringTools.figureDate(date, "yyyy-MM-dd'T'HH:mm:ssZ");
            if (this.mExpiry == null || this.mExpiry.getDate() == null || this.mExpiry.getDate().before(new Date())) {
                JConfig.setConfiguration("my.jbidwatcher.enabled", "false");
            } else {
                JConfig.setConfiguration("my.jbidwatcher.enabled", "true");
            }
        }
    }

    private static StringBuffer getRawAccountXML(String username, String password) {
        String suffix = JConfig.queryConfiguration("ebay.browse.site");
        suffix = suffix != null && !suffix.equals("0") ? "?browse_to=" + suffix : "";
        Http http = new Http();
        http.setAuthInfo(username, password);
        return http.get("https://my.jbidwatcher.com/services/account" + suffix);
    }

    private static boolean getBoolean(XMLInterface x) {
        String contents;
        boolean rval = false;
        if (x != null && (contents = x.getContents()) != null) {
            rval = contents.equals("true");
        }
        return rval;
    }

    public boolean createAccount(String email, String password) {
        return false;
    }
}

