/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.jbidwatcher.ui.SwingMessageQueue;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.MessageQueue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.LineBorder;

class TabStatusPanel
extends JPanel {
    private JLabel mStatus;
    private JProgressBar mLoadProgress;

    public TabStatusPanel(String tabName) {
        super(new BorderLayout());
        this.setBorder(LineBorder.createBlackLineBorder());
        this.mStatus = new JLabel("Status area");
        this.mStatus.setHorizontalAlignment(0);
        this.mStatus.setBackground(Color.decode("#FFFE9C"));
        JButton closeButton = new JButton("x");
        closeButton.setOpaque(false);
        closeButton.setBorderPainted(false);
        closeButton.setFocusable(false);
        closeButton.setMargin(new Insets(0, 0, 0, 0));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabStatusPanel.this.setVisible(false);
            }
        });
        this.mLoadProgress = new JProgressBar(0, 99);
        this.mLoadProgress.setVisible(false);
        this.add((Component)this.mLoadProgress, "West");
        this.add((Component)this.mStatus, "Center");
        this.add((Component)closeButton, "East");
        this.setBackground(Color.decode("#FFFE9C"));
        this.setOpaque(true);
        this.setVisible(false);
        String queueName = tabName + " Tab";
        MQFactory.addQueue(queueName, new SwingMessageQueue());
        MQFactory.getConcrete(queueName).registerListener(new MessageQueue.Listener(){

            @Override
            public void messageAction(Object deQ) {
                String cmd = deQ.toString();
                if (cmd.equals("HIDE")) {
                    TabStatusPanel.this.setVisible(false);
                }
                if (cmd.equals("SHOW")) {
                    TabStatusPanel.this.setVisible(true);
                }
                if (cmd.startsWith("PROGRESS")) {
                    TabStatusPanel.this.markProgress(cmd, TabStatusPanel.this.mLoadProgress);
                }
                if (cmd.startsWith("REPORT")) {
                    TabStatusPanel.this.mStatus.setText(cmd.substring(7));
                    TabStatusPanel.this.setVisible(true);
                }
            }
        });
    }

    private void markProgress(String cmd, JProgressBar loadProgress) {
        if (cmd.length() < 9) {
            loadProgress.setVisible(!loadProgress.isVisible());
        } else {
            String levelCmd = cmd.substring(9);
            int level = loadProgress.getValue();
            try {
                level = Integer.parseInt(levelCmd);
            }
            catch (NumberFormatException e) {
                loadProgress.setStringPainted(true);
                loadProgress.setString(levelCmd);
            }
            loadProgress.setValue(level);
        }
    }
}

