/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;

public class SearchField
extends JTextField {
    private static final Border CANCEL_BORDER = new CancelBorder();
    private boolean sendsNotificationForEachKeystroke = false;
    private boolean showingPlaceholderText = false;
    private boolean armed = false;

    public SearchField(String placeholderText, int length) {
        super(length);
        this.addFocusListener(new PlaceholderText(placeholderText));
        this.initBorder();
        this.initKeyListener();
    }

    public SearchField(String placeholderText) {
        this(placeholderText, 15);
    }

    public SearchField() {
        this("Search");
    }

    private void initBorder() {
        this.setBorder(new CompoundBorder(this.getBorder(), CANCEL_BORDER));
        CancelListener mouseInputListener = new CancelListener();
        this.addMouseListener(mouseInputListener);
        this.addMouseMotionListener(mouseInputListener);
    }

    private void initKeyListener() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    SearchField.this.cancel();
                } else if (SearchField.this.sendsNotificationForEachKeystroke) {
                    SearchField.this.maybeNotify();
                }
            }
        });
    }

    private void cancel() {
        this.setText("");
        this.postActionEvent();
    }

    private void maybeNotify() {
        if (this.showingPlaceholderText) {
            return;
        }
        this.postActionEvent();
    }

    public void setSendsNotificationForEachKeystroke(boolean eachKeystroke) {
        this.sendsNotificationForEachKeystroke = eachKeystroke;
    }

    class PlaceholderText
    implements FocusListener {
        private String placeholderText;
        private String previousText = "";
        private Color previousColor;

        PlaceholderText(String placeholderText) {
            this.placeholderText = placeholderText;
            this.focusLost(null);
        }

        @Override
        public void focusGained(FocusEvent e) {
            SearchField.this.setForeground(this.previousColor);
            SearchField.this.setText(this.previousText);
            SearchField.this.showingPlaceholderText = false;
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.previousText = SearchField.this.getText();
            this.previousColor = SearchField.this.getForeground();
            if (this.previousText.length() == 0) {
                SearchField.this.showingPlaceholderText = true;
                SearchField.this.setForeground(Color.GRAY);
                SearchField.this.setText(this.placeholderText);
            }
        }
    }

    class CancelListener
    extends MouseInputAdapter {
        CancelListener() {
        }

        private boolean isOverButton(MouseEvent e) {
            if (!SearchField.this.contains(e.getPoint())) {
                return false;
            }
            Rectangle innerArea = SwingUtilities.calculateInnerArea(SearchField.this, null);
            return !innerArea.contains(e.getPoint());
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.arm(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.arm(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.disarm();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.arm(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SearchField.this.armed) {
                SearchField.this.cancel();
            }
            this.disarm();
        }

        private void arm(MouseEvent e) {
            SearchField.this.armed = this.isOverButton(e) && SwingUtilities.isLeftMouseButton(e);
            SearchField.this.repaint();
        }

        private void disarm() {
            SearchField.this.armed = false;
            SearchField.this.repaint();
        }
    }

    static class CancelBorder
    extends EmptyBorder {
        private static final Color GRAY = new Color(0.7f, 0.7f, 0.7f);

        CancelBorder() {
            super(0, 0, 0, 15);
        }

        @Override
        public void paintBorder(Component c, Graphics oldGraphics, int x, int y, int width, int height) {
            SearchField field = (SearchField)c;
            if (field.showingPlaceholderText || field.getText().length() == 0) {
                return;
            }
            Graphics2D g = (Graphics2D)oldGraphics;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int circleL = 14;
            int circleX = x + width - 14;
            int circleY = y + (height - 1 - 14) / 2;
            g.setColor(field.armed ? Color.GRAY : GRAY);
            g.fillOval(circleX, circleY, 14, 14);
            int lineL = 6;
            int lineX = circleX + 4;
            int lineY = circleY + 4;
            g.setColor(Color.WHITE);
            g.drawLine(lineX, lineY, lineX + 6, lineY + 6);
            g.drawLine(lineX, lineY + 6, lineX + 6, lineY);
        }
    }
}

