/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util.queue;

import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.MessageQueue;
import com.jbidwatcher.util.queue.PlainMessageQueue;
import com.jbidwatcher.util.queue.QObject;
import com.jbidwatcher.util.queue.TimeQueue;
import com.jbidwatcher.util.queue.TimerHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TimeQueueManager
implements TimerHandler.WakeupProcess {
    protected TimeQueue mTQ = new TimeQueue();

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }

    @Override
    public boolean check() {
        Object deQ;
        while ((deQ = this.mTQ.getAnyLessThan(this.getCurrentTime() + 900L)) != null) {
            TQCarrier interim = (TQCarrier)deQ;
            MessageQueue q = MQFactory.getConcrete(interim.getDestinationQueue());
            Object payload = interim.getPayload();
            if (payload instanceof QObject) {
                q.enqueueBean((QObject)payload);
            } else if (payload instanceof String) {
                q.enqueue((String)payload);
            } else if (q instanceof PlainMessageQueue) {
                ((PlainMessageQueue)q).enqueueObject(interim.getPayload());
            } else {
                JConfig.log().logDebug("Submitting: " + payload.toString() + " to " + q.toString() + " will probably fail.");
                q.enqueue(payload.toString());
            }
            if (interim.getRepeatRate() == 0L) continue;
            if (interim.getRepeatCount() > 0L) {
                interim.decrementCount();
            }
            if (interim.getRepeatCount() == 0L) continue;
            this.mTQ.addEvent(this.getCurrentTime() + interim.getRepeatRate(), interim);
        }
        return false;
    }

    private TQCarrier createCarrier(Object payload, String destination, long repeat, int howmany) {
        return new TQCarrier(payload, destination, repeat, howmany);
    }

    public void add(Object payload, String destination, long when) {
        this.mTQ.addEvent(when, this.createCarrier(payload, destination, 0L, 1));
    }

    public void add(Object payload, String destination, long when, long repeat) {
        this.mTQ.addEvent(when, this.createCarrier(payload, destination, repeat, -1));
    }

    public void add(Object payload, String destination, long when, long repeat, int howmany) {
        this.mTQ.addEvent(when, this.createCarrier(payload, destination, repeat, howmany));
    }

    public boolean erase(Object payload) {
        ArrayList<TimeQueue.QObject> doErase = new ArrayList<TimeQueue.QObject>();
        List current = this.mTQ.getUnsorted();
        boolean didErase = false;
        for (Object aCurrent : current) {
            TimeQueue.QObject tqo = (TimeQueue.QObject)aCurrent;
            TQCarrier event = (TQCarrier)tqo.getEvent();
            if (event.getPayload() != payload && !event.getPayload().equals(payload)) continue;
            doErase.add(tqo);
            didErase = true;
        }
        if (didErase) {
            for (TimeQueue.QObject delMe : doErase) {
                this.mTQ.erase(delMe);
            }
        }
        return didErase;
    }

    public boolean contains(Matcher m) {
        for (Object o : this.mTQ.getUnsorted()) {
            TimeQueue.QObject qo = (TimeQueue.QObject)o;
            TQCarrier carrier = (TQCarrier)qo.getEvent();
            if (!m.match(carrier.getPayload(), carrier.getDestinationQueue(), qo.getTime())) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Object payload) {
        for (Object o : this.mTQ.getUnsorted()) {
            TimeQueue.QObject qo = (TimeQueue.QObject)o;
            TQCarrier carrier = (TQCarrier)qo.getEvent();
            if (!payload.equals(carrier.getPayload())) continue;
            return true;
        }
        return false;
    }

    public void dumpQueue(String prefix) {
        List current = this.mTQ.getSorted();
        if (current.isEmpty()) {
            JConfig.log().logDebug(prefix + ": queue empty");
        }
        for (Object aCurrent : current) {
            TimeQueue.QObject step = (TimeQueue.QObject)aCurrent;
            TQCarrier event = (TQCarrier)step.getEvent();
            JConfig.log().logDebug(prefix + ": Queue: " + event.getDestinationQueue());
            JConfig.log().logDebug(prefix + ": Object: [" + event.getPayload() + "]");
            JConfig.log().logDebug(prefix + ": When: " + new Date(step.getTime()));
            JConfig.log().logDebug("--");
        }
    }

    public static interface Matcher {
        public boolean match(Object var1, Object var2, long var3);
    }

    protected class TQCarrier {
        private Object payload;
        private String destination_queue;
        private long repeatRate;
        private int repeatCount;

        public Object getPayload() {
            return this.payload;
        }

        public String getDestinationQueue() {
            return this.destination_queue;
        }

        public long getRepeatRate() {
            return this.repeatRate;
        }

        public long getRepeatCount() {
            return this.repeatCount;
        }

        public void decrementCount() {
            --this.repeatCount;
        }

        public TQCarrier(Object o, String s, long r, int c) {
            this.destination_queue = s;
            this.payload = o;
            this.repeatRate = r;
            this.repeatCount = c;
        }
    }
}

