/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tessboxeditor.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import net.sourceforge.tessboxeditor.datamodel.TessBox;
import net.sourceforge.tessboxeditor.datamodel.TessBoxCollection;
import net.sourceforge.vietocr.util.Utils;

public class JImageLabel
extends JLabel {
    private TessBoxCollection boxes;
    private JTable table;
    private boolean boxClickAction;

    public JImageLabel() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (JImageLabel.this.boxes == null) {
                    return;
                }
                TessBox tessBox = JImageLabel.this.boxes.hitObject(mouseEvent.getPoint());
                if (tessBox == null) {
                    if (!mouseEvent.isControlDown()) {
                        JImageLabel.this.boxes.deselectAll();
                        JImageLabel.this.repaint();
                        JImageLabel.this.table.clearSelection();
                    }
                } else {
                    if (!mouseEvent.isControlDown()) {
                        JImageLabel.this.boxes.deselectAll();
                        JImageLabel.this.table.clearSelection();
                    }
                    tessBox.setSelected(!tessBox.isSelected());
                    JImageLabel.this.repaint();
                    JImageLabel.this.boxClickAction = true;
                    List<TessBox> list = JImageLabel.this.boxes.toList();
                    for (TessBox tessBox2 : JImageLabel.this.boxes.getSelectedBoxes()) {
                        int n = list.indexOf(tessBox2);
                        JImageLabel.this.table.addRowSelectionInterval(n, n);
                        Rectangle rectangle = JImageLabel.this.table.getCellRect(n, 0, true);
                        JImageLabel.this.table.scrollRectToVisible(rectangle);
                    }
                    JImageLabel.this.boxClickAction = false;
                }
            }
        });
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.boxes == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.BLUE);
        boolean bl = false;
        for (TessBox tessBox : this.boxes.toList()) {
            if (tessBox.isSelected()) {
                graphics2D.setStroke(new BasicStroke(2.0f));
                graphics2D.setColor(Color.RED);
                bl = true;
            }
            Rectangle rectangle = tessBox.getRect();
            graphics2D.draw(rectangle);
            if (!bl) continue;
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setColor(Color.BLUE);
            bl = false;
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        if (this.boxes != null) {
            TessBox tessBox = this.boxes.hitObject(new Point(n, n2));
            if (tessBox != null) {
                String string = tessBox.getChrs();
                this.setToolTipText(String.format("<html><h1><font face=\"%s\" >%s</font> : %s</h1></html>", this.getFont().getName(), string, Utils.toHex(string)));
            } else {
                this.setToolTipText(null);
            }
        }
        return super.contains(n, n2);
    }

    public void setBoxes(TessBoxCollection tessBoxCollection) {
        this.boxes = tessBoxCollection;
        this.repaint();
    }

    public void setTable(JTable jTable) {
        this.table = jTable;
    }

    public boolean isBoxClickAction() {
        return this.boxClickAction;
    }
}

