/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vietpad.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.vietpad.components.OpenList;

public class FontDialog
extends JDialog {
    static final boolean MAC_OS_X = System.getProperty("os.name").startsWith("Mac");
    private OpenList m_lstFontName;
    private OpenList m_lstFontStyle;
    private OpenList m_lstFontSize;
    private JLabel m_preview;
    private final ResourceBundle bundle;
    private Font curFont;
    private boolean m_succeeded = false;
    private JComboBox combo;
    protected final File baseDir = FontDialog.getBaseDir(this);
    private static final Logger logger = Logger.getLogger(FontDialog.class.getName());

    public FontDialog(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.setLocale(jFrame.getLocale());
        this.bundle = ResourceBundle.getBundle("net.sourceforge.vietpad.components.FontDialog");
        this.setTitle(this.bundle.getString("this.Title"));
        this.setResizable(false);
        this.initComponents();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
    }

    private void initComponents() {
        Object[] iOException;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(5, 10, 11, 9));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, -2, 0, -2));
        Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Font font : fontArray) {
            treeSet.add(font.getFamily());
        }
        this.m_lstFontName = new OpenList(treeSet.toArray(), this.bundle.getString("Name"));
        jPanel2.add(this.m_lstFontName);
        this.m_lstFontStyle = new OpenList(new String[]{"Regular", "Bold", "Italic", "Bold Italic"}, this.bundle.getString("Style"), 11);
        jPanel2.add(this.m_lstFontStyle);
        this.m_lstFontSize = new OpenList(new String[]{"9", "10", "11", "12", "13", "14", "18", "24", "36", "48", "64", "72", "96"}, this.bundle.getString("Size"), 5);
        jPanel2.add(this.m_lstFontSize);
        jPanel.add(jPanel2);
        this.m_lstFontName.setPreferredSizeList(this.m_lstFontStyle.getPreferredSizeList());
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FontDialog.this.updatePreview();
                    }
                });
            }
        };
        this.m_lstFontName.addListSelectionListener(listSelectionListener);
        this.m_lstFontStyle.addListSelectionListener(listSelectionListener);
        this.m_lstFontSize.addListSelectionListener(listSelectionListener);
        this.m_lstFontSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FontDialog.this.updatePreview();
                    }
                });
            }
        });
        jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(), this.bundle.getString("Preview")));
        this.m_preview = new JLabel("The quick brown fox jumps over the lazy dog.", 0);
        this.m_preview.setBackground(Color.white);
        this.m_preview.setForeground(Color.black);
        this.m_preview.setOpaque(true);
        this.m_preview.setBorder(new LineBorder(Color.black));
        this.m_preview.setPreferredSize(new Dimension(120, 70));
        jPanel2.add(this.m_preview);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(9));
        jPanel2 = new JPanel(null);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        final Properties properties = new Properties();
        try {
            iOException = new File(this.baseDir, "data/pangram.xml");
            properties.loadFromXML(new FileInputStream((File)iOException));
        }
        catch (IOException exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage(), "Font Dialog", 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        iOException = properties.stringPropertyNames().toArray();
        Arrays.sort(iOException);
        this.combo = new JComboBox<Object>(iOException);
        this.combo.setSelectedItem("English");
        this.combo.setToolTipText("Language");
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog.this.m_preview.setText(properties.getProperty(FontDialog.this.combo.getSelectedItem().toString()));
            }
        });
        jPanel2.add(this.combo);
        jPanel2.add(Box.createHorizontalGlue());
        JButton jButton = new JButton(this.bundle.getString("btOK.Text"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog.this.m_succeeded = true;
                FontDialog.this.dispose();
            }
        });
        JButton jButton2 = new JButton(this.bundle.getString("btCancel.Text"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog.this.dispose();
            }
        });
        if (MAC_OS_X) {
            jPanel2.add(jButton2);
            jPanel2.add(Box.createHorizontalStrut(7));
            jPanel2.add(jButton);
        } else {
            jPanel2.add(jButton);
            jPanel2.add(Box.createHorizontalStrut(5));
            jPanel2.add(jButton2);
            jPanel2.add(Box.createHorizontalStrut(2));
        }
        jPanel.add(jPanel2);
        this.getContentPane().add(jPanel);
        this.rootPane.setDefaultButton(jButton);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void setAttributes(Font font) {
        String string;
        this.m_lstFontName.setSelected(font.getName());
        this.m_lstFontSize.setSelectedInt(font.getSize());
        switch (font.getStyle()) {
            case 3: {
                string = "Bold Italic";
                break;
            }
            case 1: {
                string = "Bold";
                break;
            }
            case 2: {
                string = "Italic";
                break;
            }
            default: {
                string = "Regular";
            }
        }
        this.m_lstFontStyle.setSelected(string);
        this.updatePreview();
    }

    public boolean succeeded() {
        return this.m_succeeded;
    }

    @Override
    public Font getFont() {
        return this.curFont;
    }

    protected void updatePreview() {
        String string = this.m_lstFontName.getSelected();
        int n = this.m_lstFontSize.getSelectedInt();
        if (n <= 0) {
            return;
        }
        int n2 = this.m_lstFontStyle.getSelectedIndex();
        Font font = new Font(string, n2, n);
        this.m_preview.setFont(font);
        this.m_preview.repaint();
        this.curFont = font;
    }

    public void setPreviewText(String string) {
        this.m_preview.setText(string);
    }

    public void setSelectedLanguage(String string) {
        this.combo.setSelectedItem(string);
    }

    public static File getBaseDir(Object object) {
        URL uRL = object.getClass().getResource("/" + object.getClass().getName().replaceAll("\\.", "/") + ".class");
        File file = new File(System.getProperty("user.dir"));
        try {
            if (uRL.toString().startsWith("jar:")) {
                uRL = new URL(uRL.toString().replaceFirst("^jar:", "").replaceFirst("/[^/]+.jar!.*$", ""));
                file = new File(uRL.toURI());
            }
        }
        catch (MalformedURLException | URISyntaxException exception) {
            logger.log(Level.WARNING, exception.getMessage(), exception);
        }
        return file;
    }
}

