/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.api.HealthCheck;
import net.sourceforge.plantuml.api.Performance;

public abstract class Log {
    private static final long start = System.currentTimeMillis();
    private static String header;

    public static synchronized void debug(String string) {
    }

    public static synchronized void info(String string) {
        if (OptionFlags.getInstance().isVerbose()) {
            System.out.println(Log.format(string));
        }
    }

    public static synchronized void error(String string) {
        System.err.println(string);
    }

    private static String format(String string) {
        long l = System.currentTimeMillis() - start;
        HealthCheck healthCheck = Performance.getHealthCheck();
        long l2 = healthCheck.jvmCpuTime() / 1000L / 1000L;
        long l3 = healthCheck.dotTime().getSum();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(l / 1000L);
        stringBuilder.append(".");
        stringBuilder.append(String.format("%03d", l % 1000L));
        if (l2 != -1L) {
            stringBuilder.append(" - ");
            stringBuilder.append(l2 / 1000L);
            stringBuilder.append(".");
            stringBuilder.append(String.format("%03d", l2 % 1000L));
        }
        stringBuilder.append(" - ");
        stringBuilder.append(l3 / 1000L);
        stringBuilder.append(".");
        stringBuilder.append(String.format("%03d", l3 % 1000L));
        stringBuilder.append("(");
        stringBuilder.append(healthCheck.dotTime().getNb());
        stringBuilder.append(")");
        stringBuilder.append(" - ");
        long l4 = healthCheck.totalMemory() / 1024L / 1024L;
        long l5 = healthCheck.freeMemory() / 1024L / 1024L;
        stringBuilder.append(l4);
        stringBuilder.append(" Mo) ");
        stringBuilder.append(l5);
        stringBuilder.append(" Mo - ");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static void println(Object object) {
        if (header == null) {
            System.err.println("L = " + object);
        } else {
            System.err.println(header + " " + object);
        }
    }

    public static void header(String string) {
        header = string;
    }
}

