/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sourceforge.schemaspy.model.xml.ForeignKeyMeta;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableColumnMeta {
    private final String name;
    private final String comments;
    private final boolean isPrimary;
    private final List<ForeignKeyMeta> foreignKeys = new ArrayList<ForeignKeyMeta>();
    private final boolean isExcluded;
    private final boolean isAllExcluded;
    private final boolean isImpliedParentsDisabled;
    private final boolean isImpliedChildrenDisabled;
    private static final Logger logger = Logger.getLogger(TableColumnMeta.class.getName());

    TableColumnMeta(Node node) {
        String string;
        NamedNodeMap namedNodeMap = node.getAttributes();
        this.name = namedNodeMap.getNamedItem("name").getNodeValue();
        Node node2 = namedNodeMap.getNamedItem("comments");
        this.comments = node2 != null ? ((string = node2.getNodeValue().trim()).length() == 0 ? null : string) : null;
        node2 = namedNodeMap.getNamedItem("primaryKey");
        this.isPrimary = node2 != null ? this.evalBoolean(node2.getNodeValue()) : false;
        node2 = namedNodeMap.getNamedItem("disableImpliedKeys");
        if (node2 != null) {
            string = node2.getNodeValue().trim().toLowerCase();
            if (string.equals("to")) {
                this.isImpliedChildrenDisabled = true;
                this.isImpliedParentsDisabled = false;
            } else if (string.equals("from")) {
                this.isImpliedParentsDisabled = true;
                this.isImpliedChildrenDisabled = false;
            } else if (string.equals("all")) {
                this.isImpliedParentsDisabled = true;
                this.isImpliedChildrenDisabled = true;
            } else {
                this.isImpliedParentsDisabled = false;
                this.isImpliedChildrenDisabled = false;
            }
        } else {
            this.isImpliedParentsDisabled = false;
            this.isImpliedChildrenDisabled = false;
        }
        node2 = namedNodeMap.getNamedItem("disableDiagramAssociations");
        if (node2 != null) {
            string = node2.getNodeValue().trim().toLowerCase();
            if (string.equals("all")) {
                this.isAllExcluded = true;
                this.isExcluded = true;
            } else if (string.equals("exceptdirect")) {
                this.isAllExcluded = false;
                this.isExcluded = true;
            } else {
                this.isAllExcluded = false;
                this.isExcluded = false;
            }
        } else {
            this.isAllExcluded = false;
            this.isExcluded = false;
        }
        logger.finer("Found XML column metadata for " + this.name + " isPrimaryKey: " + this.isPrimary + " comments: " + this.comments);
        NodeList nodeList = ((Element)((Object)node.getChildNodes())).getElementsByTagName("foreignKey");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            this.foreignKeys.add(new ForeignKeyMeta(node3));
        }
    }

    private boolean evalBoolean(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.trim().toLowerCase()).equals("true") || string.equals("yes") || string.equals("1");
    }

    public String getName() {
        return this.name;
    }

    public String getComments() {
        return this.comments;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public List<ForeignKeyMeta> getForeignKeys() {
        return this.foreignKeys;
    }

    public boolean isExcluded() {
        return this.isExcluded;
    }

    public boolean isAllExcluded() {
        return this.isAllExcluded;
    }

    public boolean isImpliedParentsDisabled() {
        return this.isImpliedParentsDisabled;
    }

    public boolean isImpliedChildrenDisabled() {
        return this.isImpliedChildrenDisabled;
    }
}

