/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.view.DotConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotConnectorFinder {
    private static DotConnectorFinder instance = new DotConnectorFinder();

    private DotConnectorFinder() {
    }

    public static DotConnectorFinder getInstance() {
        return instance;
    }

    public Set<DotConnector> getRelatedConnectors(Table table, boolean bl) {
        HashSet<DotConnector> hashSet = new HashSet<DotConnector>();
        for (TableColumn tableColumn : table.getColumns()) {
            hashSet.addAll(this.getRelatedConnectors(tableColumn, null, false, bl));
        }
        return hashSet;
    }

    public Set<DotConnector> getRelatedConnectors(Table table, Table table2, boolean bl, boolean bl2) {
        HashSet<DotConnector> hashSet = new HashSet<DotConnector>();
        for (TableColumn tableColumn : table.getColumns()) {
            hashSet.addAll(this.getRelatedConnectors(tableColumn, table2, bl, bl2));
        }
        for (TableColumn tableColumn : table2.getColumns()) {
            hashSet.addAll(this.getRelatedConnectors(tableColumn, table, bl, bl2));
        }
        return hashSet;
    }

    private Set<DotConnector> getRelatedConnectors(TableColumn tableColumn, Table table, boolean bl, boolean bl2) {
        boolean bl3;
        Table table2;
        HashSet<DotConnector> hashSet = new HashSet<DotConnector>();
        if (!bl && tableColumn.isExcluded()) {
            return hashSet;
        }
        for (TableColumn tableColumn2 : tableColumn.getParents()) {
            table2 = tableColumn2.getTable();
            if (table != null && table2 != table || table == null && !bl && tableColumn2.isExcluded() || (bl3 = tableColumn.getParentConstraint(tableColumn2).isImplied()) && !bl2) continue;
            hashSet.add(new DotConnector(tableColumn2, tableColumn, bl3));
        }
        for (TableColumn tableColumn2 : tableColumn.getChildren()) {
            table2 = tableColumn2.getTable();
            if (table != null && table2 != table || table == null && !bl && tableColumn2.isExcluded() || (bl3 = tableColumn.getChildConstraint(tableColumn2).isImplied()) && !bl2) continue;
            hashSet.add(new DotConnector(tableColumn, tableColumn2, bl3));
        }
        return hashSet;
    }
}

