/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher;

import com.jbidwatcher.UpdaterEntry;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.MessageQueue;
import com.jbidwatcher.util.queue.TimerHandler;

public class UpdateManager
implements TimerHandler.WakeupProcess,
MessageQueue.Listener {
    private static UpdateManager _instance = null;
    private static UpdaterEntry _ue = null;

    private UpdateManager() {
    }

    public static UpdateManager getInstance() {
        if (_instance == null) {
            _instance = new UpdateManager();
            MQFactory.getConcrete("update").registerListener(_instance);
        }
        return _instance;
    }

    @Override
    public void messageAction(Object deQ) {
        boolean interactive = false;
        if (deQ.equals("INTERACTIVE")) {
            interactive = true;
        }
        UpdateManager.checkUpdate(interactive);
    }

    public UpdaterEntry getUpdateInfo() {
        return _ue;
    }

    @Override
    public boolean check() {
        if (JConfig.queryConfiguration("updates.enabled", "true").equals("true")) {
            UpdateManager.checkUpdate(false);
        }
        return true;
    }

    public static void checkUpdate(boolean interactive) {
        MQFactory.getConcrete("Swing").enqueue("Checking for a newer version.");
        UpdaterEntry ue = new UpdaterEntry("JBidwatcher", "http://www.jbidwatcher.com/jbidwatcher2.xml");
        if (!ue.isValid()) {
            MQFactory.getConcrete("Swing").enqueue("NOTIFY Failure checking for update.");
            if (interactive) {
                MQFactory.getConcrete("Swing").enqueue("BAD_NEWVERSION");
            }
            return;
        }
        String lastKnownVersion = JConfig.queryConfiguration("updates.last_version", null);
        if (lastKnownVersion == null) {
            lastKnownVersion = "2.99pre5";
        }
        if (!lastKnownVersion.equals(ue.getVersion())) {
            JConfig.setConfiguration("updates.last_version", ue.getVersion());
            if (!"2.99pre5".equals(ue.getVersion())) {
                _ue = ue;
                MQFactory.getConcrete("Swing").enqueue("NEWVERSION");
                MQFactory.getConcrete("Swing").enqueue("Found a new version available!");
                return;
            }
        }
        if (interactive) {
            MQFactory.getConcrete("Swing").enqueue("NO_NEWVERSION");
        }
        MQFactory.getConcrete("Swing").enqueue("No new versions on the server.");
        if ("2.99pre5".equals(ue.getVersion()) && ue.hasConfigurationUpdates() && JConfig.queryConfiguration("updates.allowConfig", "true").equals("true")) {
            ue.applyConfigurationUpdates();
        }
    }
}

