/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction.server.ebay;

import com.jbidwatcher.auction.ItemParser;
import com.jbidwatcher.auction.server.ebay.DeprecatedEbayAuction;
import com.jbidwatcher.util.Record;
import com.jbidwatcher.util.StringTools;
import com.jbidwatcher.util.TT;
import com.jbidwatcher.util.html.JHTML;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ebayItemParser
implements ItemParser {
    protected DeprecatedEbayAuction deprecated = null;
    protected TT T;
    Map<String, String> microFormat = null;
    protected JHTML mDocument;
    protected Document mDocument2;
    protected StringBuffer mBuffer;
    protected Record updateData;
    protected Record highBidderData;

    public ebayItemParser(TT countryProperties, StringBuffer sb, Record updateData, Record highBidderData) {
        this.T = countryProperties;
        this.deprecated = new DeprecatedEbayAuction(this.T);
        this.mBuffer = sb;
    }

    @Override
    public Record parseItemDetails() {
        String endDate;
        this.mDocument2 = Jsoup.parse((String)this.mBuffer.toString());
        this.deprecated.setPage(this.mBuffer);
        this.mDocument = new JHTML(this.mBuffer);
        this.microFormat = this.mDocument.extractMicroformat();
        Record parse = new Record();
        parse.put("title", this.extractMicroformatInfo("title"));
        parse.put("price", this.extractMicroformatInfo("price"));
        this.insertChild(parse, "price", this.parsePrices());
        parse.put("thumbnail_url", this.parseThumbnailURL());
        parse.put("url", this.parseURL());
        try {
            parse.put("location", this.parseLocation());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            parse.put("paypal", Boolean.toString(this.supportsPaypal()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.insertChild(parse, "feedback", this.deprecated.parseFeedback(this.mDocument));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.insertChild(parse, "shipping", this.deprecated.parseShippingInsurance(this.mDocument));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            parse.put("seller", this.deprecated.parseSeller(this.mDocument));
        }
        catch (Exception exception) {
            // empty catch block
        }
        parse.put("fixed", Boolean.toString(parse.containsKey("price.bin") && !parse.containsKey("price.current")));
        boolean privateListing = this.parsePrivate();
        parse.put("private", Boolean.toString(privateListing));
        parse.put("high_bidder", privateListing ? "(private)" : this.parseHighBidder());
        boolean reserve = this.parseReserveNotMet();
        parse.put("reserve", Boolean.toString(reserve));
        if (reserve) {
            parse.put("reserve_met", "false");
        }
        if ((endDate = this.parseEndDate()) == null) {
            endDate = this.getAlternateEndDate();
        }
        System.out.println("Date format: " + endDate);
        parse.put("ending_at", endDate);
        parse.put("identifier", this.parseIdentifier());
        Record complex = this.deprecated.getBidCount(this.mDocument, 1);
        parse.put("bid_count", complex.get("bid_count"));
        if (this.mDocument.grep(this.T.s("ebayServer.ended")) != null) {
            parse.put("complete", "true");
        }
        return parse;
    }

    @Nullable
    private String getAlternateEndDate() {
        String endDate = null;
        String time = null;
        Element timeMs = this.mDocument2.select("span.timeMs").first();
        if (timeMs != null) {
            time = timeMs.attr("timems");
            System.out.println("Alt time: " + time);
        }
        if (time != null) {
            SimpleDateFormat df = new SimpleDateFormat(this.T.s("ebayServer.itemDateFormat"));
            endDate = df.format(new Date(Long.parseLong(time)));
        }
        return endDate;
    }

    private boolean supportsPaypal() {
        boolean paypal = this.deprecated.parsePaypal(this.mDocument);
        paypal = paypal || !this.mDocument2.select(":containsOwn(Payments:)").parents().first().select("[alt=PayPal]").isEmpty();
        return paypal;
    }

    private boolean parseFixedPrice() {
        return this.mDocument.hasSequence("Price:", ".*", "(?i)Buy.It.Now") || !this.mDocument2.select("input[value=Buy It Now]").isEmpty();
    }

    private String parseEndDate() {
        Elements endedDates;
        Elements leaves = this.mDocument2.getElementsContainingOwnText("Time left:");
        if (leaves != null && !leaves.isEmpty()) {
            for (Element leaf : leaves) {
                Elements lastly;
                Element parent = leaf.parent();
                Elements kids = parent.getElementsMatchingOwnText("^\\(.*");
                if (kids == null || kids.isEmpty() || (lastly = kids.first().parent().getElementsMatchingOwnText("^.*\\)$")) == null || lastly.isEmpty()) continue;
                String endDate = kids.first().text() + " " + lastly.text();
                endDate = endDate.replaceAll("\\(|\\)", "");
                return endDate;
            }
        }
        if (!(endedDates = this.mDocument2.select(".endedDate")).isEmpty()) {
            for (Element e : endedDates) {
                if (!"Ended:".equals(e.parent().parent().previousElementSibling().text())) continue;
                return e.parent().text();
            }
        }
        return null;
    }

    private Record parsePrices() {
        Elements offers = this.mDocument2.select("[itemprop=offers]");
        if (offers.first() == null) {
            Record r = this.checkTwitterMicroformat();
            if (r.isEmpty()) {
                return this.deprecated.parsePrices(this.mDocument);
            }
            return r;
        }
        Record record = new Record();
        String optional_conversion = "";
        String price = offers.first().select("[itemprop=price]").text();
        String convertedBinPrice = offers.select(".convPrice #binPrice").text();
        String convertedBidPrice = offers.select(".convPrice #bidPrice").text();
        String key = "current";
        boolean minimum = false;
        if (offers.size() == 1) {
            boolean auction;
            boolean bl = auction = !this.parseFixedPrice();
            if (auction) {
                optional_conversion = convertedBidPrice;
            } else {
                key = "bin";
                optional_conversion = convertedBinPrice;
            }
        } else if (offers.size() == 2) {
            record.put("bin", offers.last().select("[itemprop=price]").text());
            if (convertedBinPrice.length() != 0) {
                record.put("bin_us", convertedBinPrice);
            }
            minimum = true;
            optional_conversion = convertedBidPrice;
        }
        record.put("minimum", Boolean.toString(minimum));
        record.put(key, price);
        if (optional_conversion.length() != 0) {
            record.put(key + "_us", optional_conversion);
        }
        return record;
    }

    private Record checkTwitterMicroformat() {
        Record r = new Record();
        Elements twitter = this.mDocument2.select("meta[name=twitter:text:price]");
        if (twitter.isEmpty() && !(twitter = this.mDocument2.select("meta[name=twitter:label1,content=Price]")).isEmpty()) {
            twitter = this.mDocument2.select("meta[name=twitter:data1]");
        }
        if (!twitter.isEmpty()) {
            r.put("current", twitter.first().attr("content"));
        }
        return r;
    }

    private void insertChild(Record parent, String prefix, Record child) {
        for (String key : child.keySet()) {
            parent.put(prefix + "." + key, child.get(key));
        }
    }

    private String extractMicroformatInfo(String key) {
        String value = this.microFormat.get(key);
        if (value == null || value.length() == 0) {
            value = this.mDocument2.select("meta[property=og:" + key + "]").attr("content");
        }
        return StringTools.nullSafe(value);
    }

    private String parseURL() {
        String url = this.extractMicroformatInfo("url");
        if (url.length() == 0) {
            url = this.mDocument2.select("link[rel=canonical]").attr("href");
        }
        return url;
    }

    private String parseThumbnailURL() {
        String thumbnailURL = this.extractMicroformatInfo("image");
        if (thumbnailURL.matches(".*_\\d+\\.[a-zA-Z]+")) {
            thumbnailURL = thumbnailURL.replaceFirst("_\\d+\\.", "_10.");
        }
        return thumbnailURL;
    }

    private String parseLocation() {
        String location = StringTools.nullSafe(this.mDocument.getNextContentAfterRegex(this.T.s("ebayServer.itemLocationRegex")));
        location = location.replace("Post to: ", "");
        location = StringTools.decode(location, this.mDocument.getCharset());
        return location;
    }

    private boolean parsePrivate() {
        return this.mDocument.grep(this.T.s("ebayServer.privateListing")) != null;
    }

    private boolean parseReserveNotMet() {
        return this.mDocument.hasSequence("Reserve.*", ".*", "not met");
    }

    private String parseIdentifier() {
        int resultIndex = 0;
        JHTML.SequenceResult result = this.mDocument.findSequence("\\d+", ".*[Ii]tem.[nN]umber:.*");
        if (result == null || result.isEmpty()) {
            result = this.mDocument.findSequence("\\s*(e[Bb]ay.)?[Ii]tem.[Nn]umber:\\s*", "\\d+");
            if (result == null || result.isEmpty()) {
                return null;
            }
            resultIndex = 1;
        }
        return (String)result.get(resultIndex);
    }

    private String parseHighBidder() {
        return "not implemented";
    }
}

