/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark;

import com.github.rjeschke.txtmark.HTMLElement;
import java.util.HashMap;
import java.util.HashSet;

class HTML {
    private static final String[] ENTITY_NAMES;
    private static final char[] ENTITY_CHARS;
    private static final String[] LINK_PREFIXES;
    private static final HTMLElement[] BLOCK_ELEMENTS;
    private static final HTMLElement[] UNSAFE_ELEMENTS;
    private static final HashMap<Character, String> encodeMap;
    private static final HashMap<String, Character> decodeMap;
    private static final HashSet<String> HTML_ELEMENTS;
    private static final HashSet<String> HTML_UNSAFE;
    private static final HashSet<String> HTML_BLOCK_ELEMENTS;
    private static final HashSet<String> LINK_PREFIX;

    private HTML() {
    }

    public static boolean isLinkPrefix(String string) {
        return LINK_PREFIX.contains(string);
    }

    public static boolean isEntity(String string) {
        return decodeMap.containsKey(string);
    }

    public static boolean isHtmlElement(String string) {
        return HTML_ELEMENTS.contains(string);
    }

    public static boolean isHtmlBlockElement(String string) {
        return HTML_BLOCK_ELEMENTS.contains(string);
    }

    public static boolean isUnsafeHtmlElement(String string) {
        return HTML_UNSAFE.contains(string);
    }

    static {
        int n;
        ENTITY_NAMES = new String[]{"&Acirc;", "&acirc;", "&acute;", "&AElig;", "&aelig;", "&Agrave;", "&agrave;", "&alefsym;", "&Alpha;", "&alpha;", "&amp;", "&and;", "&ang;", "&apos;", "&Aring;", "&aring;", "&asymp;", "&Atilde;", "&atilde;", "&Auml;", "&auml;", "&bdquo;", "&Beta;", "&beta;", "&brvbar;", "&bull;", "&cap;", "&Ccedil;", "&ccedil;", "&cedil;", "&cent;", "&Chi;", "&chi;", "&circ;", "&clubs;", "&cong;", "&copy;", "&crarr;", "&cup;", "&curren;", "&Dagger;", "&dagger;", "&dArr;", "&darr;", "&deg;", "&Delta;", "&delta;", "&diams;", "&divide;", "&Eacute;", "&eacute;", "&Ecirc;", "&ecirc;", "&Egrave;", "&egrave;", "&empty;", "&emsp;", "&ensp;", "&Epsilon;", "&epsilon;", "&equiv;", "&Eta;", "&eta;", "&ETH;", "&eth;", "&Euml;", "&euml;", "&euro;", "&exist;", "&fnof;", "&forall;", "&frac12;", "&frac14;", "&frac34;", "&frasl;", "&Gamma;", "&gamma;", "&ge;", "&gt;", "&hArr;", "&harr;", "&hearts;", "&hellip;", "&Iacute;", "&iacute;", "&Icirc;", "&icirc;", "&iexcl;", "&Igrave;", "&igrave;", "&image;", "&infin;", "&int;", "&Iota;", "&iota;", "&iquest;", "&isin;", "&Iuml;", "&iuml;", "&Kappa;", "&kappa;", "&Lambda;", "&lambda;", "&lang;", "&laquo;", "&lArr;", "&larr;", "&lceil;", "&ldquo;", "&le;", "&lfloor;", "&lowast;", "&loz;", "&lrm;", "&lsaquo;", "&lsquo;", "&lt;", "&macr;", "&mdash;", "&micro;", "&middot;", "&minus;", "&Mu;", "&mu;", "&nabla;", "&nbsp;", "&ndash;", "&ne;", "&ni;", "&not;", "&notin;", "&nsub;", "&Ntilde;", "&ntilde;", "&Nu;", "&nu;", "&Oacute;", "&oacute;", "&Ocirc;", "&ocirc;", "&OElig;", "&oelig;", "&Ograve;", "&ograve;", "&oline;", "&Omega;", "&omega;", "&Omicron;", "&omicron;", "&oplus;", "&or;", "&ordf;", "&ordm;", "&Oslash;", "&oslash;", "&Otilde;", "&otilde;", "&otimes;", "&Ouml;", "&ouml;", "&para;", "&part;", "&permil;", "&perp;", "&Phi;", "&phi;", "&Pi;", "&pi;", "&piv;", "&plusmn;", "&pound;", "&Prime;", "&prime;", "&prod;", "&prop;", "&Psi;", "&psi;", "&quot;", "&radic;", "&rang;", "&raquo;", "&rArr;", "&rarr;", "&rceil;", "&rdquo;", "&real;", "&reg;", "&rfloor;", "&Rho;", "&rho;", "&rlm;", "&rsaquo;", "&rsquo;", "&sbquo;", "&Scaron;", "&scaron;", "&sdot;", "&sect;", "&shy;", "&Sigma;", "&sigma;", "&sigmaf;", "&sim;", "&spades;", "&sub;", "&sube;", "&sum;", "&sup;", "&sup1;", "&sup2;", "&sup3;", "&supe;", "&szlig;", "&Tau;", "&tau;", "&there4;", "&Theta;", "&theta;", "&thetasym;", "&thinsp;", "&thorn;", "&tilde;", "&times;", "&trade;", "&Uacute;", "&uacute;", "&uArr;", "&uarr;", "&Ucirc;", "&ucirc;", "&Ugrave;", "&ugrave;", "&uml;", "&upsih;", "&Upsilon;", "&upsilon;", "&Uuml;", "&uuml;", "&weierp;", "&Xi;", "&xi;", "&Yacute;", "&yacute;", "&yen;", "&Yuml;", "&yuml;", "&Zeta;", "&zeta;", "&zwj;", "&zwnj;"};
        ENTITY_CHARS = new char[]{'\u00c2', '\u00e2', '\u00b4', '\u00c6', '\u00e6', '\u00c0', '\u00e0', '\u2135', '\u0391', '\u03b1', '&', '\u2227', '\u2220', '\'', '\u00c5', '\u00e5', '\u2248', '\u00c3', '\u00e3', '\u00c4', '\u00e4', '\u201e', '\u0392', '\u03b2', '\u00a6', '\u2022', '\u2229', '\u00c7', '\u00e7', '\u00b8', '\u00a2', '\u03a7', '\u03c7', '\u02c6', '\u2663', '\u2245', '\u00a9', '\u21b5', '\u222a', '\u00a4', '\u2021', '\u2020', '\u21d3', '\u2193', '\u00b0', '\u0394', '\u03b4', '\u2666', '\u00f7', '\u00c9', '\u00e9', '\u00ca', '\u00ea', '\u00c8', '\u00e8', '\u2205', '\u2003', '\u2002', '\u0395', '\u03b5', '\u2261', '\u0397', '\u03b7', '\u00d0', '\u00f0', '\u00cb', '\u00eb', '\u20ac', '\u2203', '\u0192', '\u2200', '\u00bd', '\u00bc', '\u00be', '\u2044', '\u0393', '\u03b3', '\u2265', '>', '\u21d4', '\u2194', '\u2665', '\u2026', '\u00cd', '\u00ed', '\u00ce', '\u00ee', '\u00a1', '\u00cc', '\u00ec', '\u2111', '\u221e', '\u222b', '\u0399', '\u03b9', '\u00bf', '\u2208', '\u00cf', '\u00ef', '\u039a', '\u03ba', '\u039b', '\u03bb', '\u2329', '\u00ab', '\u21d0', '\u2190', '\u2308', '\u201c', '\u2264', '\u230a', '\u2217', '\u25ca', '\u200e', '\u2039', '\u2018', '<', '\u00af', '\u2014', '\u00b5', '\u00b7', '\u2212', '\u039c', '\u03bc', '\u2207', '\u00a0', '\u2013', '\u2260', '\u220b', '\u00ac', '\u2209', '\u2284', '\u00d1', '\u00f1', '\u039d', '\u03bd', '\u00d3', '\u00f3', '\u00d4', '\u00f4', '\u0152', '\u0153', '\u00d2', '\u00f2', '\u203e', '\u03a9', '\u03c9', '\u039f', '\u03bf', '\u2295', '\u2228', '\u00aa', '\u00ba', '\u00d8', '\u00f8', '\u00d5', '\u00f5', '\u2297', '\u00d6', '\u00f6', '\u00b6', '\u2202', '\u2030', '\u22a5', '\u03a6', '\u03c6', '\u03a0', '\u03c0', '\u03d6', '\u00b1', '\u00a3', '\u2033', '\u2032', '\u220f', '\u221d', '\u03a8', '\u03c8', '\"', '\u221a', '\u232a', '\u00bb', '\u21d2', '\u2192', '\u2309', '\u201d', '\u211c', '\u00ae', '\u230b', '\u03a1', '\u03c1', '\u200f', '\u203a', '\u2019', '\u201a', '\u0160', '\u0161', '\u22c5', '\u00a7', '\u00ad', '\u03a3', '\u03c3', '\u03c2', '\u223c', '\u2660', '\u2282', '\u2286', '\u2211', '\u2283', '\u00b9', '\u00b2', '\u00b3', '\u2287', '\u00df', '\u03a4', '\u03c4', '\u2234', '\u0398', '\u03b8', '\u03d1', '\u00de', '\u00fe', '\u02dc', '\u00d7', '\u2122', '\u00da', '\u00fa', '\u21d1', '\u2191', '\u00db', '\u00fb', '\u00d9', '\u00f9', '\u00a8', '\u03d2', '\u03a5', '\u03c5', '\u00dc', '\u00fc', '\u2118', '\u039e', '\u03be', '\u00dd', '\u00fd', '\u00a5', '\u0178', '\u00ff', '\u0396', '\u03b6', '\u200d', '\u200c'};
        LINK_PREFIXES = new String[]{"http", "https", "ftp", "ftps"};
        BLOCK_ELEMENTS = new HTMLElement[]{HTMLElement.address, HTMLElement.blockquote, HTMLElement.del, HTMLElement.div, HTMLElement.dl, HTMLElement.fieldset, HTMLElement.form, HTMLElement.h1, HTMLElement.h2, HTMLElement.h3, HTMLElement.h4, HTMLElement.h5, HTMLElement.h6, HTMLElement.hr, HTMLElement.ins, HTMLElement.noscript, HTMLElement.ol, HTMLElement.p, HTMLElement.pre, HTMLElement.table, HTMLElement.ul};
        UNSAFE_ELEMENTS = new HTMLElement[]{HTMLElement.applet, HTMLElement.head, HTMLElement.html, HTMLElement.body, HTMLElement.frame, HTMLElement.frameset, HTMLElement.iframe, HTMLElement.script, HTMLElement.object};
        encodeMap = new HashMap();
        decodeMap = new HashMap();
        HTML_ELEMENTS = new HashSet();
        HTML_UNSAFE = new HashSet();
        HTML_BLOCK_ELEMENTS = new HashSet();
        LINK_PREFIX = new HashSet();
        for (HTMLElement hTMLElement : HTMLElement.values()) {
            HTML_ELEMENTS.add(hTMLElement.toString());
        }
        for (HTMLElement hTMLElement : UNSAFE_ELEMENTS) {
            HTML_UNSAFE.add(hTMLElement.toString());
        }
        for (HTMLElement hTMLElement : BLOCK_ELEMENTS) {
            HTML_BLOCK_ELEMENTS.add(hTMLElement.toString());
        }
        for (n = 0; n < ENTITY_NAMES.length; ++n) {
            encodeMap.put(Character.valueOf(ENTITY_CHARS[n]), ENTITY_NAMES[n]);
            decodeMap.put(ENTITY_NAMES[n], Character.valueOf(ENTITY_CHARS[n]));
        }
        for (n = 0; n < LINK_PREFIXES.length; ++n) {
            LINK_PREFIX.add(LINK_PREFIXES[n]);
        }
    }
}

