/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark;

import com.github.rjeschke.txtmark.HTML;
import com.github.rjeschke.txtmark.LineType;
import com.github.rjeschke.txtmark.Utils;
import java.util.LinkedList;

class Line {
    public int pos;
    public int leading = 0;
    public int trailing = 0;
    public boolean isEmpty = true;
    public String value = null;
    public Line previous = null;
    public Line next = null;
    public boolean prevEmpty;
    public boolean nextEmpty;
    public Line xmlEndLine;

    public void init() {
        this.leading = 0;
        while (this.leading < this.value.length() && this.value.charAt(this.leading) == ' ') {
            ++this.leading;
        }
        if (this.leading == this.value.length()) {
            this.setEmpty();
        } else {
            this.isEmpty = false;
            this.trailing = 0;
            while (this.value.charAt(this.value.length() - this.trailing - 1) == ' ') {
                ++this.trailing;
            }
        }
    }

    public void initLeading() {
        this.leading = 0;
        while (this.leading < this.value.length() && this.value.charAt(this.leading) == ' ') {
            ++this.leading;
        }
        if (this.leading == this.value.length()) {
            this.setEmpty();
        }
    }

    public boolean skipSpaces() {
        while (this.pos < this.value.length() && this.value.charAt(this.pos) == ' ') {
            ++this.pos;
        }
        return this.pos < this.value.length();
    }

    public String readUntil(char ... cArray) {
        char c;
        char c2;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        for (n = this.pos; n < this.value.length(); ++n) {
            c2 = this.value.charAt(n);
            if (c2 == '\\' && n + 1 < this.value.length()) {
                char c3 = this.value.charAt(n + 1);
                c = c3;
                switch (c3) {
                    case '!': 
                    case '\"': 
                    case '#': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '>': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '_': 
                    case '`': 
                    case '{': 
                    case '}': {
                        stringBuilder.append(c);
                        ++n;
                        break;
                    }
                    default: {
                        stringBuilder.append(c2);
                        break;
                    }
                }
                continue;
            }
            c = '\u0000';
            for (int i = 0; i < cArray.length; ++i) {
                if (c2 != cArray[i]) continue;
                c = '\u0001';
                break;
            }
            if (c != '\u0000') break;
            stringBuilder.append(c2);
        }
        c2 = n < this.value.length() ? (char)this.value.charAt(n) : (char)'\n';
        for (c = '\u0000'; c < cArray.length; ++c) {
            if (c2 != cArray[c]) continue;
            this.pos = n;
            return stringBuilder.toString();
        }
        return null;
    }

    public void setEmpty() {
        this.value = "";
        this.trailing = 0;
        this.leading = 0;
        this.isEmpty = true;
        if (this.previous != null) {
            this.previous.nextEmpty = true;
        }
        if (this.next != null) {
            this.next.prevEmpty = true;
        }
    }

    private int countChars(char c) {
        int n = 0;
        for (int i = 0; i < this.value.length(); ++i) {
            char c2 = this.value.charAt(i);
            if (c2 == ' ') continue;
            if (c2 == c) {
                ++n;
                continue;
            }
            n = 0;
            break;
        }
        return n;
    }

    public LineType getLineType() {
        if (this.isEmpty) {
            return LineType.EMPTY;
        }
        if (this.leading > 3) {
            return LineType.CODE;
        }
        if (this.value.charAt(this.leading) == '#') {
            return LineType.HEADLINE;
        }
        if (this.value.charAt(this.leading) == '>') {
            return LineType.BQUOTE;
        }
        if (this.value.length() - this.leading - this.trailing > 2 && (this.value.charAt(this.leading) == '*' || this.value.charAt(this.leading) == '-' || this.value.charAt(this.leading) == '_') && this.countChars(this.value.charAt(this.leading)) >= 3) {
            return LineType.HR;
        }
        if (this.value.length() - this.leading >= 2 && this.value.charAt(this.leading + 1) == ' ') {
            switch (this.value.charAt(this.leading)) {
                case '*': 
                case '+': 
                case '-': {
                    return LineType.ULIST;
                }
            }
        }
        if (this.value.length() - this.leading >= 3 && Character.isDigit(this.value.charAt(this.leading))) {
            int n;
            for (n = this.leading + 1; n < this.value.length() && Character.isDigit(this.value.charAt(n)); ++n) {
            }
            if (n + 1 < this.value.length() && this.value.charAt(n) == '.' && this.value.charAt(n + 1) == ' ') {
                return LineType.OLIST;
            }
        }
        if (this.value.charAt(this.leading) == '<' && this.checkHTML()) {
            return LineType.XML;
        }
        if (this.next != null && !this.next.isEmpty) {
            if (this.next.value.charAt(0) == '-' && this.next.countChars('-') > 0) {
                return LineType.HEADLINE2;
            }
            if (this.next.value.charAt(0) == '=' && this.next.countChars('=') > 0) {
                return LineType.HEADLINE1;
            }
        }
        return LineType.OTHER;
    }

    private int readXMLComment(Line line, int n) {
        Line line2 = line;
        if (n + 3 < line2.value.length() && line2.value.charAt(2) == '-' && line2.value.charAt(3) == '-') {
            int n2 = n + 4;
            while (line2 != null) {
                while (n2 < line2.value.length() && line2.value.charAt(n2) != '-') {
                    ++n2;
                }
                if (n2 == line2.value.length()) {
                    line2 = line2.next;
                    n2 = 0;
                    continue;
                }
                if (n2 + 2 < line2.value.length() && line2.value.charAt(n2 + 1) == '-' && line2.value.charAt(n2 + 2) == '>') {
                    this.xmlEndLine = line2;
                    return n2 + 3;
                }
                ++n2;
            }
        }
        return -1;
    }

    public String stripIP() {
        if (this.isEmpty || this.value.charAt(this.value.length() - this.trailing - 1) != '}') {
            return null;
        }
        int n = this.leading;
        boolean bl = false;
        block14: while (n < this.value.length() && !bl) {
            switch (this.value.charAt(n)) {
                case '\\': {
                    if (n + 1 < this.value.length()) {
                        switch (this.value.charAt(n + 1)) {
                            case '{': {
                                ++n;
                            }
                        }
                    }
                    ++n;
                    continue block14;
                }
                case '{': {
                    bl = true;
                    continue block14;
                }
            }
            ++n;
        }
        if (bl && n + 1 < this.value.length() && this.value.charAt(n + 1) == '#') {
            int n2;
            n = n2 = n + 2;
            bl = false;
            block15: while (n < this.value.length() && !bl) {
                switch (this.value.charAt(n)) {
                    case '\\': {
                        if (n + 1 < this.value.length()) {
                            switch (this.value.charAt(n + 1)) {
                                case '}': {
                                    ++n;
                                }
                            }
                        }
                        ++n;
                        continue block15;
                    }
                    case '}': {
                        bl = true;
                        continue block15;
                    }
                }
                ++n;
            }
            if (bl) {
                String string = this.value.substring(n2, n).trim();
                this.value = this.leading != 0 ? this.value.substring(0, this.leading) + this.value.substring(this.leading, n2 - 2).trim() : this.value.substring(this.leading, n2 - 2).trim();
                this.trailing = 0;
                return string.length() > 0 ? string : null;
            }
        }
        return null;
    }

    private boolean checkHTML() {
        LinkedList<String> linkedList = new LinkedList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.leading;
        if (this.value.charAt(this.leading + 1) == '!' && this.readXMLComment(this, this.leading) > 0) {
            return true;
        }
        n = Utils.readXML(stringBuilder, this.value, this.leading, false);
        if (n > -1) {
            String string = stringBuilder.toString();
            stringBuilder.setLength(0);
            Utils.getXMLTag(stringBuilder, string);
            String string2 = stringBuilder.toString().toLowerCase();
            if (!HTML.isHtmlBlockElement(string2)) {
                return false;
            }
            if (string2.equals("hr")) {
                this.xmlEndLine = this;
                return true;
            }
            linkedList.add(string2);
            Line line = this;
            while (line != null) {
                while (n < line.value.length() && line.value.charAt(n) != '<') {
                    ++n;
                }
                if (n >= line.value.length()) {
                    line = line.next;
                    n = 0;
                    continue;
                }
                stringBuilder.setLength(0);
                int n2 = Utils.readXML(stringBuilder, line.value, n, false);
                if (n2 > 0) {
                    string = stringBuilder.toString();
                    stringBuilder.setLength(0);
                    Utils.getXMLTag(stringBuilder, string);
                    string2 = stringBuilder.toString().toLowerCase();
                    if (HTML.isHtmlBlockElement(string2) && !string2.equals("hr")) {
                        if (string.charAt(1) == '/') {
                            if (!((String)linkedList.getLast()).equals(string2)) {
                                return false;
                            }
                            linkedList.removeLast();
                        } else {
                            linkedList.addLast(string2);
                        }
                    }
                    if (linkedList.size() == 0) {
                        this.xmlEndLine = line;
                        break;
                    }
                    n = n2;
                    continue;
                }
                ++n;
            }
            return linkedList.size() == 0;
        }
        return false;
    }
}

