/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sourceforge.schemaspy.DbAnalyzer;
import net.sourceforge.schemaspy.Main;
import net.sourceforge.schemaspy.model.ProcessExecutionException;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.view.HtmlMultipleSchemasIndexPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultipleSchemaAnalyzer {
    private static MultipleSchemaAnalyzer instance = new MultipleSchemaAnalyzer();
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final boolean fineEnabled = this.logger.isLoggable(Level.FINE);

    private MultipleSchemaAnalyzer() {
    }

    public static MultipleSchemaAnalyzer getInstance() {
        return instance;
    }

    public void analyze(String string, DatabaseMetaData databaseMetaData, String string2, List<String> list, List<String> list2, String string3, File file, String string4, String string5) throws SQLException, IOException {
        List<String> list3;
        long l = System.currentTimeMillis();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("java");
        arrayList.add("-Doneofmultipleschemas=true");
        if (new File(string5).isDirectory()) {
            arrayList.add("-cp");
            arrayList.add(string5);
            arrayList.add(Main.class.getName());
        } else {
            arrayList.add("-jar");
            arrayList.add(string5);
        }
        for (String object : list2) {
            if (object.startsWith("-")) {
                arrayList.add(object);
                continue;
            }
            arrayList.add("\"" + object + "\"");
        }
        if (list == null) {
            System.out.println("Analyzing schemas that match regular expression '" + string2 + "':");
            System.out.println("(use -schemaSpec on command line or in .properties to exclude other schemas)");
            list3 = this.getPopulatedSchemas(databaseMetaData, string2, string3);
        } else {
            System.out.println("Analyzing schemas:");
            list3 = list;
        }
        for (String string6 : list3) {
            System.out.print(" " + string6);
        }
        System.out.println();
        this.writeIndexPage(string, list3, databaseMetaData, file, string4);
        for (String string6 : list3) {
            ArrayList<String> arrayList2 = new ArrayList<String>(arrayList);
            if (string == null) {
                arrayList2.add("-db");
            } else {
                arrayList2.add("-s");
            }
            arrayList2.add(string6);
            arrayList2.add("-o");
            arrayList2.add(new File(file, string6).toString());
            System.out.println("Analyzing " + string6);
            System.out.flush();
            Process process = Runtime.getRuntime().exec(arrayList2.toArray(new String[0]));
            new ProcessOutputReader(process.getInputStream(), System.out).start();
            new ProcessOutputReader(process.getErrorStream(), System.err).start();
            try {
                int n = process.waitFor();
                if (n == 0) continue;
                StringBuilder stringBuilder = new StringBuilder("Failed to execute this process (rc " + n + "):");
                for (String string7 : arrayList2) {
                    stringBuilder.append(" ");
                    stringBuilder.append(string7);
                }
                throw new ProcessExecutionException(stringBuilder.toString());
            }
            catch (InterruptedException interruptedException) {
            }
        }
        long l2 = System.currentTimeMillis();
        System.out.println();
        System.out.println("Wrote relationship details of " + list3.size() + " schema" + (list3.size() == 1 ? "" : "s") + " in " + (l2 - l) / 1000L + " seconds.");
        System.out.println("Start with " + new File(file, "index.html"));
    }

    public void analyze(String string, List<String> list, List<String> list2, String string2, File file, String string3, String string4) throws SQLException, IOException {
        this.analyze(string, null, null, list, list2, string2, file, string3, string4);
    }

    private void writeIndexPage(String string, List<String> list, DatabaseMetaData databaseMetaData, File file, String string2) throws IOException {
        if (list.size() > 0) {
            LineWriter lineWriter = new LineWriter(new File(file, "index.html"), string2);
            HtmlMultipleSchemasIndexPage.getInstance().write(string, list, databaseMetaData, lineWriter);
            lineWriter.close();
        }
    }

    private List<String> getPopulatedSchemas(DatabaseMetaData databaseMetaData, String string, String string2) throws SQLException {
        List<String> list;
        if (databaseMetaData.supportsSchemasInTableDefinitions()) {
            Pattern pattern = Pattern.compile(string);
            list = DbAnalyzer.getPopulatedSchemas(databaseMetaData, string);
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string3 = iterator.next();
                if (!pattern.matcher(string3).matches()) {
                    if (this.fineEnabled) {
                        this.logger.fine("Excluding schema " + string3 + ": doesn't match + \"" + pattern + '\"');
                    }
                    iterator.remove();
                    continue;
                }
                if (!this.fineEnabled) continue;
                this.logger.fine("Including schema " + string3 + ": matches + \"" + pattern + '\"');
            }
        } else {
            list = Arrays.asList(string2);
        }
        return list;
    }

    private static class ProcessOutputReader
    extends Thread {
        private final Reader processReader;
        private final PrintStream out;

        ProcessOutputReader(InputStream inputStream, PrintStream printStream) {
            this.processReader = new InputStreamReader(inputStream);
            this.out = printStream;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int n;
                while ((n = this.processReader.read()) != -1) {
                    this.out.print((char)n);
                    this.out.flush();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    this.processReader.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

