/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.TextBlockWidth;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.InnerStateAutonom;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GroupPngMakerState {
    private final CucaDiagram diagram;
    private final IGroup group;
    private final Rose rose = new Rose();

    public GroupPngMakerState(CucaDiagram cucaDiagram, IGroup iGroup) {
        this.diagram = cucaDiagram;
        this.group = iGroup;
        if (!iGroup.isGroup()) {
            throw new IllegalArgumentException();
        }
    }

    private List<Link> getPureInnerLinks() {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : this.diagram.getLinks()) {
            if (!EntityUtils.isPureInnerLink12(this.group, link)) continue;
            arrayList.add(link);
        }
        return arrayList;
    }

    public IEntityImage getImage() throws IOException, InterruptedException {
        Display display = this.group.getDisplay();
        TextBlock textBlock = TextBlockUtils.create(display, new FontConfiguration(this.getFont(FontParam.STATE), HtmlColorUtils.BLACK), HorizontalAlignment.CENTER, this.diagram.getSkinParam());
        if (this.group.size() == 0) {
            return new EntityImageState(this.group, this.diagram.getSkinParam());
        }
        List<Link> list = this.getPureInnerLinks();
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        boolean bl = false;
        for (ILeaf object2 : this.group.getLeafsDirect()) {
            if (object2.getEntityType() != LeafType.STATE_CONCURRENT) continue;
            bl = true;
        }
        DotData dotData = new DotData(this.group, list, this.group.getLeafsDirect(), this.diagram.getUmlDiagramType(), iSkinParam, this.group.getRankdir(), new InnerGroupHierarchy(), this.diagram.getColorMapper(), this.diagram.getEntityFactory(), this.diagram.isHideEmptyDescriptionForState(), DotMode.NORMAL, this.diagram.getNamespaceSeparator());
        CucaDiagramFileMakerSvek2 cucaDiagramFileMakerSvek2 = new CucaDiagramFileMakerSvek2(dotData, this.diagram.getEntityFactory(), bl, this.diagram.getSource(), this.diagram.getPragma());
        UStroke uStroke = this.group.getSpecificLineStroke();
        if (uStroke == null) {
            uStroke = new UStroke(1.5);
        }
        if (this.group.getGroupType() == GroupType.CONCURRENT_STATE) {
            return cucaDiagramFileMakerSvek2.createFile(new String[0]);
        }
        if (this.group.getGroupType() == GroupType.STATE) {
            HtmlColor htmlColor = this.group.getSpecificLineColor();
            if (htmlColor == null) {
                htmlColor = this.getColor(ColorParam.stateBorder, null);
            }
            Stereotype stereotype = this.group.getStereotype();
            HtmlColor htmlColor2 = this.group.getSpecificBackColor() == null ? this.getColor(ColorParam.stateBackground, stereotype) : this.group.getSpecificBackColor();
            List<Member> list2 = this.group.getFieldsToDisplay();
            TextBlock textBlock2 = list2.size() == 0 ? new TextBlockEmpty() : new MethodsOrFieldsArea(list2, FontParam.STATE_ATTRIBUTE, this.diagram.getSkinParam());
            Stereotype stereotype2 = this.group.getStereotype();
            boolean bl2 = stereotype2 != null && stereotype2.isWithOOSymbol();
            return new InnerStateAutonom(cucaDiagramFileMakerSvek2.createFile(new String[0]), textBlock, (TextBlockWidth)((Object)textBlock2), htmlColor, htmlColor2, iSkinParam.shadowing(), this.group.getUrl99(), bl2, uStroke);
        }
        throw new UnsupportedOperationException(this.group.getGroupType().toString());
    }

    private UFont getFont(FontParam fontParam) {
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        return iSkinParam.getFont(fontParam, null);
    }

    protected final HtmlColor getColor(ColorParam colorParam, Stereotype stereotype) {
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        return this.rose.getHtmlColor(iSkinParam, colorParam, stereotype);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InnerGroupHierarchy
    implements GroupHierarchy {
        InnerGroupHierarchy() {
        }

        @Override
        public Collection<IGroup> getChildrenGroups(IGroup iGroup) {
            if (EntityUtils.groupRoot(iGroup)) {
                return GroupPngMakerState.this.diagram.getChildrenGroups(GroupPngMakerState.this.group);
            }
            return GroupPngMakerState.this.diagram.getChildrenGroups(iGroup);
        }

        @Override
        public boolean isEmpty(IGroup iGroup) {
            return GroupPngMakerState.this.diagram.isEmpty(iGroup);
        }
    }
}

