/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction;

import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.EntryCorral;
import com.jbidwatcher.util.Comparison;
import com.jbidwatcher.util.Task;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AuctionList {
    private final List<String> mIdentifierList = Collections.synchronizedList(new ArrayList());
    private final Set<String> mIdentifierSet = Collections.synchronizedSet(new HashSet());
    private final EntryCorral entryCorral;

    public AuctionList(EntryCorral corral) {
        this.entryCorral = corral;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List<String> list = this.mIdentifierList;
        synchronized (list) {
            return this.mIdentifierList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuctionEntry get(int i) {
        List<String> list = this.mIdentifierList;
        synchronized (list) {
            String identifier = this.mIdentifierList.get(i);
            return (AuctionEntry)this.entryCorral.takeForRead(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int i) {
        List<String> list = this.mIdentifierList;
        synchronized (list) {
            String identifier = this.mIdentifierList.get(i);
            this.entryCorral.takeForRead(identifier);
            this.mIdentifierList.remove(i);
            this.mIdentifierSet.remove(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AuctionEntry ae) {
        if (ae.getIdentifier() == null || ae.getIdentifier().length() == 0 || this.mIdentifierSet.contains(ae.getIdentifier())) {
            return;
        }
        List<String> list = this.mIdentifierList;
        synchronized (list) {
            this.entryCorral.put(ae);
            this.mIdentifierList.add(ae.getIdentifier());
            this.mIdentifierSet.add(ae.getIdentifier());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuctionEntry find(Comparison c) {
        List<String> list = this.mIdentifierList;
        synchronized (list) {
            for (String identifier : this.mIdentifierList) {
                AuctionEntry result = (AuctionEntry)this.entryCorral.takeForRead(identifier);
                if (!c.match(result)) continue;
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void each(Task task) {
        List<String> list = this.mIdentifierList;
        synchronized (list) {
            for (String identifier : this.mIdentifierList) {
                AuctionEntry result = (AuctionEntry)this.entryCorral.takeForWrite(identifier);
                try {
                    task.execute(result);
                }
                finally {
                    this.entryCorral.release(identifier);
                }
            }
        }
    }
}

