/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.cyberfox.util.platform.Platform;
import com.jbidwatcher.search.SearchManager;
import com.jbidwatcher.search.Searcher;
import com.jbidwatcher.ui.JSearchContext;
import com.jbidwatcher.ui.JTabManager;
import com.jbidwatcher.ui.ListManager;
import com.jbidwatcher.ui.table.SearchTableModel;
import com.jbidwatcher.ui.util.JBidFrame;
import com.jbidwatcher.ui.util.JPasteListener;
import com.jbidwatcher.util.config.JConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.TableRowSorter;

public class SearchFrame
implements ActionListener {
    private JFrame mainFrame;
    private JComboBox newType;
    private JTextField searchString;
    private SearchTableModel _stm;
    private final SearchManager searchManager;
    private JTable searchTable;
    String[] search_types = new String[]{"Text Search", "Seller Search", "URL Load", "My Items"};

    public SearchFrame(SearchManager searchManager, JTabManager tabManager, ListManager listManager, JPasteListener pasteListener) {
        this.searchManager = searchManager;
        this.mainFrame = this.createSearchFrame(searchManager, tabManager, listManager, pasteListener);
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        int height = Math.min(305, screensize.height / 2);
        int width = Math.min(566, screensize.width / 2);
        int screenx = (screensize.width - width) / 2;
        int screeny = (screensize.height - height) / 2;
        String s_x = JConfig.queryDisplayProperty("searches.x");
        String s_y = JConfig.queryDisplayProperty("searches.y");
        String s_w = JConfig.queryDisplayProperty("searches.width");
        String s_h = JConfig.queryDisplayProperty("searches.height");
        try {
            if (s_x != null) {
                screenx = Integer.parseInt(s_x);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            if (s_x != null && s_y != null) {
                screeny = Integer.parseInt(s_y);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            if (s_x != null && s_w != null) {
                width = Integer.parseInt(s_w);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            if (s_x != null && s_h != null) {
                height = Integer.parseInt(s_h);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.mainFrame.setLocation(screenx, screeny);
        this.mainFrame.setSize(width, height);
        this.mainFrame.setVisible(true);
    }

    private void savePosition() {
        JConfig.setAuxConfiguration("searches.x", Integer.toString(this.mainFrame.getX()));
        JConfig.setAuxConfiguration("searches.y", Integer.toString(this.mainFrame.getY()));
        JConfig.setAuxConfiguration("searches.width", Integer.toString(this.mainFrame.getWidth()));
        JConfig.setAuxConfiguration("searches.height", Integer.toString(this.mainFrame.getHeight()));
    }

    private JFrame createSearchFrame(final SearchManager searchManager, JTabManager tabManager, ListManager listManager, JPasteListener pasteListener) {
        JPanel wholePanel = new JPanel(new BorderLayout(), true);
        JPanel subPanel = new JPanel(new BorderLayout(), true);
        JPanel buttonPanel = new JPanel(new BorderLayout(), true);
        Box buttonBox = Box.createHorizontalBox();
        JSearchContext jsc = new JSearchContext(searchManager, tabManager, listManager, pasteListener);
        final JBidFrame w = new JBidFrame("Search Manager");
        Container contentPane = w.getContentPane();
        contentPane.setLayout(new BorderLayout());
        wholePanel.setBorder(BorderFactory.createTitledBorder("Saved Searches"));
        wholePanel.add((Component)this.buildSearchTable(jsc), "Center");
        buttonBox.add(jsc.makeButton("Search", "Execute"));
        buttonBox.add(jsc.makeButton("New"));
        buttonBox.add(jsc.makeButton("Edit", "Edit Search"));
        buttonBox.add(jsc.makeButton("Enable"));
        buttonBox.add(jsc.makeButton("Disable"));
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(jsc.makeButton("Delete"));
        buttonPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        buttonPanel.add((Component)buttonBox, "South");
        wholePanel.add((Component)buttonPanel, "South");
        contentPane.add((Component)wholePanel, "Center");
        contentPane.add((Component)subPanel, "South");
        w.pack();
        w.setResizable(true);
        w.setDefaultCloseOperation(1);
        w.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                SearchFrame.this.savePosition();
                searchManager.saveSearches();
            }

            @Override
            public void windowIconified(WindowEvent we) {
                SearchFrame.this.savePosition();
                if (Platform.isWindows() && Platform.isTrayEnabled() && JConfig.queryConfiguration("windows.tray", "true").equals("true") && JConfig.queryConfiguration("windows.minimize", "true").equals("true")) {
                    w.setVisible(false);
                }
            }

            @Override
            public void windowDeiconified(WindowEvent we) {
                if (Platform.isWindows() && Platform.isTrayEnabled() && JConfig.queryConfiguration("windows.tray", "true").equals("true") && JConfig.queryConfiguration("windows.minimize", "true").equals("true")) {
                    w.setState(0);
                    w.setVisible(true);
                }
            }
        });
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchFrame.this.savePosition();
                w.setVisible(false);
            }
        };
        w.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        w.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        return w;
    }

    private JScrollPane buildSearchTable(JSearchContext jsc) {
        this._stm = new SearchTableModel(this.searchManager);
        this.searchTable = new JTable(this._stm);
        this.searchTable.setRowSorter(new TableRowSorter<SearchTableModel>(this._stm));
        this.searchTable.addMouseListener(jsc);
        this.searchTable.setShowGrid(false);
        this.searchTable.setIntercellSpacing(new Dimension(0, 0));
        this.searchTable.setDoubleBuffered(true);
        this.searchTable.setShowHorizontalLines(true);
        this.searchTable.setToolTipText("Double-click on a search to execute it!");
        this.searchTable.getTableHeader().setReorderingAllowed(false);
        JScrollPane jsp = new JScrollPane(this.searchTable, 20, 31);
        jsp.getViewport().setBackground(UIManager.getColor("window"));
        jsc.setTable(this.searchTable);
        return jsp;
    }

    public void show() {
        this.mainFrame.setState(0);
        this.mainFrame.setVisible(true);
    }

    private Searcher add(String type, String name, String search, String server) {
        int inc = 0;
        String curName = name + Integer.toString(inc);
        Searcher s = this.searchManager.buildSearch(System.currentTimeMillis(), type, curName, search, server, null, -1);
        this._stm.insert(s);
        return s;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String act = ae.getActionCommand();
        if (act.equals("Add") || act.equals("Search")) {
            String text = this.searchString.getText();
            Searcher s = this.add((String)this.newType.getSelectedItem(), "New Search ", text, "ebay");
            this._stm.fireTableDataChanged();
            this.newType.setSelectedIndex(0);
            this.searchString.setText("");
            if (act.equals("Search")) {
                if (JConfig.debugging) {
                    System.out.println("Doing a " + this.newType.getSelectedItem() + " for " + text);
                }
                s.execute();
            }
        }
    }
}

