/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util.db;

import com.jbidwatcher.util.Record;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.db.Database;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class Table {
    private static boolean STATEMENT_DEBUG = false;
    private Database mDB;
    private Statement mS;
    private Map<String, TypeColumn> mColumnMap;
    private String mTableName;
    private DateFormat mDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Map<String, PreparedStatement> mStatementMap = new HashMap<String, PreparedStatement>();

    public boolean hasColumn(String colName) {
        return this.mColumnMap.containsKey(colName);
    }

    public Table(String tablename) throws SQLException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        this.mDB = new Database(null);
        this.mTableName = tablename;
        this.mDateFormat.setTimeZone(TimeZone.getDefault());
        PreparedStatement query = this.mDB.prepare("SELECT * FROM " + this.mTableName);
        this.establishMetadata(query.getMetaData());
        this.mS = this.mDB.getStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database shutdown() {
        Statement statement = this.mS;
        synchronized (statement) {
            try {
                this.mS.close();
            }
            catch (SQLException e) {
                JConfig.log().handleException("Can't shut down database.", e);
            }
            this.mDB.commit();
            return this.mDB;
        }
    }

    public void commit() {
        this.mDB.commit();
    }

    public Record find(int id) {
        return this.findFirst("SELECT * FROM " + this.mTableName + " where id = " + id);
    }

    public boolean delete(int id) {
        try {
            PreparedStatement ps = this.mDB.prepare("DELETE FROM " + this.mTableName + " WHERE id = " + id);
            ps.execute();
            this.mDB.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean deleteBy(String condition) {
        return this.execute("DELETE FROM " + this.mTableName + " WHERE " + condition);
    }

    public boolean execute(String statement) {
        if (STATEMENT_DEBUG) {
            JConfig.log().logDebug("Executing: " + statement);
        }
        try {
            PreparedStatement ps = this.mDB.prepare(statement);
            ps.execute();
            this.mDB.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record findFirst(String query) {
        if (STATEMENT_DEBUG) {
            JConfig.log().logDebug("Executing fF query: " + query);
        }
        Statement statement = this.mS;
        synchronized (statement) {
            try {
                ResultSet rs = this.mS.executeQuery(query);
                return this.getFirstResult(rs);
            }
            catch (SQLException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public Record findFirstBy(String key, String value) {
        return this.findByColumn(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record findFirstBy(String query) {
        if (STATEMENT_DEBUG) {
            JConfig.log().logDebug("Executing fFB query: " + query);
        }
        Statement statement = this.mS;
        synchronized (statement) {
            try {
                ResultSet rs = this.mS.executeQuery(query);
                return this.getFirstResult(rs);
            }
            catch (SQLException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public List<Record> findAllMulti(String[] keys, String[] values, String order) {
        return this.findAllMulti(keys, values, null, order);
    }

    public List<Record> findAllMulti(String[] keys, String[] values, String[] comparisons, String order) {
        if (keys != null && keys.length != values.length) {
            JConfig.log().logMessage("Multi-find with varying key and value lengths!");
            return null;
        }
        if (keys != null && comparisons != null && keys.length != comparisons.length) {
            JConfig.log().logMessage("Multi-find with varying key and comparisons lengths!");
        }
        StringBuffer statement = new StringBuffer("SELECT * FROM " + this.mTableName);
        if (keys != null && keys.length != 0) {
            statement.append(" WHERE ");
            boolean start = true;
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (!start) {
                    statement.append(" AND ");
                }
                statement.append(key);
                if (comparisons == null) {
                    statement.append('=');
                } else {
                    statement.append(comparisons[i]);
                }
                statement.append('?');
                start = false;
            }
        }
        if (order != null) {
            statement.append(" ORDER BY ").append(order);
        }
        try {
            PreparedStatement ps = this.mDB.prepare(statement.toString());
            if (keys != null && keys.length != 0) {
                int colnum = 1;
                for (int i = 0; i < values.length; ++i) {
                    this.setColumn(ps, colnum, keys[i], values[i]);
                }
            }
            if (STATEMENT_DEBUG) {
                JConfig.log().logDebug("Executing fAM query: " + statement);
            }
            ResultSet rs = this.execute(ps);
            return this.getAllResults(rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Record> findAll(String key, String value, String order) {
        String[] keys = new String[]{key};
        String[] values = new String[]{value};
        return this.findAllMulti(keys, values, order);
    }

    public List<Record> findAllComparator(String key, String comparison, String value, String order) {
        String[] keys = new String[]{key};
        String[] values = new String[]{value};
        String[] comparisons = new String[]{comparison};
        return this.findAllMulti(keys, values, comparisons, order);
    }

    public List<Record> findAll() {
        return this.findAll("SELECT * FROM " + this.mTableName, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Record> findAll(String query, int count) {
        Statement statement = this.mS;
        synchronized (statement) {
            try {
                this.mS.setMaxRows(count);
                if (STATEMENT_DEBUG) {
                    JConfig.log().logDebug("Executing fA query: " + query);
                }
                ResultSet rs = this.mS.executeQuery(query);
                return this.getAllResults(rs);
            }
            catch (SQLException e) {
                JConfig.log().handleDebugException("Error running query: " + query, e);
                return null;
            }
        }
    }

    public List<Record> findAllPrepared(String query, int count, String ... parameters) {
        try {
            PreparedStatement ps = this.mStatementMap.get(query);
            if (ps == null) {
                ps = this.mDB.prepare(query);
                this.mStatementMap.put(query, ps);
            }
            ps.setMaxRows(count);
            int paramIndex = 1;
            for (String param : parameters) {
                ps.setString(paramIndex++, param);
            }
            if (STATEMENT_DEBUG) {
                JConfig.log().logDebug("Executing fAP query: " + query);
            }
            ResultSet rs = this.execute(ps);
            ps.clearParameters();
            return this.getAllResults(rs);
        }
        catch (SQLException e) {
            JConfig.log().handleDebugException("Error preparing query: " + query, e);
            return null;
        }
    }

    private ResultSet execute(PreparedStatement ps) throws SQLException {
        return ps.executeQuery();
    }

    private Record getFirstResult(ResultSet rs) throws SQLException {
        Record rval = new Record();
        ResultSetMetaData rsm = rs.getMetaData();
        if (rsm != null && rs.next()) {
            for (int i = 1; i <= rsm.getColumnCount(); ++i) {
                rval.put(rs.getMetaData().getColumnName(i).toLowerCase(), rs.getString(i));
            }
        }
        rs.close();
        return rval;
    }

    private List<Record> getAllResults(ResultSet rs) throws SQLException {
        ArrayList<Record> rval = new ArrayList<Record>();
        ResultSetMetaData rsm = rs.getMetaData();
        if (rsm != null) {
            while (rs.next()) {
                Record row = new Record();
                for (int i = 1; i <= rsm.getColumnCount(); ++i) {
                    row.put(rs.getMetaData().getColumnName(i).toLowerCase(), rs.getString(i));
                }
                rval.add(row);
            }
        }
        rs.close();
        return rval;
    }

    public String insertOrUpdate(Record row) {
        String value = (String)row.get("id");
        if (value != null && value.length() == 0) {
            value = null;
        }
        return this.updateMap(this.mTableName, "id", value, row);
    }

    public String updateMap(String tableName, String columnKey, String value, Record newRow) {
        String sql;
        Record oldRow = null;
        if (value != null) {
            oldRow = this.getRow(tableName, columnKey, value, true);
        }
        newRow = this.cleanRow(newRow);
        if (value == null || oldRow == null) {
            if (this.mColumnMap.containsKey("created_at")) {
                newRow.put("created_at", this.mDateFormat.format(new Date()));
            }
            return this.storeMap(newRow);
        }
        if (this.mColumnMap.containsKey("updated_at")) {
            newRow.put("updated_at", this.mDateFormat.format(new Date()));
        }
        if ((sql = this.createPreparedUpdate(tableName, oldRow, newRow)) == null) {
            return null;
        }
        sql = sql + " WHERE " + columnKey + " = ?";
        try {
            PreparedStatement ps = this.mDB.prepare(sql);
            int colCount = this.setPreparedUpdate(ps, oldRow, newRow);
            if (colCount != -1) {
                this.setColumn(ps, colCount, columnKey, value);
                if (STATEMENT_DEBUG) {
                    JConfig.log().logDebug("Executing update on: " + sql);
                }
                ps.execute();
                this.mDB.commit();
                return this.findKeys(ps);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Record cleanRow(Record newRow) {
        Record cleanedNewRow = new Record();
        for (String column : newRow.keySet()) {
            if (!this.hasColumn(column)) continue;
            cleanedNewRow.put(column, newRow.get(column));
        }
        newRow = cleanedNewRow;
        return newRow;
    }

    public Record findByColumn(String columnKey, String value) {
        return this.findByColumn(columnKey, value, false);
    }

    public Record findByColumn(String columnKey, String value, boolean forUpdate) {
        return this.getRow(this.mTableName, columnKey, value, forUpdate);
    }

    private Record getRow(String tableName, String columnKey, String value, boolean forUpdate) {
        Record oldRow = null;
        try {
            String statement = "SELECT * FROM " + tableName;
            statement = statement + " WHERE " + columnKey + " = ?";
            if (forUpdate) {
                statement = statement + " FOR UPDATE";
            }
            PreparedStatement ps = this.mDB.prepare(statement);
            this.setColumn(ps, 1, columnKey, value);
            if (STATEMENT_DEBUG) {
                JConfig.log().logDebug("Executing gR statement: " + statement);
            }
            ResultSet rs = this.execute(ps);
            oldRow = this.getFirstResult(rs);
        }
        catch (SQLException e) {
            JConfig.log().handleException("Can't get row" + (forUpdate ? " for update" : "") + " (" + columnKey + " = '" + value + "').", e);
        }
        return oldRow;
    }

    public String storeMap(Record newRow) {
        String sql = this.createPreparedInsert(this.mTableName, newRow);
        if (sql == null) {
            return null;
        }
        StringBuffer values = new StringBuffer();
        try {
            PreparedStatement ps = this.mDB.prepare(sql);
            int column = 1;
            for (String key : newRow.keySet()) {
                if (key.equals("id")) continue;
                if (values.length() != 0) {
                    values.append(", ");
                }
                if (!this.setColumn(ps, column++, key, (String)newRow.get(key))) {
                    JConfig.log().logDebug("Error from columns: (" + column + ", " + key + ", " + this.mColumnMap.get(key).getType() + ", " + (String)newRow.get(key) + ")");
                }
                values.append((String)newRow.get(key));
            }
            if (STATEMENT_DEBUG) {
                JConfig.log().logDebug("Storing map: " + sql);
            }
            ps.execute();
            this.mDB.commit();
            return this.findKeys(ps);
        }
        catch (SQLException e) {
            System.err.println("Command: " + sql);
            System.err.println("Values:  " + values);
            JConfig.log().handleException("Can't store row in table.", e);
            return null;
        }
    }

    private String findKeys(PreparedStatement ps) throws SQLException {
        ResultSet rs = ps.getGeneratedKeys();
        if (rs != null) {
            Record insertMap = this.getFirstResult(rs);
            if (insertMap.containsKey("1")) {
                return (String)insertMap.get("1");
            }
            if (insertMap.containsKey("generated_key")) {
                return (String)insertMap.get("generated_key");
            }
            if (insertMap.values().size() == 1) {
                return insertMap.values().toArray()[0].toString();
            }
        }
        return "";
    }

    private String createPreparedInsert(String tableName, Record newRow) {
        boolean anyKeys = false;
        StringBuffer insert = new StringBuffer("INSERT INTO " + tableName + " (");
        StringBuffer values = new StringBuffer();
        for (String key : newRow.keySet()) {
            if (key.equals("id")) continue;
            if (anyKeys) {
                insert.append(',');
                values.append(',');
            }
            insert.append(key);
            values.append('?');
            anyKeys = true;
        }
        String sql = null;
        if (anyKeys) {
            sql = insert + ") VALUES (" + values + ")";
        }
        return sql;
    }

    private String createPreparedUpdate(String tableName, Record oldRow, Record newRow) {
        boolean anyKeys = false;
        StringBuffer update = new StringBuffer("UPDATE " + tableName + " SET ");
        for (String key : newRow.keySet()) {
            String newVal = (String)newRow.get(key);
            String oldVal = (String)oldRow.get(key);
            if (newVal == null && oldVal == null || newVal != null && oldVal != null && newVal.equals(oldVal)) continue;
            if (anyKeys) {
                update.append(',');
            }
            update.append(key).append("=?");
            anyKeys = true;
        }
        return anyKeys ? update.toString() : null;
    }

    private int setPreparedUpdate(PreparedStatement ps, Record oldRow, Record newRow) {
        boolean errors = false;
        int column = 1;
        for (String key : newRow.keySet()) {
            String newVal = (String)newRow.get(key);
            String oldVal = (String)oldRow.get(key);
            if (newVal == null && oldVal == null || newVal != null && oldVal != null && newVal.equals(oldVal) || this.setColumn(ps, column++, key, (String)newRow.get(key))) continue;
            JConfig.log().logMessage("Error from columns: (" + column + "," + key + ", " + this.mColumnMap.get(key).getType() + ", " + (String)newRow.get(key) + ")");
            errors = true;
        }
        return errors ? -1 : column;
    }

    private boolean setColumn(PreparedStatement ps, int column, String key, String val) {
        block34: {
            String type = this.mColumnMap.get(key).getType();
            try {
                if (type.equals("DECIMAL")) {
                    if (val == null) {
                        ps.setNull(column, 3);
                    } else if (val.length() == 0) {
                        ps.setBigDecimal(column, null);
                    } else {
                        ps.setBigDecimal(column, BigDecimal.valueOf(Double.parseDouble(val)));
                    }
                    break block34;
                }
                if (type.equals("VARCHAR")) {
                    if (val == null) {
                        ps.setNull(column, 12);
                    } else {
                        ps.setString(column, val.substring(0, Math.min(val.length(), 255)));
                    }
                    break block34;
                }
                if (type.equals("CHAR")) {
                    if (val == null) {
                        ps.setNull(column, 1);
                    } else {
                        ps.setString(column, val.substring(0, Math.min(val.length(), 255)));
                    }
                    break block34;
                }
                if (type.equals("TIMESTAMP") || type.equals("DATETIME")) {
                    if (val == null) {
                        ps.setNull(column, 93);
                        break block34;
                    }
                    try {
                        ps.setTimestamp(column, Timestamp.valueOf(val));
                        break block34;
                    }
                    catch (SQLException e) {
                        JConfig.log().logMessage("Failing to insert \"" + val + "\" into column " + column + " of table " + this.mTableName);
                        throw e;
                    }
                    catch (RuntimeException e) {
                        JConfig.log().logMessage("Failing to insert \"" + val + "\" into column " + key + " (" + column + ") of table " + this.mTableName);
                        throw e;
                    }
                }
                if (type.equals("INTEGER") || type.equals("INT")) {
                    if (val == null) {
                        ps.setNull(column, 4);
                    } else if (val.length() == 0) {
                        ps.setInt(column, -1);
                    } else {
                        ps.setInt(column, Integer.parseInt(val));
                    }
                } else if (type.equals("SMALLINT")) {
                    if (val == null) {
                        ps.setNull(column, 5);
                    } else if (val.equals("Y")) {
                        ps.setShort(column, (short)1);
                    } else if (val.equals("N")) {
                        ps.setShort(column, (short)0);
                    } else {
                        try {
                            ps.setShort(column, Short.parseShort(val));
                        }
                        catch (NumberFormatException nfe) {
                            ps.setNull(column, 5);
                        }
                    }
                } else {
                    JConfig.log().logDebug("WTF?!?! (" + type + ", " + key + ", " + val + ")");
                }
            }
            catch (SQLException e) {
                JConfig.log().logDebug("Failure with prepared statement: " + ps.toString());
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private void establishMetadata(ResultSetMetaData rsmd) {
        try {
            this.mColumnMap = new HashMap<String, TypeColumn>();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                String key = rsmd.getColumnName(i).toLowerCase();
                String value = rsmd.getColumnTypeName(i);
                this.mColumnMap.put(key, new TypeColumn(value, i));
            }
        }
        catch (SQLException e) {
            JConfig.log().handleException("Can't load metadata for table " + this.mTableName + ".", e);
        }
    }

    public int count() {
        return this.countBySQL("SELECT COUNT(*) AS count FROM " + this.mTableName);
    }

    public int countBy(String condition) {
        return this.countBySQL("SELECT COUNT(*) AS count FROM " + this.mTableName + " WHERE " + condition);
    }

    public int countBySQL(String sql) {
        Record rm = this.findFirst(sql);
        String count = (String)rm.values().toArray()[0];
        return Integer.parseInt(count);
    }

    public Database getDB() {
        return this.mDB;
    }

    public Set<String> getColumns() {
        return this.mColumnMap.keySet();
    }

    private static class TypeColumn {
        private String mType;
        private Integer mIndex;

        private TypeColumn(String type, Integer index) {
            this.mType = type;
            this.mIndex = index;
        }

        public String getType() {
            return this.mType;
        }

        public Integer getIndex() {
            return this.mIndex;
        }
    }
}

