/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark;

import com.github.rjeschke.txtmark.Block;
import com.github.rjeschke.txtmark.BlockType;
import com.github.rjeschke.txtmark.Decorator;
import com.github.rjeschke.txtmark.DefaultDecorator;
import com.github.rjeschke.txtmark.Emitter;
import com.github.rjeschke.txtmark.Line;
import com.github.rjeschke.txtmark.LineType;
import com.github.rjeschke.txtmark.LinkRef;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

public class Processor {
    private final Reader reader;
    private final Emitter emitter;
    private boolean useExtensions = false;

    private Processor(Reader reader, Decorator decorator, boolean bl) {
        this.reader = reader;
        this.emitter = new Emitter(decorator, bl);
    }

    public static String process(String string) {
        try {
            return Processor.process(new StringReader(string));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String process(String string, boolean bl) {
        try {
            return Processor.process((Reader)new StringReader(string), bl);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String process(String string, Decorator decorator) {
        try {
            return Processor.process((Reader)new StringReader(string), decorator);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String process(String string, Decorator decorator, boolean bl) {
        try {
            return Processor.process(new StringReader(string), decorator, bl);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String process(File file) throws IOException {
        return Processor.process(file, "UTF-8");
    }

    public static String process(File file, boolean bl) throws IOException {
        return Processor.process(file, "UTF-8", bl);
    }

    public static String process(File file, Decorator decorator) throws IOException {
        return Processor.process(file, "UTF-8", decorator);
    }

    public static String process(File file, Decorator decorator, boolean bl) throws IOException {
        return Processor.process(file, "UTF-8", decorator, bl);
    }

    public static String process(File file, String string) throws IOException {
        return Processor.process(file, string, (Decorator)new DefaultDecorator());
    }

    public static String process(File file, String string, boolean bl) throws IOException {
        return Processor.process(file, string, (Decorator)new DefaultDecorator(), bl);
    }

    public static String process(File file, String string, Decorator decorator) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        String string2 = Processor.process((InputStream)fileInputStream, string, decorator);
        fileInputStream.close();
        return string2;
    }

    public static String process(File file, String string, Decorator decorator, boolean bl) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        String string2 = Processor.process(fileInputStream, string, decorator, bl);
        fileInputStream.close();
        return string2;
    }

    public static String process(InputStream inputStream) throws IOException {
        return Processor.process(inputStream, "UTF-8", (Decorator)new DefaultDecorator());
    }

    public static String process(InputStream inputStream, boolean bl) throws IOException {
        return Processor.process(inputStream, "UTF-8", (Decorator)new DefaultDecorator(), bl);
    }

    public static String process(InputStream inputStream, Decorator decorator) throws IOException {
        return Processor.process(inputStream, "UTF-8", decorator);
    }

    public static String process(InputStream inputStream, Decorator decorator, boolean bl) throws IOException {
        return Processor.process(inputStream, "UTF-8", decorator, bl);
    }

    public static String process(InputStream inputStream, String string) throws IOException {
        Processor processor = new Processor(new BufferedReader(new InputStreamReader(inputStream, string)), new DefaultDecorator(), false);
        return processor.process();
    }

    public static String process(InputStream inputStream, String string, boolean bl) throws IOException {
        Processor processor = new Processor(new BufferedReader(new InputStreamReader(inputStream, string)), new DefaultDecorator(), bl);
        return processor.process();
    }

    public static String process(InputStream inputStream, String string, Decorator decorator) throws IOException {
        Processor processor = new Processor(new BufferedReader(new InputStreamReader(inputStream, string)), decorator, false);
        return processor.process();
    }

    public static String process(InputStream inputStream, String string, Decorator decorator, boolean bl) throws IOException {
        Processor processor = new Processor(new BufferedReader(new InputStreamReader(inputStream, string)), decorator, bl);
        return processor.process();
    }

    public static String process(Reader reader) throws IOException {
        Processor processor = new Processor(!(reader instanceof BufferedReader) ? new BufferedReader(reader) : reader, new DefaultDecorator(), false);
        return processor.process();
    }

    public static String process(Reader reader, boolean bl) throws IOException {
        Processor processor = new Processor(!(reader instanceof BufferedReader) ? new BufferedReader(reader) : reader, new DefaultDecorator(), bl);
        return processor.process();
    }

    public static String process(Reader reader, Decorator decorator) throws IOException {
        Processor processor = new Processor(!(reader instanceof BufferedReader) ? new BufferedReader(reader) : reader, decorator, false);
        return processor.process();
    }

    public static String process(Reader reader, Decorator decorator, boolean bl) throws IOException {
        Processor processor = new Processor(!(reader instanceof BufferedReader) ? new BufferedReader(reader) : reader, decorator, bl);
        return processor.process();
    }

    private Block readLines() throws IOException {
        Block block = new Block();
        StringBuilder stringBuilder = new StringBuilder(80);
        int n = this.reader.read();
        LinkRef linkRef = null;
        while (n != -1) {
            char c;
            stringBuilder.setLength(0);
            int n2 = 0;
            boolean bl = false;
            block7: while (!bl) {
                switch (n) {
                    case -1: {
                        bl = true;
                        continue block7;
                    }
                    case 10: {
                        n = this.reader.read();
                        if (n == 13) {
                            n = this.reader.read();
                        }
                        bl = true;
                        continue block7;
                    }
                    case 13: {
                        n = this.reader.read();
                        if (n == 10) {
                            n = this.reader.read();
                        }
                        bl = true;
                        continue block7;
                    }
                    case 9: {
                        int n3 = n2 + (4 - (n2 & 3));
                        while (n2 < n3) {
                            stringBuilder.append(' ');
                            ++n2;
                        }
                        n = this.reader.read();
                        continue block7;
                    }
                }
                ++n2;
                stringBuilder.append((char)n);
                n = this.reader.read();
            }
            Line line = new Line();
            line.value = stringBuilder.toString();
            line.init();
            boolean bl2 = false;
            String string = null;
            String string2 = null;
            String string3 = null;
            if (!line.isEmpty && line.leading < 4 && line.value.charAt(line.leading) == '[') {
                line.pos = line.leading + 1;
                string = line.readUntil(']');
                if (string != null && line.pos + 2 < line.value.length() && line.value.charAt(line.pos + 1) == ':') {
                    line.pos += 2;
                    line.skipSpaces();
                    if (line.value.charAt(line.pos) == '<') {
                        ++line.pos;
                        string2 = line.readUntil('>');
                        ++line.pos;
                    } else {
                        string2 = line.readUntil(' ', '\n');
                    }
                    if (string2 != null) {
                        if (line.skipSpaces()) {
                            c = line.value.charAt(line.pos);
                            if (c == '\"' || c == '\'' || c == '(') {
                                ++line.pos;
                                string3 = line.readUntil(c == '(' ? (char)')' : (char)c);
                                if (string3 != null) {
                                    bl2 = true;
                                }
                            }
                        } else {
                            bl2 = true;
                        }
                    }
                }
            }
            if (bl2 && string != null && string2 != null) {
                if (string.toLowerCase().equals("$profile$")) {
                    this.emitter.useExtensions = this.useExtensions = string2.toLowerCase().equals("extended");
                    linkRef = null;
                    continue;
                }
                LinkRef linkRef2 = new LinkRef(string2, string3, string3 != null && string2.length() == 1 && string2.charAt(0) == '*');
                this.emitter.addLinkRef(string, linkRef2);
                if (string3 != null) continue;
                linkRef = linkRef2;
                continue;
            }
            string3 = null;
            if (!line.isEmpty && linkRef != null) {
                line.pos = line.leading;
                c = line.value.charAt(line.pos);
                if (c == '\"' || c == '\'' || c == '(') {
                    ++line.pos;
                    string3 = line.readUntil(c == '(' ? (char)')' : (char)c);
                }
                if (string3 != null) {
                    linkRef.title = string3;
                }
                linkRef = null;
            }
            if (string3 != null) continue;
            line.pos = 0;
            block.appendLine(line);
        }
        return block;
    }

    private void initListBlock(Block block) {
        Line line = block.lines;
        line = line.next;
        while (line != null) {
            LineType lineType = line.getLineType();
            if (lineType == LineType.OLIST || lineType == LineType.ULIST || !line.isEmpty && line.prevEmpty && line.leading == 0 && lineType != LineType.OLIST && lineType != LineType.ULIST) {
                block.split((Line)line.previous).type = BlockType.LIST_ITEM;
            }
            line = line.next;
        }
        block.split((Line)block.lineTail).type = BlockType.LIST_ITEM;
    }

    private void recurse(Block block, boolean bl) {
        Line line = block.lines;
        if (bl) {
            block.removeListIndent();
            if (this.useExtensions && block.lines != null && block.lines.getLineType() != LineType.CODE) {
                block.id = block.lines.stripIP();
            }
        }
        while (line != null && line.isEmpty) {
            line = line.next;
        }
        if (line == null) {
            return;
        }
        block10: while (line != null) {
            LineType lineType = line.getLineType();
            switch (lineType) {
                case OTHER: {
                    Enum enum_;
                    boolean bl2 = line.prevEmpty;
                    while (line != null && !line.isEmpty) {
                        enum_ = line.getLineType();
                        if ((bl || this.useExtensions) && (enum_ == LineType.OLIST || enum_ == LineType.ULIST) || this.useExtensions && enum_ == LineType.CODE || enum_ == LineType.HEADLINE || enum_ == LineType.HEADLINE1 || enum_ == LineType.HEADLINE2 || enum_ == LineType.HR || enum_ == LineType.BQUOTE || enum_ == LineType.XML) break;
                        line = line.next;
                    }
                    if (line != null && !line.isEmpty) {
                        block.split((Line)line.previous).type = enum_ = bl && !bl2 ? BlockType.NONE : BlockType.PARAGRAPH;
                        block.removeLeadingEmptyLines();
                    } else {
                        enum_ = bl && (line == null || !line.isEmpty) && !bl2 ? BlockType.NONE : BlockType.PARAGRAPH;
                        block.split((Line)(line == null ? block.lineTail : line)).type = enum_;
                        block.removeLeadingEmptyLines();
                    }
                    line = block.lines;
                    continue block10;
                }
                case CODE: {
                    while (line != null && (line.isEmpty || line.leading > 3)) {
                        line = line.next;
                    }
                    Block block2 = block.split(line != null ? line.previous : block.lineTail);
                    block2.type = BlockType.CODE;
                    block2.removeSurroundingEmptyLines();
                    continue block10;
                }
                case XML: {
                    if (line.previous != null) {
                        block.split(line.previous);
                    }
                    block.split((Line)line.xmlEndLine).type = BlockType.XML;
                    block.removeLeadingEmptyLines();
                    line = block.lines;
                    continue block10;
                }
                case BQUOTE: {
                    while (line != null && (line.isEmpty || !line.prevEmpty || line.leading != 0 || line.getLineType() == LineType.BQUOTE)) {
                        line = line.next;
                    }
                    Block block2 = block.split(line != null ? line.previous : block.lineTail);
                    block2.type = BlockType.BLOCKQUOTE;
                    block2.removeSurroundingEmptyLines();
                    block2.removeBlockQuotePrefix();
                    this.recurse(block2, false);
                    line = block.lines;
                    continue block10;
                }
                case HR: {
                    if (line.previous != null) {
                        block.split(line.previous);
                    }
                    block.split((Line)line).type = BlockType.RULER;
                    block.removeLeadingEmptyLines();
                    line = block.lines;
                    continue block10;
                }
                case HEADLINE: 
                case HEADLINE1: 
                case HEADLINE2: {
                    if (line.previous != null) {
                        block.split(line.previous);
                    }
                    if (lineType != LineType.HEADLINE) {
                        line.next.setEmpty();
                    }
                    Block block2 = block.split(line);
                    block2.type = BlockType.HEADLINE;
                    if (lineType != LineType.HEADLINE) {
                        int n = block2.hlDepth = lineType == LineType.HEADLINE1 ? 1 : 2;
                    }
                    if (this.useExtensions) {
                        block2.id = block2.lines.stripIP();
                    }
                    block2.transfromHeadline();
                    block.removeLeadingEmptyLines();
                    line = block.lines;
                    continue block10;
                }
                case OLIST: 
                case ULIST: {
                    while (line != null) {
                        LineType lineType2 = line.getLineType();
                        if (!line.isEmpty && line.prevEmpty && line.leading == 0 && lineType2 != LineType.OLIST && lineType2 != LineType.ULIST) break;
                        line = line.next;
                    }
                    Block block3 = block.split(line != null ? line.previous : block.lineTail);
                    block3.type = lineType == LineType.OLIST ? BlockType.ORDERED_LIST : BlockType.UNORDERED_LIST;
                    block3.lines.prevEmpty = false;
                    block3.lineTail.nextEmpty = false;
                    block3.removeSurroundingEmptyLines();
                    block3.lineTail.nextEmpty = false;
                    block3.lines.prevEmpty = false;
                    this.initListBlock(block3);
                    Block block2 = block3.blocks;
                    while (block2 != null) {
                        this.recurse(block2, true);
                        block2 = block2.next;
                    }
                    block3.expandListParagraphs();
                    continue block10;
                }
            }
            line = line.next;
        }
    }

    private String process() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        Block block = this.readLines();
        block.removeSurroundingEmptyLines();
        this.recurse(block, false);
        Block block2 = block.blocks;
        while (block2 != null) {
            this.emitter.emit(stringBuilder, block2);
            block2 = block2.next;
        }
        return stringBuilder.toString();
    }
}

