/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.google.inject.Inject;
import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.EntryCorral;
import com.jbidwatcher.auction.EntryFactory;
import com.jbidwatcher.auction.server.AuctionServerManager;
import com.jbidwatcher.ui.AuctionsManager;
import com.jbidwatcher.util.StringTools;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.DropQObject;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.MessageQueue;

public class JBWDropHandler
implements MessageQueue.Listener {
    private static boolean do_uber_debug = false;
    private static String lastSeen = null;
    private EntryFactory entryFactory;
    private AuctionServerManager auctionServerManager;
    private EntryCorral entryCorral;
    private AuctionsManager auctionsManager;

    @Inject
    public JBWDropHandler(EntryFactory entryFactory, AuctionServerManager auctionServerManager, EntryCorral corral, AuctionsManager auctionsManager) {
        this.entryFactory = entryFactory;
        this.auctionServerManager = auctionServerManager;
        this.entryCorral = corral;
        this.auctionsManager = auctionsManager;
        MQFactory.getConcrete("drop").registerListener(this);
    }

    @Override
    public void messageAction(Object deQ) {
        boolean interactive;
        String label;
        String auctionURL;
        AuctionEntry ae;
        if (deQ instanceof String && StringTools.isNumberOnly((String)deQ) && (ae = (AuctionEntry)this.entryCorral.takeForRead((String)deQ)) != null) {
            boolean lostAuction = !ae.hasAuction();
            ae.update();
            if (lostAuction) {
                this.auctionsManager.addEntry(ae);
            }
            return;
        }
        if (deQ instanceof String) {
            auctionURL = deQ.toString();
            label = null;
            interactive = true;
        } else {
            DropQObject dObj = (DropQObject)deQ;
            auctionURL = (String)dObj.getData();
            label = dObj.getLabel();
            interactive = dObj.isInteractive();
        }
        this.loadDroppedEntry(auctionURL, label, interactive);
    }

    private void loadDroppedEntry(String auctionURL, String label, boolean interactive) {
        String aucId;
        if (do_uber_debug) {
            JConfig.log().logDebug("Dropping (action): " + auctionURL);
        }
        if (EntryFactory.isInvalid(interactive, aucId = this.auctionServerManager.getServer().stripId(auctionURL))) {
            return;
        }
        AuctionEntry aeNew = this.entryFactory.conditionallyAddEntry(interactive, aucId, label);
        if (aeNew == null) {
            if (lastSeen == null || !aucId.equals(lastSeen)) {
                JConfig.log().logDebug("Not loaded (" + aucId + ").");
                lastSeen = aucId;
            }
        } else {
            lastSeen = aeNew.getIdentifier();
        }
    }
}

