/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.jbidwatcher.ui.ListManager;
import com.jbidwatcher.ui.config.JConfigTab;
import com.jbidwatcher.ui.table.TableColumnController;
import com.jbidwatcher.util.config.JConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JTabProperties
extends JConfigTab
implements ActionListener {
    private final ListManager listManager;
    private String _tab;
    private JFrame _frame = null;
    private JComboBox cbWonTarget = null;
    private JComboBox cbLostTarget = null;
    private JComboBox cbOtherTarget = null;
    private String WON_TARGET;
    private String LOST_TARGET;
    private String OTHER_TARGET;
    private Map<String, JCheckBox> columns2Boxes = null;

    public JTabProperties(ListManager listManager, String tabName) {
        super.setLayout(new BorderLayout());
        this.listManager = listManager;
        this._tab = tabName;
        this.WON_TARGET = this._tab + ".won_target";
        this.LOST_TARGET = this._tab + ".lost_target";
        this.OTHER_TARGET = this._tab + ".other_target";
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add((Component)JTabProperties.panelPack(this.buildDropdownPanel()), "North");
        jp.add((Component)JTabProperties.panelPack(this.buildColumnPanel()), "Center");
        super.add((Component)jp, "North");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("OK")) {
            this.apply();
            this._frame.setVisible(false);
        } else {
            this.listManager.toggleField(this._tab, cmd);
        }
    }

    public void setColumnStatus(String colName, boolean status) {
        JCheckBox jcb = this.columns2Boxes.get(colName);
        if (jcb != null) {
            jcb.setSelected(status);
        }
    }

    @Override
    public void updateValues() {
        this.prepareComboBox(this.cbWonTarget);
        this.prepareComboBox(this.cbLostTarget);
        this.prepareComboBox(this.cbOtherTarget);
        this.cbWonTarget.setSelectedItem(JConfig.queryConfiguration(this.WON_TARGET, "complete"));
        this.cbLostTarget.setSelectedItem(JConfig.queryConfiguration(this.LOST_TARGET, "complete"));
        this.cbOtherTarget.setSelectedItem(JConfig.queryConfiguration(this.OTHER_TARGET, "complete"));
    }

    private JPanel buildDropdownPanel() {
        JPanel dropDowns = new JPanel();
        dropDowns.setBorder(BorderFactory.createTitledBorder("End-of-listing item targets"));
        dropDowns.setLayout(new BoxLayout(dropDowns, 1));
        this.cbWonTarget = new JComboBox();
        this.cbLostTarget = new JComboBox();
        this.cbOtherTarget = new JComboBox();
        dropDowns.add(JTabProperties.makeLine(new JLabel("Send items won to: "), this.cbWonTarget));
        dropDowns.add(JTabProperties.makeLine(new JLabel("Send items bid but not won to: "), this.cbLostTarget));
        dropDowns.add(JTabProperties.makeLine(new JLabel("Send everything else to: "), this.cbOtherTarget));
        this.updateValues();
        return dropDowns;
    }

    private void prepareComboBox(JComboBox target) {
        target.removeAllItems();
        List<String> tabs = this.listManager.allCategories();
        target.setEditable(true);
        if (tabs != null) {
            tabs.remove("selling");
            for (String tabName : tabs) {
                target.addItem(tabName);
            }
        }
    }

    private JPanel buildColumnPanel() {
        JPanel columnChecks = new JPanel();
        if (this.columns2Boxes == null) {
            this.columns2Boxes = new TreeMap<String, JCheckBox>();
        }
        columnChecks.setBorder(BorderFactory.createTitledBorder("Custom Column Settings"));
        JPanel internal = new JPanel();
        internal.setLayout(new GridLayout(0, 4, 20, 0));
        List<String> columns = this.listManager.getColumns(this._tab);
        Object[] names = TableColumnController.getInstance().getColumnNames().toArray();
        Arrays.sort(names);
        for (Object name1 : names) {
            String s = (String)name1;
            if (s == null) continue;
            JCheckBox jch = new JCheckBox(s, columns.contains(s));
            jch.addActionListener(this);
            this.columns2Boxes.put(s, jch);
            internal.add(jch);
        }
        columnChecks.add((Component)internal, "Center");
        return columnChecks;
    }

    @Override
    public String getTabName() {
        return this._tab;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void apply() {
        String won = (String)this.cbWonTarget.getSelectedItem();
        String lost = (String)this.cbLostTarget.getSelectedItem();
        String other = (String)this.cbOtherTarget.getSelectedItem();
        JConfig.setConfiguration(this.WON_TARGET, won);
        JConfig.setConfiguration(this.LOST_TARGET, lost);
        JConfig.setConfiguration(this.OTHER_TARGET, other);
    }

    public void setFrame(JFrame frame) {
        this._frame = frame;
    }
}

