/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util.browser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class WindowsBrowserLauncher {
    private static final int KEY_QUERY_VALUE = 1;
    private static final int NATIVE_HANDLE = 0;
    private static final int ERROR_CODE = 1;
    private static final int ERROR_SUCCESS = 0;
    private static final boolean _debug = false;

    public static String replace(String inSource, String search, String replacement) {
        String result = inSource;
        int srch_index = result.indexOf(search);
        while (srch_index != -1) {
            result = result.substring(0, srch_index) + replacement + result.substring(srch_index + search.length());
            srch_index = result.indexOf(search, srch_index + replacement.length());
        }
        return result;
    }

    public static String[] splitCommandLine(String cmd, String replace) {
        cmd = WindowsBrowserLauncher.replace(cmd, "\\", "\\\\");
        StreamTokenizer str = new StreamTokenizer(new StringReader(cmd));
        ArrayList<String> result = new ArrayList<String>();
        boolean found_param = false;
        str.resetSyntax();
        str.wordChars(0, 255);
        str.whitespaceChars(32, 32);
        str.quoteChar(34);
        try {
            while (str.nextToken() != -1) {
                result.add(str.sval);
                if (!str.sval.equals("\"%1\"") && !str.sval.equals("%1")) continue;
                found_param = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String[] output = found_param || replace == null ? new String[result.size()] : new String[result.size() + 1];
        for (int i = 0; i < result.size(); ++i) {
            output[i] = (String)result.get(i);
            if (replace == null || !output[i].equals("\"%1\"") && !output[i].equals("%1")) continue;
            output[i] = "\"" + replace + "\"";
        }
        if (!found_param && replace != null) {
            output[result.size()] = "\"" + replace + "\"";
        }
        return output;
    }

    public static String[] splitCommandLine(String cmd) {
        return WindowsBrowserLauncher.splitCommandLine(cmd, null);
    }

    public static String getIndirect(String primary) {
        String clientName = WindowsBrowserLauncher.getKeyDefault("HKEY_CLASSES_ROOT\\\\" + primary);
        if (clientName == null) {
            return null;
        }
        String command = WindowsBrowserLauncher.getKeyDefault("HKEY_CLASSES_ROOT\\\\" + clientName + "\\shell\\open\\command");
        return command;
    }

    public static String getKeyDefault(String key) {
        try {
            int hkey = WindowsBrowserLauncher.getHKEY(key);
            byte[] rootpath = WindowsBrowserLauncher.stripHKEY(key);
            return WindowsBrowserLauncher.getValue(hkey, rootpath, "");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getBrowser(String protocol) {
        String clientName = WindowsBrowserLauncher.getKeyDefault("HKEY_CLASSES_ROOT\\\\" + protocol + "\\shell\\open\\command");
        if (clientName == null && (clientName = WindowsBrowserLauncher.getIndirect(protocol)) == null) {
            return null;
        }
        return clientName;
    }

    public static int getHKEY(String path) throws Exception {
        if (path.startsWith("HKEY_CURRENT_USER")) {
            return -2147483647;
        }
        if (path.startsWith("HKEY_LOCAL_MACHINE")) {
            return -2147483646;
        }
        if (path.startsWith("HKEY_CLASSES_ROOT")) {
            return Integer.MIN_VALUE;
        }
        throw new Exception("Path should start with HKEY_CURRENT_USER or HKEY_LOCAL_MACHINE");
    }

    public static byte[] stripHKEY(String path) {
        int beginIndex = path.indexOf("\\\\");
        return WindowsBrowserLauncher.stringToByteArray(path.substring(beginIndex + 2));
    }

    public static String getValue(int hkey, byte[] WINDOWS_ROOT_PATH, String key) throws Exception {
        Class<?> theClass = Class.forName("java.util.prefs.WindowsPreferences");
        int[] result = WindowsBrowserLauncher.openKey1(hkey, WindowsBrowserLauncher.windowsAbsolutePath(WINDOWS_ROOT_PATH), 1);
        if (result[1] != 0) {
            throw new Exception("Path not found!");
        }
        int nativeHandle = result[0];
        Method m = theClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
        m.setAccessible(true);
        byte[] windowsName = WindowsBrowserLauncher.toWindowsName(key);
        Object value = m.invoke(null, nativeHandle, windowsName);
        WindowsBrowserLauncher.WindowsRegCloseKey(nativeHandle);
        if (value == null) {
            throw new Exception("Path found.  Key not found.");
        }
        byte[] origBuffer = (byte[])value;
        if (origBuffer.length == 0) {
            return null;
        }
        byte[] destBuffer = new byte[origBuffer.length - 1];
        System.arraycopy(origBuffer, 0, destBuffer, 0, origBuffer.length - 1);
        return new String(destBuffer);
    }

    public static int WindowsRegCloseKey(int nativeHandle) throws Exception {
        Class<?> theClass = Class.forName("java.util.prefs.WindowsPreferences");
        Method m = theClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
        m.setAccessible(true);
        Object ret = m.invoke(null, nativeHandle);
        return (Integer)ret;
    }

    public static int[] openKey1(int hkey, byte[] windowsAbsolutePath, int securityMask) throws Exception {
        Class<?> theClass = Class.forName("java.util.prefs.WindowsPreferences");
        Method m = theClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
        m.setAccessible(true);
        Object ret = m.invoke(null, hkey, windowsAbsolutePath, securityMask);
        return (int[])ret;
    }

    private static byte[] stringToByteArray(String str) {
        byte[] result = new byte[str.length() + 1];
        for (int i = 0; i < str.length(); ++i) {
            result[i] = (byte)str.charAt(i);
        }
        result[str.length()] = 0;
        return result;
    }

    private static byte[] windowsAbsolutePath(byte[] WINDOWS_ROOT_PATH) {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
        bstream.write(WINDOWS_ROOT_PATH, 0, WINDOWS_ROOT_PATH.length - 1);
        StringTokenizer tokenizer = new StringTokenizer("/", "/");
        while (tokenizer.hasMoreTokens()) {
            bstream.write(92);
            String nextName = tokenizer.nextToken();
            byte[] windowsNextName = WindowsBrowserLauncher.toWindowsName(nextName);
            bstream.write(windowsNextName, 0, windowsNextName.length - 1);
        }
        bstream.write(0);
        return bstream.toByteArray();
    }

    private static byte[] toWindowsName(String javaName) {
        StringBuffer windowsName = new StringBuffer();
        for (int i = 0; i < javaName.length(); ++i) {
            char ch = javaName.charAt(i);
            if (ch < ' ' || ch > '\u007f') {
                throw new RuntimeException("Unable to convert to Windows name");
            }
            if (ch == '\\') {
                windowsName.append("//");
                continue;
            }
            if (ch == '/') {
                windowsName.append('\\');
                continue;
            }
            if (ch >= 'A' && ch <= 'Z') {
                windowsName.append("/").append(ch);
                continue;
            }
            windowsName.append(ch);
        }
        return WindowsBrowserLauncher.stringToByteArray(windowsName.toString());
    }

    public static Process Launch(String destURL) throws IOException {
        String extractor = destURL.substring(0, destURL.indexOf(58));
        String launcher = WindowsBrowserLauncher.getBrowser(extractor);
        if (launcher == null) {
            launcher = WindowsBrowserLauncher.getBrowser("http");
        }
        if (launcher == null) {
            return null;
        }
        String[] cmdLine = WindowsBrowserLauncher.splitCommandLine(launcher, destURL);
        return Runtime.getRuntime().exec(cmdLine);
    }
}

