/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util.db;

import com.jbidwatcher.util.db.ActiveRecord;
import com.jbidwatcher.util.db.Table;

public class Device
extends ActiveRecord {
    private static ThreadLocal<Table> tDB = new ThreadLocal<Table>(){

        @Override
        protected synchronized Table initialValue() {
            return ActiveRecord.openDB(Device.getTableName());
        }
    };

    public Device() {
    }

    public Device(String deviceId) {
        this.setString("device_id", deviceId);
        this.refreshKey();
    }

    public void refreshKey() {
        long r;
        while ((r = (long)(Math.random() * 1000000.0)) < 100000L) {
        }
        this.setString("security_key", Long.toString(r));
        this.saveDB();
    }

    protected static String getTableName() {
        return "devices";
    }

    @Override
    protected Table getDatabase() {
        return Device.getRealDatabase();
    }

    public static Table getRealDatabase() {
        return tDB.get();
    }

    public static Device findByDevice(String deviceId) {
        return (Device)Device.findFirstBy(Device.class, "device_id", deviceId);
    }
}

