/*
 * Decompiled with CFR 0.152.
 */
package com.orbus.mahalo;

import com.orbus.mahalo.HostInfo;
import com.orbus.mahalo.MahaloSocket;
import com.orbus.mahalo.MahaloSocketListener;
import com.orbus.mahalo.ServiceInfo;
import com.orbus.mahalo.dns.DNSEntry;
import com.orbus.mahalo.dns.DNSPacket;
import com.orbus.mahalo.dns.DNSQuestion;
import com.orbus.mahalo.dns.DNSRecord;
import com.orbus.mahalo.tasks.Canceler;
import com.orbus.mahalo.tasks.Prober;
import com.orbus.mahalo.tasks.Responder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class MahaloBroadcaster
implements MahaloSocketListener {
    private boolean _bOwnsSocket = false;
    private MahaloSocket _MahaloSocket;
    private HostInfo _HostInfo;
    private Timer _Timer;
    private boolean _bStarted = false;
    private Map<String, ServiceInfo> _LocalServices = new HashMap<String, ServiceInfo>(20);

    public MahaloBroadcaster(InetAddress aAddress, String asName) throws IOException {
        this(new MahaloSocket(aAddress), asName);
        this._bOwnsSocket = true;
        this._MahaloSocket.startListening();
    }

    public MahaloBroadcaster(MahaloSocket aSocket, String asName) throws SocketException {
        this._MahaloSocket = aSocket;
        this._MahaloSocket.addListener(this);
        this._HostInfo = new HostInfo(this._MahaloSocket.getBoundAddress(), asName);
        this._Timer = new Timer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Map<String, ServiceInfo> map = this._LocalServices;
        synchronized (map) {
            Prober prober = new Prober(this._MahaloSocket, this._Timer, this._HostInfo, this._LocalServices.values());
            this._Timer.schedule((TimerTask)prober, Prober.GetStartProbeTime(), 250L);
            this._bStarted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Map<String, ServiceInfo> map = this._LocalServices;
        synchronized (map) {
            this._Timer.cancel();
            this._Timer = new Timer();
            Canceler unregisterCanceler = this.unregisterAllServices();
            if (unregisterCanceler != null) {
                Canceler canceler = unregisterCanceler;
                synchronized (canceler) {
                    try {
                        unregisterCanceler.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            if (this._bOwnsSocket) {
                this._MahaloSocket.close();
            }
            this._bStarted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerService(ServiceInfo aInfo) {
        Map<String, ServiceInfo> map = this._LocalServices;
        synchronized (map) {
            this._LocalServices.put(aInfo.getQualifiedName().toLowerCase(), aInfo);
            if (this._bStarted) {
                LinkedList<ServiceInfo> probeList = new LinkedList<ServiceInfo>();
                probeList.add(aInfo);
                Prober prober = new Prober(this._MahaloSocket, this._Timer, this._HostInfo, probeList);
                this._Timer.schedule((TimerTask)prober, Prober.GetStartProbeTime(), 250L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(ServiceInfo info) {
        Map<String, ServiceInfo> map = this._LocalServices;
        synchronized (map) {
            this._LocalServices.remove(info.getQualifiedName().toLowerCase());
        }
        LinkedList<ServiceInfo> infoList = new LinkedList<ServiceInfo>();
        infoList.add(info);
        this._Timer.schedule((TimerTask)new Canceler(this._MahaloSocket, this._HostInfo, infoList), 0L, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Canceler unregisterAllServices() {
        LinkedList<ServiceInfo> infoList;
        if (this._LocalServices.size() == 0) {
            return null;
        }
        Map<String, ServiceInfo> map = this._LocalServices;
        synchronized (map) {
            infoList = new LinkedList<ServiceInfo>(this._LocalServices.values());
            this._LocalServices.clear();
        }
        Canceler retCanceler = new Canceler(this._MahaloSocket, this._HostInfo, infoList);
        this._Timer.schedule((TimerTask)retCanceler, 0L, 1000L);
        return retCanceler;
    }

    public void handleQuery(DNSPacket aPacket, InetAddress aAddress, int aiPort) {
        this.resolveConflicts(aPacket);
        Responder responder = new Responder(this._MahaloSocket, this._HostInfo, this._LocalServices, aPacket, aAddress, aiPort);
        boolean bonlyResponder = true;
        for (DNSQuestion question : aPacket.getQuestions()) {
            if (!(bonlyResponder &= question.getType() == DNSEntry.EntryType.SRV || question.getType() == DNSEntry.EntryType.TXT || question.getType() == DNSEntry.EntryType.A || question.getType() == DNSEntry.EntryType.AAAA || this._HostInfo.getName().equalsIgnoreCase(question.getName()) || this._LocalServices.containsKey(question.getName().toLowerCase()))) break;
        }
        int itimeElapsed = (int)(System.currentTimeMillis() - aPacket.getRecieved());
        int idelay = Responder.GetDelay(bonlyResponder, itimeElapsed);
        this._Timer.schedule((TimerTask)responder, idelay);
    }

    public void handleResponse(DNSPacket aPacket) {
        this.resolveConflicts(aPacket);
    }

    private void resolveConflicts(DNSPacket aPacket) {
        for (DNSRecord answer : aPacket.getAnswers()) {
            ServiceInfo info = this._LocalServices.get(answer.getName().toLowerCase());
            if (info != null) {
                // empty if block
            }
            if (this._HostInfo.getName() != answer.getName()) continue;
        }
    }
}

