/*
 * Decompiled with CFR 0.152.
 */
package com.orbus.mahalo.tasks;

import com.orbus.mahalo.MahaloSocket;
import com.orbus.mahalo.ServiceInfo;
import com.orbus.mahalo.dns.DNSEntry;
import com.orbus.mahalo.dns.DNSPacket;
import com.orbus.mahalo.dns.DNSQuestion;
import com.orbus.mahalo.dns.DNSRecord;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceResolver
extends TimerTask {
    public static final int INTERVAL = 225;
    private int _iCount = 0;
    private MahaloSocket _Socket;
    private String _sType;
    private List<ServiceInfo> _LocalServices;

    public ServiceResolver(MahaloSocket aSocket, String asType, Collection<ServiceInfo> aServiceList) {
        this._Socket = aSocket;
        this._sType = asType;
        this._LocalServices = new LinkedList<ServiceInfo>(aServiceList);
    }

    @Override
    public void run() {
        ++this._iCount;
        DNSPacket outPacket = new DNSPacket(false);
        outPacket.addQuestion(new DNSQuestion(this._sType, DNSEntry.EntryType.PTR, DNSEntry.EntryClass.IN, false));
        for (ServiceInfo info : this._LocalServices) {
            if (!info.getType().equals(this._sType)) continue;
            outPacket.addAnswer(new DNSRecord.Pointer(this._sType, DNSEntry.EntryType.PTR, DNSEntry.EntryClass.IN, 3600, info.getQualifiedName()));
        }
        this._Socket.send(outPacket);
        if (this._iCount == 3) {
            this.cancel();
        }
    }
}

