/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.search;

import com.cyberfox.util.platform.Path;
import com.google.inject.Singleton;
import com.jbidwatcher.search.SearchManagerInterface;
import com.jbidwatcher.search.Searcher;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.AuctionQObject;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.TimerHandler;
import com.jbidwatcher.util.xml.XMLElement;
import com.jbidwatcher.util.xml.XMLParseException;
import com.jbidwatcher.util.xml.XMLSerializeSimple;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class SearchManager
extends XMLSerializeSimple
implements SearchManagerInterface,
TimerHandler.WakeupProcess {
    private List<Searcher> _searches = new ArrayList<Searcher>();
    private static TimerHandler sTimer;
    private String destinationQueue;
    protected String[] infoTags = new String[]{"search"};

    public void addSearch(Searcher newSearch) {
        this._searches.add(newSearch);
    }

    @Override
    public Searcher getSearchByName(String name) {
        for (Searcher search : this._searches) {
            if (!name.equals(search.getName())) continue;
            return search;
        }
        return null;
    }

    public void setDestinationQueue(String dQueue) {
        this.destinationQueue = dQueue;
    }

    @Override
    public Searcher getSearchByIndex(int i) {
        if (i < this._searches.size()) {
            return this._searches.get(i);
        }
        return null;
    }

    @Override
    public int findSearch(Searcher s) {
        return this._searches.indexOf(s);
    }

    @Override
    public Searcher getSearchById(long id) {
        for (Searcher s : this._searches) {
            if (id != s.getId()) continue;
            return s;
        }
        return null;
    }

    @Override
    public boolean check() {
        boolean fired = false;
        for (Searcher s : this._searches) {
            if (!s.shouldExecute()) continue;
            s.execute();
            fired = true;
        }
        return fired;
    }

    public boolean saveSearches() {
        String saveFile;
        String oldSave = saveFile = JConfig.queryConfiguration("search.savefile", "searches.xml");
        StringBuffer saveData = this.toXML().toStringBuffer();
        if (!(saveFile = Path.getCanonicalFile(saveFile, "jbidwatcher", false)).equals(oldSave)) {
            JConfig.setConfiguration("search.savefile", saveFile);
        }
        boolean saveDone = true;
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(saveFile));
            ps.println("<?xml version=\"1.0\"?>");
            ps.println("");
            ps.println("<!DOCTYPE auctions SYSTEM \"http://www.jbidwatcher.com/searches.dtd\">");
            ps.println("");
            ps.println(saveData);
            ps.close();
        }
        catch (IOException e) {
            JConfig.log().handleException("Failed to save searches.", e);
            saveDone = false;
        }
        return saveDone;
    }

    public void loadSearches() {
        String loadFile;
        XMLElement xmlFile = new XMLElement(true);
        String oldLoad = loadFile = JConfig.queryConfiguration("search.savefile", "searches.xml");
        if (!(loadFile = Path.getCanonicalFile(loadFile, "jbidwatcher", true)).equals(oldLoad)) {
            JConfig.setConfiguration("search.savefile", loadFile);
        }
        try {
            InputStreamReader isr = new InputStreamReader(new FileInputStream(loadFile));
            xmlFile.parseFromReader(isr);
            if (!xmlFile.getTagName().equals("searches")) {
                throw new XMLParseException(xmlFile.getTagName(), "SearchManager only recognizes <searches> tag!");
            }
            this.fromXML(xmlFile);
        }
        catch (IOException ioe) {
            JConfig.log().logDebug("JBW: Failed to load saved searches, the search file is probably not there yet.");
            JConfig.log().logDebug("JBW: This is not an error, unless you are consistently getting it.");
        }
        catch (Exception e) {
            JConfig.log().handleException("JBW: Failed to load saved searches, file exists but can't be loaded!", e);
        }
    }

    @Override
    public XMLElement toXML() {
        XMLElement allData = new XMLElement("searches");
        for (Searcher s : this._searches) {
            XMLElement search = s.toXML();
            allData.addChild(search);
        }
        return allData;
    }

    @Override
    protected String[] getTags() {
        return this.infoTags;
    }

    @Override
    protected void handleTag(int i, XMLElement curElement) {
        switch (i) {
            case 0: {
                String type = curElement.getProperty("TYPE");
                long id = 0L;
                try {
                    id = Long.parseLong(curElement.getProperty("ID"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Searcher s = this.newSearch(type);
                s.setId(id);
                s.fromXML(curElement);
                if (s.getId() == 0L) {
                    if (s.getTypeName().equals("My Items")) {
                        s.setId(1L);
                    } else {
                        s.setId((long)s.getName().hashCode() + System.currentTimeMillis() + (long)s.getSearch().hashCode());
                    }
                }
                if (this.getSearchById(s.getId()) != null) break;
                this._searches.add(s);
                break;
            }
        }
    }

    @Override
    public int getSearchCount() {
        return this._searches.size();
    }

    @Override
    public void deleteSearch(Searcher s) {
        this._searches.remove(s);
    }

    private Searcher newSearch(String type) {
        if (type.startsWith("Text")) {
            return new StringSearcher();
        }
        if (type.startsWith("Title")) {
            return new TitleSearcher();
        }
        if (type.startsWith("Seller")) {
            return new SellerSearcher();
        }
        if (type.startsWith("URL")) {
            return new URLSearcher();
        }
        if (type.equals("My Items")) {
            return new MyItemSearcher();
        }
        JConfig.log().logMessage("Failed to create searcher for: " + type);
        return null;
    }

    @Override
    public Searcher addSearch(String type, String name, String search, String server, int period, long id) {
        Searcher s = this.buildSearch(id, type, name, search, server, null, period);
        this._searches.add(s);
        return s;
    }

    public Searcher buildSearch(long id, String type, String name, String search, String server, String currency, int period) {
        Searcher s = this.newSearch(type);
        s.setId(id);
        s.setName(name);
        s.setSearch(search);
        s.setServer(server);
        s.setPeriod(period);
        s.setCurrency(currency);
        return s;
    }

    public void saveSearchDisplay() {
        String xCfg = JConfig.queryAuxConfiguration("searches.x", JConfig.queryDisplayProperty("searches.x"));
        String yCfg = JConfig.queryAuxConfiguration("searches.y", JConfig.queryDisplayProperty("searches.y"));
        String wCfg = JConfig.queryAuxConfiguration("searches.width", JConfig.queryDisplayProperty("searches.width"));
        String hCfg = JConfig.queryAuxConfiguration("searches.height", JConfig.queryDisplayProperty("searches.height"));
        if (xCfg != null && yCfg != null && wCfg != null && hCfg != null) {
            JConfig.setAuxConfiguration("searches.x", xCfg);
            JConfig.setAuxConfiguration("searches.y", yCfg);
            JConfig.setAuxConfiguration("searches.width", wCfg);
            JConfig.setAuxConfiguration("searches.height", hCfg);
        }
    }

    public void deleteSearch(String searchName) {
        Searcher old = this.getSearchByName(searchName);
        if (old != null) {
            this.deleteSearch(old);
        }
    }

    public void start() {
        if (sTimer == null) {
            sTimer = new TimerHandler(this, 60000L);
            sTimer.setName("Searches");
            sTimer.start();
        }
    }

    public class MyItemSearcher
    extends Searcher {
        @Override
        public String getTypeName() {
            return "My Items";
        }

        @Override
        protected void fire() {
            MQFactory.getConcrete(SearchManager.this.destinationQueue).enqueueBean(new AuctionQObject(3, null, this.hasCategory() ? this.getCategory() : null));
        }
    }

    public class SellerSearcher
    extends Searcher {
        @Override
        public String getTypeName() {
            return "Seller";
        }

        @Override
        protected void fire() {
            MQFactory.getConcrete(SearchManager.this.destinationQueue).enqueueBean(new AuctionQObject(2, this.getId(), this.getCategory()));
        }
    }

    public class URLSearcher
    extends Searcher {
        @Override
        public String getTypeName() {
            return "URL";
        }

        @Override
        protected void fire() {
            MQFactory.getConcrete(SearchManager.this.destinationQueue).enqueueBean(new AuctionQObject(0, this.getId(), this.getCategory()));
        }
    }

    public class TitleSearcher
    extends Searcher {
        @Override
        public String getTypeName() {
            return "Title";
        }

        @Override
        protected void fire() {
            MQFactory.getConcrete(SearchManager.this.destinationQueue).enqueueBean(new AuctionQObject(6, this.getId(), this.getCategory()));
        }
    }

    public class StringSearcher
    extends Searcher {
        @Override
        public String getTypeName() {
            return "Text";
        }

        @Override
        protected void fire() {
            MQFactory.getConcrete(SearchManager.this.destinationQueue).enqueueBean(new AuctionQObject(1, this.getId(), this.getCategory()));
        }
    }
}

