/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.jbidwatcher.ui.util.JDropHandler;
import com.jbidwatcher.util.config.JConfig;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class JDropListener
implements DropTargetListener {
    private JDropHandler handler;
    private DataFlavor _plainFlavor = null;
    private static final String[][] _str_flavors = new String[][]{{"javaUrlFlavor", "application/x-java-url; class=java.net.URL"}, {"UTF8Html", "text/html; class=java.io.InputStream; charset=UTF-8"}, {"isoFlavor", "text/plain; class=java.io.InputStream; charset=iso8859-1"}, {"utfFlavor", "text/plain; class=java.io.InputStream; charset=UTF-8"}, {"ascFlavor", "text/plain; class=java.io.InputStream; charset=ascii"}, {"pl2Flavor", "text/plain; class=java.io.InputStream"}, {"thtmlFlavor", "text/html"}, {"htmlFlavor", "text/html; class=java.io.Reader; charset=Unicode"}, {"urlFlavor", "application/x-url; class=java.io.InputStream"}};
    private static final int ALL_ACTIONS = 0x40000003;
    List<DataFlavor> allFlavors = new ArrayList<DataFlavor>(_str_flavors.length);

    public JDropListener(JDropHandler inHandler) {
        this.setupFlavors();
        this.handler = inHandler;
    }

    private void setupFlavors() {
        if (this._plainFlavor == null) {
            this._plainFlavor = DataFlavor.getTextPlainUnicodeFlavor();
        }
        if (this.allFlavors.size() == 0) {
            for (String[] flavorPair : _str_flavors) {
                String flavor = flavorPair[1];
                try {
                    DataFlavor df = new DataFlavor(flavor);
                    this.allFlavors.add(df);
                }
                catch (ClassNotFoundException e) {
                    JConfig.log().logDebug("Could not add data flavor: " + flavor);
                }
            }
        }
    }

    private void dumpDataFlavors(DataFlavor[] dfa) {
        if (dfa != null) {
            if (dfa.length == 0) {
                System.err.println("Length is still zero!");
            }
            for (int j = 0; j < dfa.length; ++j) {
                System.err.println("Flavah " + j + " == " + dfa[j].getHumanPresentableName());
                System.err.println("Flavah/mime " + j + " == " + dfa[j].getMimeType());
            }
        } else {
            System.err.println("Flavahs supported: none!\n");
        }
    }

    private boolean testFlavor(DataFlavor inFlavor, Transferable t) {
        if (inFlavor != null && t.isDataFlavorSupported(inFlavor)) {
            JConfig.log().logVerboseDebug("Accepting(2): " + inFlavor.getMimeType());
            return true;
        }
        return false;
    }

    private boolean testFlavor(DataFlavor inFlavor, DropTargetDragEvent t) {
        if (inFlavor != null && t.isDataFlavorSupported(inFlavor)) {
            JConfig.log().logVerboseDebug("Accepting(1): " + inFlavor.getMimeType());
            return true;
        }
        return false;
    }

    private DataFlavor testAllFlavors(Transferable t) {
        for (DataFlavor df : this.allFlavors) {
            if (!this.testFlavor(df, t)) continue;
            return df;
        }
        if (this.testFlavor(this._plainFlavor, t)) {
            return this._plainFlavor;
        }
        if (this.testFlavor(DataFlavor.stringFlavor, t)) {
            return DataFlavor.stringFlavor;
        }
        return null;
    }

    private DataFlavor testAllFlavors(DropTargetDragEvent dtde) {
        for (DataFlavor df : this.allFlavors) {
            if (!this.testFlavor(df, dtde)) continue;
            return df;
        }
        if (this.testFlavor(this._plainFlavor, dtde)) {
            return this._plainFlavor;
        }
        if (this.testFlavor(DataFlavor.stringFlavor, dtde)) {
            return DataFlavor.stringFlavor;
        }
        return null;
    }

    private void acceptDrag(DropTargetDragEvent dtde) {
        int dragaction = dtde.getDropAction();
        if (dragaction != 0) {
            dtde.acceptDrag(dragaction);
        } else {
            dtde.acceptDrag(0x40000003);
        }
    }

    private void acceptDrop(DropTargetDropEvent dtde) {
        int dragaction = dtde.getDropAction();
        if (dragaction != 0) {
            dtde.acceptDrop(dragaction);
        } else {
            dtde.acceptDrop(0x40000003);
        }
    }

    private void checkDrag(DropTargetDragEvent dtde) {
        int da = dtde.getDropAction();
        if (dtde.getCurrentDataFlavors().length == 0) {
            JConfig.log().logVerboseDebug("Zero length accepted... (" + da + ")");
            this.acceptDrag(dtde);
            return;
        }
        if (this.testAllFlavors(dtde) != null) {
            JConfig.log().logVerboseDebug("Accepting drag! (" + da + ")");
            this.acceptDrag(dtde);
        } else {
            dtde.rejectDrag();
            JConfig.log().logVerboseDebug("Rejecting drag! (" + da + ")");
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        JConfig.log().logVerboseDebug("DragEnter!");
        this.checkDrag(dtde);
        if (JConfig.queryConfiguration("debug.uber", "false").equals("true") && JConfig.debugging) {
            this.dumpDataFlavors(dtde.getCurrentDataFlavors());
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.checkDrag(dtde);
    }

    @Override
    public void dragExit(DropTargetEvent dtde) {
        JConfig.log().logVerboseDebug("Drag exited!");
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        this.acceptDrag(dtde);
        JConfig.log().logVerboseDebug("Drag Action Changed!");
    }

    private void dumpFlavorsOld(Transferable t) {
        DataFlavor[] dfa = t.getTransferDataFlavors();
        if (dfa != null && dfa.length == 0) {
            JConfig.log().logVerboseDebug("Trying a second attack...");
            try {
                Clipboard sysClip = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable t2 = sysClip.getContents(null);
                StringBuffer stBuff = this.getTransferData(t2);
                JConfig.log().logVerboseDebug("Check out: " + stBuff);
            }
            catch (Exception e) {
                JConfig.log().handleException("Caught: " + e, e);
            }
            JConfig.log().logVerboseDebug("Done trying a second attack...");
        }
        this.dumpDataFlavors(dfa);
    }

    private BufferedReader useNewAPI(Transferable t, DataFlavor dtf) {
        Reader dropReader = null;
        try {
            dropReader = dtf.getReaderForText(t);
        }
        catch (UnsupportedFlavorException e) {
            JConfig.log().handleDebugException("Unable to read dropped data (bad flavor)", e);
        }
        catch (IOException e) {
            JConfig.log().handleDebugException("Unable to read dropped data (unspecific error)", e);
        }
        if (dropReader != null) {
            BufferedReader br = new BufferedReader(dropReader);
            return br;
        }
        return null;
    }

    private StringBuffer getDataFromReader(Reader br) {
        StringBuffer xferData = null;
        try {
            int charsRead;
            char[] buf = new char[513];
            do {
                if ((charsRead = br.read(buf, 0, 512)) == -1) continue;
                JConfig.log().logVerboseDebug("Read: " + charsRead + " characters.");
                if (xferData == null) {
                    xferData = new StringBuffer();
                }
                xferData.append(buf, 0, charsRead);
            } while (charsRead != -1);
            br.close();
        }
        catch (IOException e) {
            JConfig.log().logDebug("Caught an IO Exception trying to read the drag/drop data!");
            return null;
        }
        return xferData;
    }

    private StringBuffer getDataFromStream(InputStream br) {
        return this.getDataFromReader(new InputStreamReader(br));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer getInputStreamData(Transferable t, DataFlavor dtf, InputStream dropStream) {
        StringBuffer xferData;
        BufferedReader br = this.useNewAPI(t, dtf);
        try {
            if (br == null) {
                InputStreamReader isr;
                block16: {
                    if (JConfig.queryConfiguration("debug.uber", "false").equals("true")) {
                        JConfig.log().logDebug("Non-getReaderForText: " + dropStream);
                    }
                    isr = new InputStreamReader(dropStream, "utf-16le");
                    xferData = this.getDataFromStream(dropStream);
                    if (xferData == null) break block16;
                    StringBuffer stringBuffer = xferData;
                    return stringBuffer;
                }
                try {
                    br = new BufferedReader(isr);
                }
                catch (UnsupportedEncodingException uee) {
                    JConfig.log().logDebug("Unicode encoding unsupported.");
                    br = new BufferedReader(new InputStreamReader(dropStream));
                }
            }
            xferData = this.getDataFromReader(br);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return xferData;
    }

    public StringBuffer getTransferData(Transferable t) {
        Object dropped;
        DataFlavor dtf = this.testAllFlavors(t);
        JConfig.log().logVerboseDebug("dtf == " + dtf);
        try {
            dropped = t.getTransferData(dtf);
        }
        catch (IOException ioe) {
            try {
                dropped = t.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                JConfig.log().logDebug("I/O Exception: " + ioe);
                return null;
            }
        }
        catch (UnsupportedFlavorException ufe) {
            try {
                dropped = t.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                JConfig.log().logDebug("Unsupported flavor: " + dtf);
                return null;
            }
        }
        if (dropped != null) {
            StringBuffer xferData = null;
            if (dropped instanceof InputStream) {
                JConfig.log().logVerboseDebug("Dropped an InputStream");
                xferData = this.getInputStreamData(t, dtf, (InputStream)dropped);
            } else if (dropped instanceof Reader) {
                JConfig.log().logVerboseDebug("Dropped a Reader");
                xferData = this.getDataFromReader(new BufferedReader((Reader)dropped));
            } else if (dropped instanceof URL) {
                JConfig.log().logVerboseDebug("Dropped a URL");
                JConfig.log().logVerboseDebug("Got: " + dropped.toString());
                xferData = new StringBuffer(dropped.toString());
            } else if (dropped instanceof String) {
                JConfig.log().logVerboseDebug("Dropped a String");
                xferData = new StringBuffer((String)dropped);
            }
            return xferData;
        }
        return null;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Transferable t = dtde.getTransferable();
        JConfig.log().logVerboseDebug("Dropping!");
        if (t.getTransferDataFlavors().length == 0) {
            Clipboard sysClip = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable t2 = sysClip.getContents(null);
            JConfig.log().logDebug("Dropped 0 data flavors, trying clipboard.");
            DataFlavor[] dfa2 = null;
            if (t2 != null) {
                JConfig.log().logVerboseDebug("t2 is not null: " + t2);
                dfa2 = t2.getTransferDataFlavors();
                JConfig.log().logVerboseDebug("Back from getTransferDataFlavors()!");
            } else {
                JConfig.log().logVerboseDebug("t2 is null!");
            }
            this.dumpAllFlavorsSupported(dfa2);
        }
        if (JConfig.queryConfiguration("debug.uber", "false").equals("true") && JConfig.debugging) {
            this.dumpFlavorsOld(t);
        }
        DataFlavor dtf = this.testAllFlavors(t);
        StringBuffer dropData = null;
        if (dtf != null) {
            JConfig.log().logVerboseDebug("Accepting!");
            this.acceptDrop(dtde);
            dropData = this.getTransferData(t);
            dtde.dropComplete(true);
            dtde.getDropTargetContext().dropComplete(true);
            if (dropData != null && this.handler != null) {
                this.handler.receiveDropString(dropData, dtde.getLocation());
            }
        } else {
            JConfig.log().logVerboseDebug("Rejecting!");
            dtde.rejectDrop();
            this.handler.receiveDropString(dropData, dtde.getLocation());
        }
    }

    private void dumpAllFlavorsSupported(DataFlavor[] dfa2) {
        if (JConfig.queryConfiguration("debug.uber", "false").equals("true")) {
            if (dfa2 != null) {
                if (dfa2.length == 0) {
                    JConfig.log().logVerboseDebug("Length is still zero!");
                }
                for (int j = 0; j < dfa2.length; ++j) {
                    JConfig.log().logVerboseDebug("Flavah " + j + " == " + dfa2[j].getHumanPresentableName());
                    JConfig.log().logVerboseDebug("Flavah/mime " + j + " == " + dfa2[j].getMimeType());
                }
            } else {
                JConfig.log().logVerboseDebug("Flavahs supported: none!\n");
            }
        }
    }
}

