/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.table;

import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.Seller;
import com.jbidwatcher.util.Currency;
import com.jbidwatcher.util.config.JConfig;
import java.util.HashMap;
import java.util.Map;

class AuctionSortable {
    private AuctionEntry entry;
    private static Map<String, Seller> sellers = new HashMap<String, Seller>();

    public void setEntry(AuctionEntry ae) {
        this.entry = ae;
    }

    private Seller getSeller(String sellerId) {
        Seller seller;
        if (sellers.containsKey(sellerId)) {
            seller = sellers.get(sellerId);
        } else {
            seller = Seller.findFirstBy("id", sellerId);
            sellers.put(sellerId, seller);
        }
        return seller;
    }

    private int safeConvert(String feedbackPercent) {
        int rval;
        try {
            rval = (int)(Double.parseDouble(feedbackPercent) * 10.0);
        }
        catch (NumberFormatException e) {
            rval = 0;
        }
        return rval;
    }

    private Currency getMaxOrSnipe(AuctionEntry aEntry) {
        if (aEntry.isSniped()) {
            return aEntry.getSnipeAmount();
        }
        if (aEntry.isBidOn()) {
            return aEntry.getBid();
        }
        if (aEntry.snipeCancelled() && aEntry.isComplete()) {
            return aEntry.getCancelledSnipe();
        }
        return Currency.NoValue();
    }

    public String getId() {
        return this.entry.getIdentifier();
    }

    public Currency getCurrentBid() {
        if (this.entry.getDefaultCurrency().getCurrencyType() == 1) {
            return this.entry.getCurrentPrice();
        }
        Currency rval = this.entry.getUSCurBid();
        if (rval.getValue() == 0.0 && rval.getCurrencyType() == 1) {
            return this.entry.getCurrentUSPrice();
        }
        return rval;
    }

    public Currency getSnipeOrMax() {
        return Currency.convertToUSD(this.entry.getCurrentUSPrice(), this.entry.getCurrentPrice(), this.getMaxOrSnipe(this.entry));
    }

    public Currency getFixedPrice() {
        return Currency.convertToUSD(this.entry.getCurrentUSPrice(), this.entry.getCurrentPrice(), this.entry.getBuyNow());
    }

    public Currency getShippingInsurance() {
        Currency si = !this.entry.getShipping().isNull() ? this.entry.getShippingWithInsurance() : Currency.NoValue();
        return Currency.convertToUSD(this.entry.getCurrentUSPrice(), this.entry.getCurrentPrice(), si);
    }

    public Currency getMax() {
        Currency bid = this.entry.isBidOn() ? this.entry.getBid() : Currency.NoValue();
        return Currency.convertToUSD(this.entry.getCurrentUSPrice(), this.entry.getCurrentPrice(), bid);
    }

    public Currency getSnipe() {
        Currency snipe = this.entry.getSnipeAmount();
        return Currency.convertToUSD(this.entry.getCurrentUSPrice(), this.entry.getCurrentPrice(), snipe);
    }

    public int getSellerPositiveFeedback() {
        Seller seller = this.getSeller(this.entry.getSellerId());
        try {
            String feedbackPercent = seller.getPositivePercentage();
            if (feedbackPercent != null) {
                feedbackPercent = feedbackPercent.replace("%", "");
            }
            return this.safeConvert(feedbackPercent);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getComment() {
        String s = this.entry.getComment();
        return s == null ? "" : s;
    }

    public int getSellerFeedback() {
        Seller seller = this.getSeller(this.entry.getSellerId());
        return seller.getFeedback();
    }

    public Currency getCurrentTotal() {
        Currency shipping = this.entry.getShippingWithInsurance();
        if (shipping.getCurrencyType() == 0) {
            return shipping;
        }
        Currency shippingUSD = Currency.convertToUSD(this.entry.getCurrentUSPrice(), this.entry.getCurrentPrice(), this.entry.getShippingWithInsurance());
        try {
            return this.entry.getUSCurBid().add(shippingUSD);
        }
        catch (Currency.CurrencyTypeException e) {
            JConfig.log().handleException("Threw a bad currency exception, which should be unlikely.", e);
            return Currency.NoValue();
        }
    }

    public Currency getSnipeTotal() {
        Currency shipping = this.entry.getShippingWithInsurance();
        if (shipping.getCurrencyType() == 0) {
            return shipping;
        }
        Currency shippingUSD = Currency.convertToUSD(this.entry.getCurrentUSPrice(), this.entry.getCurrentPrice(), this.entry.getShippingWithInsurance());
        try {
            return Currency.convertToUSD(this.entry.getCurrentUSPrice(), this.entry.getCurrentPrice(), this.entry.getSnipeAmount()).add(shippingUSD);
        }
        catch (Currency.CurrencyTypeException e) {
            JConfig.log().handleException("Currency addition or conversion threw a bad currency exception, which should be unlikely.", e);
            return Currency.NoValue();
        }
    }
}

