/*
 * Decompiled with CFR 0.152.
 */
package com.DeskMetrics;

import com.DeskMetrics.Services;
import com.DeskMetrics.Util;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class DeskMetrics {
    private static final String API_ENDPOINT = "api.deskmetrics.com/sendData";
    private static final String SCHEME = "http://";
    private List<String> Events = new ArrayList<String>();
    private long freeDiskSpace;
    private long totalDiskSpace;
    private String appID;
    private String appVersion;
    private String sessionID;
    private int flow = 0;
    private String url = "";
    private String endpoint = null;
    private static DeskMetrics instance;
    private Map<String, Integer> languageCodes = new HashMap<String, Integer>();

    private DeskMetrics() {
        this.languageCodes.put("ja", 1041);
        this.languageCodes.put("es", 1034);
        this.languageCodes.put("en", 1033);
        this.languageCodes.put("sr", 2074);
        this.languageCodes.put("mk", 1071);
        this.languageCodes.put("mk", 1071);
        this.languageCodes.put("no", 1044);
        this.languageCodes.put("sq", 1052);
        this.languageCodes.put("sq", 1052);
        this.languageCodes.put("bg", 1026);
        this.languageCodes.put("hu", 1038);
        this.languageCodes.put("pt", 1036);
        this.languageCodes.put("pt", 1036);
        this.languageCodes.put("sv", 1053);
        this.languageCodes.put("de", 1031);
        this.languageCodes.put("fi", 1035);
        this.languageCodes.put("is", 1039);
        this.languageCodes.put("cs", 1029);
        this.languageCodes.put("sl", 1060);
        this.languageCodes.put("sk", 1051);
        this.languageCodes.put("it", 1040);
        this.languageCodes.put("tr", 1055);
        this.languageCodes.put("th", 1054);
        this.languageCodes.put("ro", 2072);
        this.languageCodes.put("fr", 1036);
        this.languageCodes.put("ko", 1042);
        this.languageCodes.put("et", 1061);
        this.languageCodes.put("ru", 1049);
        this.languageCodes.put("lv", 1062);
        this.languageCodes.put("lv", 1062);
        this.languageCodes.put("hr", 1050);
        this.languageCodes.put("hi", 1081);
        this.languageCodes.put("be", 1059);
        this.languageCodes.put("ca", 1027);
        this.languageCodes.put("uk", 1058);
        this.languageCodes.put("pl", 1045);
        this.languageCodes.put("vi", 1066);
        this.languageCodes.put("mt", 1082);
        this.languageCodes.put("ms", 1086);
        this.languageCodes.put("da", 1030);
    }

    public static DeskMetrics getInstance() {
        if (instance == null) {
            instance = new DeskMetrics();
        }
        return instance;
    }

    public void setEndpoint(String newEndpoint) {
        this.endpoint = newEndpoint;
    }

    public void start(String appID, String appVersion) {
        this.appID = appID;
        this.appVersion = appVersion;
        HashMap<String, Object> startApp = new HashMap<String, Object>();
        startApp.put("tp", "strApp");
        startApp.put("aver", appVersion);
        startApp.put("aid", appID);
        startApp.put("ID", this.getUserID());
        startApp.put("ss", this.getSessionID());
        startApp.put("ts", Util.getCurrentTimeStamp());
        startApp.put("osv", System.getProperty("os.name"));
        startApp.put("ossp", "null");
        startApp.put("osar", System.getProperty("os.arch"));
        startApp.put("osjv", System.getProperty("java.version"));
        startApp.put("osnet", this.getDotNetVersion());
        startApp.put("oslng", this.languageCodes.get(Locale.getDefault().getLanguage()).toString());
        startApp.put("osscn", this.getScreenResolution());
        startApp.put("ccr", Runtime.getRuntime().availableProcessors());
        startApp.put("cbr", "null");
        startApp.put("cnm", "null");
        startApp.put("car", "null");
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objName = new ObjectName("java.lang:type=OperatingSystem");
            if (mbs.isInstanceOf(objName, "com.sun.management.OperatingSystemMXBean")) {
                startApp.put("mtt", mbs.getAttribute(objName, "TotalPhysicalMemorySize"));
                startApp.put("mfr", mbs.getAttribute(objName, "FreePhysicalMemorySize"));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        startApp.put("dtt", this.totalDiskSpace);
        startApp.put("dfr", this.freeDiskSpace);
        this.Events.add(Util.getJSONFromMap(startApp));
        this.url = this.getUrl();
    }

    private String getUrl() {
        if (this.endpoint != null) {
            return this.endpoint;
        }
        return SCHEME + this.appID + "." + API_ENDPOINT;
    }

    public void trackEvent(String category, String name) {
        HashMap<String, Object> hash = new HashMap<String, Object>();
        hash.put("tp", "ev");
        hash.put("ca", category);
        hash.put("nm", name);
        hash.put("ts", Util.getCurrentTimeStamp());
        hash.put("ss", this.getSessionID());
        hash.put("fl", this.flow);
        ++this.flow;
        String json = Util.getJSONFromMap(hash);
        this.Events.add(json);
    }

    public void trackEventValue(String category, String name, String value) {
        HashMap<String, Object> hash = new HashMap<String, Object>();
        hash.put("tp", "evV");
        hash.put("ca", category);
        hash.put("nm", name);
        hash.put("vl", value);
        hash.put("ts", Util.getCurrentTimeStamp());
        hash.put("ss", this.getSessionID());
        hash.put("fl", this.flow);
        ++this.flow;
        String json = Util.getJSONFromMap(hash);
        this.Events.add(json);
    }

    public void trackCustomData(String name, String value) {
        HashMap<String, Object> hash = new HashMap<String, Object>();
        hash.put("tp", "ctD");
        hash.put("nm", name);
        hash.put("vl", value);
        hash.put("ts", Util.getCurrentTimeStamp());
        hash.put("ss", this.getSessionID());
        hash.put("fl", this.flow);
        ++this.flow;
        String json = Util.getJSONFromMap(hash);
        this.Events.add(json);
    }

    public void trackCustomDataR(String name, String value) throws IOException {
        HashMap<String, Object> hash = new HashMap<String, Object>();
        hash.put("tp", "ctDR");
        hash.put("nm", name);
        hash.put("vl", value);
        hash.put("aver", this.appVersion);
        hash.put("ID", this.getUserID());
        hash.put("ts", Util.getCurrentTimeStamp());
        hash.put("ss", this.getSessionID());
        hash.put("fl", this.flow);
        ++this.flow;
        String json = Util.getJSONFromMap(hash);
        Services.sendDataToUrl(json, this.url);
    }

    public void trackInstall(String version) throws IOException {
        HashMap<String, Object> hash = new HashMap<String, Object>();
        hash.put("tp", "ist");
        hash.put("ID", this.getUserID());
        hash.put("aid", this.appID);
        hash.put("aver", version);
        hash.put("ts", Util.getCurrentTimeStamp());
        hash.put("ss", this.getSessionID());
        String json = Util.getJSONFromMap(hash);
        Services.sendDataToUrl(json, this.getUrl());
    }

    public void trackUninstall(String version) throws IOException {
        HashMap<String, Object> hash = new HashMap<String, Object>();
        hash.put("tp", "ust");
        hash.put("ID", this.getUserID());
        hash.put("aid", this.appID);
        hash.put("aver", version);
        hash.put("ts", Util.getCurrentTimeStamp());
        hash.put("ss", this.getSessionID());
        String json = Util.getJSONFromMap(hash);
        Services.sendDataToUrl(json, this.getUrl());
    }

    public void trackLog(String message) {
        HashMap<String, Object> hash = new HashMap<String, Object>();
        hash.put("tp", "lg");
        hash.put("ms", message);
        hash.put("ts", Util.getCurrentTimeStamp());
        hash.put("ss", this.getSessionID());
        hash.put("fl", this.flow);
        ++this.flow;
        String json = Util.getJSONFromMap(hash);
        this.Events.add(json);
    }

    public void trackEventTimed(String category, String name, int time, boolean finished) {
        HashMap<String, Object> hash = new HashMap<String, Object>();
        hash.put("tp", "evP");
        hash.put("ca", category);
        hash.put("nm", name);
        hash.put("ec", finished ? "1" : "0");
        hash.put("tm", String.valueOf(time));
        hash.put("ts", Util.getCurrentTimeStamp());
        hash.put("ss", this.getSessionID());
        hash.put("fl", this.flow);
        ++this.flow;
        String json = Util.getJSONFromMap(hash);
        this.Events.add(json);
    }

    public void trackException(Exception e) {
        HashMap<String, Object> hash = new HashMap<String, Object>();
        hash.put("tp", "exC");
        hash.put("msg", e.getMessage().replaceAll("\n", " ").replaceAll("\r", " "));
        String stackTrace = "";
        for (StackTraceElement element : e.getStackTrace()) {
            stackTrace = stackTrace + element.toString().replaceAll("\n", " ").replace("\r", " ");
        }
        hash.put("stk", stackTrace);
        hash.put("ts", Util.getCurrentTimeStamp());
        hash.put("ss", this.getSessionID());
        hash.put("fl", this.flow);
        ++this.flow;
        String json = Util.getJSONFromMap(hash);
        this.Events.add(json);
    }

    public void flush() throws IOException {
        Services.sendDataToUrl(Util.getJSONFromJSONList(this.Events), this.url);
        this.Events.clear();
    }

    public void stop() throws IOException {
        HashMap<String, Object> stApp = new HashMap<String, Object>();
        stApp.put("tp", "stApp");
        stApp.put("ts", Util.getCurrentTimeStamp());
        stApp.put("ss", this.getSessionID());
        this.Events.add(Util.getJSONFromMap(stApp));
        Services.sendDataToUrl(Util.getJSONFromJSONList(this.Events), this.url);
    }

    private long invoke(File file, String method) {
        try {
            Method getFreeSpace = File.class.getMethod(method, new Class[0]);
            return (Long)getFreeSpace.invoke((Object)file, new Object[0]);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private String getUserID() {
        String filename = System.getProperty("user.home") + System.getProperty("file.separator") + ".deskmetrics";
        File file = new File(filename);
        String userID = "";
        this.freeDiskSpace = this.invoke(file, "getFreeSpace");
        this.totalDiskSpace = this.invoke(file, "getTotalSpace");
        try {
            if (file.exists()) {
                BufferedReader fileReader = new BufferedReader(new FileReader(file));
                userID = fileReader.readLine();
            } else if (file.createNewFile()) {
                BufferedWriter fileWriter = new BufferedWriter(new FileWriter(file));
                userID = Util.getMD5(String.valueOf(System.nanoTime()));
                fileWriter.write(userID);
                fileWriter.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return userID;
    }

    private String getSessionID() {
        if (this.sessionID == null) {
            this.sessionID = Util.getMD5(String.valueOf(System.nanoTime()));
        }
        return this.sessionID;
    }

    private String getDotNetVersion() {
        return "null";
    }

    private String getScreenResolution() {
        Toolkit t = null;
        try {
            t = Toolkit.getDefaultToolkit();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (t != null) {
            String width = String.valueOf(t.getScreenSize().getWidth());
            String height = String.valueOf(t.getScreenSize().getHeight());
            width = width.substring(0, width.indexOf("."));
            height = height.substring(0, height.indexOf("."));
            return width + "x" + height;
        }
        return "???x???";
    }
}

