/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tessboxeditor;

import java.awt.Component;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextArea;
import net.sourceforge.tessboxeditor.Gui;
import net.sourceforge.tessboxeditor.GuiWithGenerator;

public class FileDropTargetListener
extends DropTargetAdapter {
    private final Window holder;
    private final Component comp;
    private File droppedFile;
    private static final Logger logger = Logger.getLogger(FileDropTargetListener.class.getName());

    public FileDropTargetListener(Window window, Component component) {
        this.holder = window;
        this.comp = component;
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this.droppedFile == null) {
            DataFlavor[] dataFlavorArray;
            for (DataFlavor dataFlavor : dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors()) {
                if (!dataFlavor.isFlavorJavaFileListType()) continue;
                dropTargetDragEvent.acceptDrag(1);
                return;
            }
        }
        dropTargetDragEvent.rejectDrag();
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        boolean bl = System.getProperty("os.name").equals("Linux");
        for (DataFlavor dataFlavor : dataFlavorArray) {
            try {
                if (!dataFlavor.equals(DataFlavor.javaFileListFlavor) && (!bl || !dataFlavor.getPrimaryType().equals("text") || !dataFlavor.getSubType().equals("uri-list"))) continue;
                dropTargetDropEvent.acceptDrop(1);
                if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    this.droppedFile = (File)list.get(0);
                } else {
                    String string = transferable.getTransferData(DataFlavor.stringFlavor).toString().replaceAll("\r\n?", "\n");
                    URI uRI = new URI(string.substring(0, string.indexOf(10)));
                    this.droppedFile = new File(uRI);
                }
                new Thread(){

                    @Override
                    public void run() {
                        if (FileDropTargetListener.this.holder instanceof Gui) {
                            if (FileDropTargetListener.this.comp instanceof JTextArea) {
                                ((GuiWithGenerator)FileDropTargetListener.this.holder).openTextFile(FileDropTargetListener.this.droppedFile);
                            } else {
                                ((Gui)FileDropTargetListener.this.holder).openFile(FileDropTargetListener.this.droppedFile);
                            }
                        }
                        FileDropTargetListener.this.droppedFile = null;
                    }
                }.start();
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            catch (UnsupportedFlavorException | IOException | URISyntaxException exception) {
                logger.log(Level.WARNING, exception.getMessage(), exception);
                dropTargetDropEvent.rejectDrop();
            }
        }
        dropTargetDropEvent.dropComplete(false);
    }
}

