/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tessboxeditor.datamodel;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.tessboxeditor.datamodel.TessBox;

public class TessBoxCollection {
    private String appendingSymbols;
    private String prependingSymbols;
    private final List<TessBox> list = new ArrayList<TessBox>();

    public void add(TessBox tessBox) {
        this.list.add(tessBox);
    }

    public void add(int n, TessBox tessBox) {
        this.list.add(n, tessBox);
    }

    public void deselectAll() {
        for (TessBox tessBox : this.list) {
            tessBox.setSelected(false);
        }
    }

    public List<TessBox> toList() {
        return this.list;
    }

    public TessBox select(TessBox tessBox) {
        for (TessBox tessBox2 : this.list) {
            if (!tessBox2.getRect().equals(tessBox.getRect())) continue;
            return tessBox2;
        }
        return null;
    }

    public TessBox selectByChars(TessBox tessBox) {
        List<TessBox> list;
        List<TessBox> list2 = this.getSelectedBoxes();
        if (list2.isEmpty()) {
            list = this.list;
        } else {
            TessBox tessBox2 = list2.get(list2.size() - 1);
            int n = this.list.indexOf(tessBox2);
            list = this.list.subList(n + 1, this.list.size());
        }
        for (TessBox tessBox3 : list) {
            if (!tessBox3.getChrs().contains(tessBox.getChrs())) continue;
            return tessBox3;
        }
        return null;
    }

    public TessBox hitObject(Point point) {
        for (TessBox tessBox : this.list) {
            if (!tessBox.contains(point)) continue;
            return tessBox;
        }
        return null;
    }

    public List<TessBox> getSelectedBoxes() {
        ArrayList<TessBox> arrayList = new ArrayList<TessBox>();
        for (TessBox tessBox : this.list) {
            if (!tessBox.isSelected()) continue;
            arrayList.add(tessBox);
        }
        return arrayList;
    }

    public void setCombiningSymbols(String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(";");
        if (stringArray.length > 0) {
            this.appendingSymbols = stringArray[0];
        }
        if (stringArray.length > 1) {
            this.prependingSymbols = stringArray[1];
        }
    }

    public void combineBoxes() {
        TessBox tessBox = null;
        for (TessBox tessBox2 : this.list.toArray(new TessBox[this.list.size()])) {
            if (tessBox != null && (tessBox2.getRect().equals(tessBox.getRect()) || tessBox.getRect().contains(tessBox2.getRect()))) {
                this.list.remove(tessBox2);
                tessBox.setChrs(tessBox.getChrs() + tessBox2.getChrs());
                continue;
            }
            if (tessBox != null && (this.appendingSymbols != null && this.appendingSymbols.trim().length() > 0 && tessBox2.getChrs().matches("[" + this.appendingSymbols + "]") || this.prependingSymbols != null && this.prependingSymbols.trim().length() > 0 && tessBox.getChrs().matches("[" + this.prependingSymbols + "]"))) {
                this.list.remove(tessBox2);
                tessBox.setChrs(tessBox.getChrs() + tessBox2.getChrs());
                Rectangle rectangle = tessBox.getRect();
                Rectangle rectangle2 = tessBox2.getRect();
                int n = Math.min(rectangle.x, rectangle2.x);
                int n2 = Math.min(rectangle.y, rectangle2.y);
                int n3 = Math.max(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width);
                int n4 = Math.max(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height);
                tessBox.setRect(new Rectangle(n, n2, n3 - n, n4 - n2));
                continue;
            }
            tessBox = tessBox2;
        }
    }

    public boolean remove(TessBox tessBox) {
        return this.list.remove(tessBox);
    }

    public TessBox remove(int n) {
        return this.list.remove(n);
    }

    public List<String[]> getTableDataList() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (TessBox tessBox : this.list) {
            String[] stringArray = new String[5];
            stringArray[0] = tessBox.getChrs();
            Rectangle rectangle = tessBox.getRect();
            stringArray[1] = String.valueOf(rectangle.x);
            stringArray[2] = String.valueOf(rectangle.y);
            stringArray[3] = String.valueOf(rectangle.width);
            stringArray[4] = String.valueOf(rectangle.height);
            arrayList.add(stringArray);
        }
        return arrayList;
    }
}

