/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.UUID;
import org.postgresql.Driver;
import org.postgresql.PGRefCursorResultSet;
import org.postgresql.PGResultSetMetaData;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.Encoding;
import org.postgresql.core.Field;
import org.postgresql.core.Oid;
import org.postgresql.core.Query;
import org.postgresql.core.ResultCursor;
import org.postgresql.core.ResultHandlerBase;
import org.postgresql.core.ServerVersion;
import org.postgresql.core.TypeInfo;
import org.postgresql.core.Utils;
import org.postgresql.jdbc.PgArray;
import org.postgresql.jdbc.PgBlob;
import org.postgresql.jdbc.PgClob;
import org.postgresql.jdbc.PgResultSetMetaData;
import org.postgresql.jdbc.PgSQLXML;
import org.postgresql.jdbc.PgStatement;
import org.postgresql.jdbc.TimestampUtils;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.ByteConverter;
import org.postgresql.util.GT;
import org.postgresql.util.HStoreConverter;
import org.postgresql.util.PGbytea;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PgResultSet
implements ResultSet,
PGRefCursorResultSet {
    private boolean updateable = false;
    private boolean doingUpdates = false;
    private HashMap<String, Object> updateValues = null;
    private boolean usingOID = false;
    private List<PrimaryKey> primaryKeys;
    private boolean singleTable = false;
    private String onlyTable = "";
    private String tableName = null;
    private PreparedStatement updateStatement = null;
    private PreparedStatement insertStatement = null;
    private PreparedStatement deleteStatement = null;
    private PreparedStatement selectStatement = null;
    private final int resultsettype;
    private final int resultsetconcurrency;
    private int fetchdirection = 1002;
    private TimeZone defaultTimeZone;
    protected final BaseConnection connection;
    protected final BaseStatement statement;
    protected final Field[] fields;
    protected final Query originalQuery;
    protected final int maxRows;
    protected final int maxFieldSize;
    protected List<byte[][]> rows;
    protected int current_row = -1;
    protected int row_offset;
    protected byte[][] this_row;
    protected SQLWarning warnings = null;
    protected boolean wasNullFlag = false;
    protected boolean onInsertRow = false;
    private byte[][] rowBuffer = null;
    protected int fetchSize;
    protected ResultCursor cursor;
    private Map<String, Integer> columnNameIndexMap;
    private ResultSetMetaData rsMetaData;
    private String refCursorName;
    private static final BigInteger BYTEMAX = new BigInteger(Byte.toString((byte)127));
    private static final BigInteger BYTEMIN = new BigInteger(Byte.toString((byte)-128));
    private static final BigInteger SHORTMAX = new BigInteger(Short.toString((short)Short.MAX_VALUE));
    private static final BigInteger SHORTMIN = new BigInteger(Short.toString((short)Short.MIN_VALUE));
    private static final NumberFormatException FAST_NUMBER_FAILED = new NumberFormatException(){

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    };
    private static final BigInteger INTMAX = new BigInteger(Integer.toString(Integer.MAX_VALUE));
    private static final BigInteger INTMIN = new BigInteger(Integer.toString(Integer.MIN_VALUE));
    private static final BigInteger LONGMAX = new BigInteger(Long.toString(Long.MAX_VALUE));
    private static final BigInteger LONGMIN = new BigInteger(Long.toString(Long.MIN_VALUE));

    protected ResultSetMetaData createMetaData() throws SQLException {
        return new PgResultSetMetaData(this.connection, this.fields);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.rsMetaData == null) {
            this.rsMetaData = this.createMetaData();
        }
        return this.rsMetaData;
    }

    PgResultSet(Query originalQuery, BaseStatement statement, Field[] fields, List<byte[][]> tuples, ResultCursor cursor, int maxRows, int maxFieldSize, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        if (tuples == null) {
            throw new NullPointerException("tuples must be non-null");
        }
        if (fields == null) {
            throw new NullPointerException("fields must be non-null");
        }
        this.originalQuery = originalQuery;
        this.connection = (BaseConnection)statement.getConnection();
        this.statement = statement;
        this.fields = fields;
        this.rows = tuples;
        this.cursor = cursor;
        this.maxRows = maxRows;
        this.maxFieldSize = maxFieldSize;
        this.resultsettype = rsType;
        this.resultsetconcurrency = rsConcurrency;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "getURL(int)");
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    protected Object internalGetObject(int columnIndex, Field field) throws SQLException {
        switch (this.getSQLType(columnIndex)) {
            case 16: {
                return this.getBoolean(columnIndex);
            }
            case 2009: {
                return this.getSQLXML(columnIndex);
            }
            case -7: {
                return this.getBoolean(columnIndex) ? Boolean.TRUE : Boolean.FALSE;
            }
            case -6: 
            case 4: 
            case 5: {
                return this.getInt(columnIndex);
            }
            case -5: {
                return this.getLong(columnIndex);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(columnIndex, field.getMod() == -1 ? -1 : field.getMod() - 4 & 0xFFFF);
            }
            case 7: {
                return Float.valueOf(this.getFloat(columnIndex));
            }
            case 6: 
            case 8: {
                return this.getDouble(columnIndex);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex, null);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 2003: {
                return this.getArray(columnIndex);
            }
            case 2005: {
                return this.getClob(columnIndex);
            }
            case 2004: {
                return this.getBlob(columnIndex);
            }
        }
        String type = this.getPGType(columnIndex);
        if (type.equals("unknown")) {
            return this.getString(columnIndex);
        }
        if (type.equals("uuid")) {
            if (this.isBinary(columnIndex)) {
                return this.getUUID(this.this_row[columnIndex - 1]);
            }
            return this.getUUID(this.getString(columnIndex));
        }
        if (type.equals("refcursor")) {
            String cursorName = this.getString(columnIndex);
            StringBuilder sb = new StringBuilder("FETCH ALL IN ");
            Utils.escapeIdentifier(sb, cursorName);
            ResultSet rs = this.connection.execSQLQuery(sb.toString(), this.resultsettype, 1007);
            sb.setLength(0);
            sb.append("CLOSE ");
            Utils.escapeIdentifier(sb, cursorName);
            this.connection.execSQLUpdate(sb.toString());
            ((PgResultSet)rs).setRefCursor(cursorName);
            return rs;
        }
        if ("hstore".equals(type)) {
            if (this.isBinary(columnIndex)) {
                return HStoreConverter.fromBytes(this.this_row[columnIndex - 1], this.connection.getEncoding());
            }
            return HStoreConverter.fromString(this.getString(columnIndex));
        }
        return null;
    }

    private void checkScrollable() throws SQLException {
        this.checkClosed();
        if (this.resultsettype == 1003) {
            throw new PSQLException(GT.tr("Operation requires a scrollable ResultSet, but this ResultSet is FORWARD_ONLY.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean absolute(int index) throws SQLException {
        int internalIndex;
        this.checkScrollable();
        if (index == 0) {
            this.beforeFirst();
            return false;
        }
        int rows_size = this.rows.size();
        if (index < 0) {
            if (index < -rows_size) {
                this.beforeFirst();
                return false;
            }
            internalIndex = rows_size + index;
        } else {
            if (index > rows_size) {
                this.afterLast();
                return false;
            }
            internalIndex = index - 1;
        }
        this.current_row = internalIndex;
        this.initRowBuffer();
        this.onInsertRow = false;
        return true;
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkScrollable();
        int rows_size = this.rows.size();
        if (rows_size > 0) {
            this.current_row = rows_size;
        }
        this.onInsertRow = false;
        this.this_row = null;
        this.rowBuffer = null;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkScrollable();
        if (!this.rows.isEmpty()) {
            this.current_row = -1;
        }
        this.onInsertRow = false;
        this.this_row = null;
        this.rowBuffer = null;
    }

    @Override
    public boolean first() throws SQLException {
        this.checkScrollable();
        if (this.rows.size() <= 0) {
            return false;
        }
        this.current_row = 0;
        this.initRowBuffer();
        this.onInsertRow = false;
        return true;
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    protected Array makeArray(int oid, byte[] value) throws SQLException {
        return new PgArray(this.connection, oid, value);
    }

    protected Array makeArray(int oid, String value) throws SQLException {
        return new PgArray(this.connection, oid, value);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        this.checkResultSet(i);
        if (this.wasNullFlag) {
            return null;
        }
        int oid = this.fields[i - 1].getOID();
        if (this.isBinary(i)) {
            return this.makeArray(oid, this.this_row[i - 1]);
        }
        return this.makeArray(oid, this.getFixedString(i));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getBigDecimal(columnIndex, -1);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        return this.getBlob(this.findColumn(columnName));
    }

    protected Blob makeBlob(long oid) throws SQLException {
        return new PgBlob(this.connection, oid);
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        this.checkResultSet(i);
        if (this.wasNullFlag) {
            return null;
        }
        return this.makeBlob(this.getLong(i));
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public Reader getCharacterStream(int i) throws SQLException {
        this.checkResultSet(i);
        if (this.wasNullFlag) {
            return null;
        }
        if (this.connection.haveMinimumCompatibleVersion(ServerVersion.v7_2)) {
            return new CharArrayReader(this.getString(i).toCharArray());
        }
        Encoding encoding = this.connection.getEncoding();
        InputStream input = this.getBinaryStream(i);
        try {
            return encoding.getDecodingReader(input);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Unexpected error while decoding character data from a large object.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    protected Clob makeClob(long oid) throws SQLException {
        return new PgClob(this.connection, oid);
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        this.checkResultSet(i);
        if (this.wasNullFlag) {
            return null;
        }
        return this.makeClob(this.getLong(i));
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return this.resultsetconcurrency;
    }

    @Override
    public Date getDate(int i, Calendar cal) throws SQLException {
        this.checkResultSet(i);
        if (this.wasNullFlag) {
            return null;
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        if (this.isBinary(i)) {
            int col = i - 1;
            int oid = this.fields[col].getOID();
            TimeZone tz = cal.getTimeZone();
            if (oid == 1082) {
                return this.connection.getTimestampUtils().toDateBin(tz, this.this_row[col]);
            }
            if (oid == 1114 || oid == 1184) {
                Timestamp timestamp = this.getTimestamp(i, cal);
                return this.connection.getTimestampUtils().convertToDate(timestamp.getTime(), tz);
            }
            throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", Oid.toString(oid), "date"), PSQLState.DATA_TYPE_MISMATCH);
        }
        return this.connection.getTimestampUtils().toDate(cal, this.getString(i));
    }

    @Override
    public Time getTime(int i, Calendar cal) throws SQLException {
        this.checkResultSet(i);
        if (this.wasNullFlag) {
            return null;
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        if (this.isBinary(i)) {
            int col = i - 1;
            int oid = this.fields[col].getOID();
            TimeZone tz = cal.getTimeZone();
            if (oid == 1083 || oid == 1266) {
                return this.connection.getTimestampUtils().toTimeBin(tz, this.this_row[col]);
            }
            if (oid == 1114 || oid == 1184) {
                Timestamp timestamp = this.getTimestamp(i, cal);
                return this.connection.getTimestampUtils().convertToTime(timestamp.getTime(), tz);
            }
            throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", Oid.toString(oid), "time"), PSQLState.DATA_TYPE_MISMATCH);
        }
        String string = this.getString(i);
        return this.connection.getTimestampUtils().toTime(cal, string);
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        this.checkResultSet(i);
        if (this.wasNullFlag) {
            return null;
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        int col = i - 1;
        int oid = this.fields[col].getOID();
        if (this.isBinary(i)) {
            long millis;
            if (oid == 1184 || oid == 1114) {
                boolean hasTimeZone = oid == 1184;
                TimeZone tz = cal.getTimeZone();
                return this.connection.getTimestampUtils().toTimestampBin(tz, this.this_row[col], hasTimeZone);
            }
            if (oid == 1083 || oid == 1266) {
                millis = this.getTime(i, cal).getTime();
            } else if (oid == 1082) {
                millis = this.getDate(i, cal).getTime();
            } else {
                throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", Oid.toString(oid), "timestamp"), PSQLState.DATA_TYPE_MISMATCH);
            }
            return new Timestamp(millis);
        }
        String string = this.getString(i);
        if (oid == 1083 || oid == 1266) {
            return new Timestamp(this.connection.getTimestampUtils().toTime(cal, string).getTime());
        }
        return this.connection.getTimestampUtils().toTimestamp(cal, string);
    }

    @Override
    public Date getDate(String c, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(c), cal);
    }

    @Override
    public Time getTime(String c, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(c), cal);
    }

    @Override
    public Timestamp getTimestamp(String c, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(c), cal);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchdirection;
    }

    public Object getObjectImpl(String columnName, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(this.findColumn(columnName), map);
    }

    public Object getObjectImpl(int i, Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        if (map == null || map.isEmpty()) {
            return this.getObject(i);
        }
        throw Driver.notImplemented(this.getClass(), "getObjectImpl(int,Map)");
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        return this.getRef(this.findColumn(columnName));
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "getRef(int)");
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            return 0;
        }
        int rows_size = this.rows.size();
        if (this.current_row < 0 || this.current_row >= rows_size) {
            return 0;
        }
        return this.row_offset + this.current_row + 1;
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return this.statement;
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return this.resultsettype;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            return false;
        }
        int rows_size = this.rows.size();
        if (this.row_offset + rows_size == 0) {
            return false;
        }
        return this.current_row >= rows_size;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            return false;
        }
        return this.row_offset + this.current_row < 0 && !this.rows.isEmpty();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            return false;
        }
        int rows_size = this.rows.size();
        if (this.row_offset + rows_size == 0) {
            return false;
        }
        return this.row_offset + this.current_row == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            return false;
        }
        int rows_size = this.rows.size();
        if (rows_size == 0) {
            return false;
        }
        if (this.current_row != rows_size - 1) {
            return false;
        }
        if (this.cursor == null) {
            return true;
        }
        if (this.maxRows > 0 && this.row_offset + this.current_row == this.maxRows) {
            return true;
        }
        this.row_offset += rows_size - 1;
        int fetchRows = this.fetchSize;
        if (this.maxRows != 0 && (fetchRows == 0 || this.row_offset + fetchRows > this.maxRows)) {
            fetchRows = this.maxRows - this.row_offset;
        }
        this.connection.getQueryExecutor().fetch(this.cursor, new CursorResultHandler(), fetchRows);
        this.rows.add(0, this.this_row);
        this.current_row = 0;
        return this.rows.size() == 1;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkScrollable();
        int rows_size = this.rows.size();
        if (rows_size <= 0) {
            return false;
        }
        this.current_row = rows_size - 1;
        this.initRowBuffer();
        this.onInsertRow = false;
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkScrollable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Can''t use relative move methods while on the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.current_row - 1 < 0) {
            this.current_row = -1;
            this.this_row = null;
            this.rowBuffer = null;
            return false;
        }
        --this.current_row;
        this.initRowBuffer();
        return true;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkScrollable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Can''t use relative move methods while on the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        return this.absolute(this.current_row + 1 + rows);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        switch (direction) {
            case 1000: {
                break;
            }
            case 1001: 
            case 1002: {
                this.checkScrollable();
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Invalid fetch direction constant: {0}.", direction), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
        this.fetchdirection = direction;
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Cannot call cancelRowUpdates() when on the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.doingUpdates) {
            this.doingUpdates = false;
            this.clearRowBuffer(true);
        }
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        this.checkUpdateable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Cannot call deleteRow() when on the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.isBeforeFirst()) {
            throw new PSQLException(GT.tr("Currently positioned before the start of the ResultSet.  You cannot call deleteRow() here.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.isAfterLast()) {
            throw new PSQLException(GT.tr("Currently positioned after the end of the ResultSet.  You cannot call deleteRow() here.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.rows.isEmpty()) {
            throw new PSQLException(GT.tr("There are no rows in this ResultSet.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        int numKeys = this.primaryKeys.size();
        if (this.deleteStatement == null) {
            StringBuilder deleteSQL = new StringBuilder("DELETE FROM ").append(this.onlyTable).append(this.tableName).append(" where ");
            for (int i = 0; i < numKeys; ++i) {
                Utils.escapeIdentifier(deleteSQL, this.primaryKeys.get((int)i).name);
                deleteSQL.append(" = ?");
                if (i >= numKeys - 1) continue;
                deleteSQL.append(" and ");
            }
            this.deleteStatement = this.connection.prepareStatement(deleteSQL.toString());
        }
        this.deleteStatement.clearParameters();
        for (int i = 0; i < numKeys; ++i) {
            this.deleteStatement.setObject(i + 1, this.primaryKeys.get(i).getValue());
        }
        this.deleteStatement.executeUpdate();
        this.rows.remove(this.current_row);
        --this.current_row;
        this.moveToCurrentRow();
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        this.checkUpdateable();
        if (!this.onInsertRow) {
            throw new PSQLException(GT.tr("Not on the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.updateValues.isEmpty()) {
            throw new PSQLException(GT.tr("You must specify at least one column value to insert a row.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        StringBuilder insertSQL = new StringBuilder("INSERT INTO ").append(this.tableName).append(" (");
        StringBuilder paramSQL = new StringBuilder(") values (");
        Iterator<String> columnNames = this.updateValues.keySet().iterator();
        int numColumns = this.updateValues.size();
        int i = 0;
        while (columnNames.hasNext()) {
            String columnName = columnNames.next();
            Utils.escapeIdentifier(insertSQL, columnName);
            if (i < numColumns - 1) {
                insertSQL.append(", ");
                paramSQL.append("?,");
            } else {
                paramSQL.append("?)");
            }
            ++i;
        }
        insertSQL.append(paramSQL.toString());
        this.insertStatement = this.connection.prepareStatement(insertSQL.toString());
        Iterator<Object> values = this.updateValues.values().iterator();
        int i2 = 1;
        while (values.hasNext()) {
            this.insertStatement.setObject(i2, values.next());
            ++i2;
        }
        this.insertStatement.executeUpdate();
        if (this.usingOID) {
            long insertedOID = ((PgStatement)((Object)this.insertStatement)).getLastOID();
            this.updateValues.put("oid", insertedOID);
        }
        this.updateRowBuffer();
        this.rows.add(this.rowBuffer);
        this.this_row = this.rowBuffer;
        this.clearRowBuffer(false);
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        this.checkUpdateable();
        if (this.current_row < 0 || this.current_row >= this.rows.size()) {
            this.this_row = null;
            this.rowBuffer = null;
        } else {
            this.initRowBuffer();
        }
        this.onInsertRow = false;
        this.doingUpdates = false;
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        this.checkUpdateable();
        if (this.insertStatement != null) {
            this.insertStatement = null;
        }
        this.clearRowBuffer(false);
        this.onInsertRow = true;
        this.doingUpdates = false;
    }

    private synchronized void clearRowBuffer(boolean copyCurrentRow) throws SQLException {
        this.rowBuffer = new byte[this.fields.length][];
        if (copyCurrentRow) {
            System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        }
        this.updateValues.clear();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public synchronized void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        try {
            int n;
            InputStreamReader reader = new InputStreamReader(x, "ASCII");
            char[] data = new char[length];
            int numRead = 0;
            while ((n = reader.read(data, numRead, length - numRead)) != -1 && (numRead += n) != length) {
            }
            this.updateString(columnIndex, new String(data, 0, numRead));
        }
        catch (UnsupportedEncodingException uee) {
            throw new PSQLException(GT.tr("The JVM claims not to support the encoding: {0}", "ASCII"), PSQLState.UNEXPECTED_ERROR, (Throwable)uee);
        }
        catch (IOException ie) {
            throw new PSQLException(GT.tr("Provided InputStream failed.", new Object[0]), null, (Throwable)ie);
        }
    }

    @Override
    public synchronized void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        byte[] data = new byte[length];
        int numRead = 0;
        try {
            int n;
            while ((n = x.read(data, numRead, length - numRead)) != -1 && (numRead += n) != length) {
            }
        }
        catch (IOException ie) {
            throw new PSQLException(GT.tr("Provided InputStream failed.", new Object[0]), null, (Throwable)ie);
        }
        if (numRead == length) {
            this.updateBytes(columnIndex, data);
        } else {
            byte[] data2 = new byte[numRead];
            System.arraycopy(data, 0, data2, 0, numRead);
            this.updateBytes(columnIndex, data2);
        }
    }

    @Override
    public synchronized void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateByte(int columnIndex, byte x) throws SQLException {
        this.updateValue(columnIndex, String.valueOf(x));
    }

    @Override
    public synchronized void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        try {
            int n;
            char[] data = new char[length];
            int numRead = 0;
            while ((n = x.read(data, numRead, length - numRead)) != -1 && (numRead += n) != length) {
            }
            this.updateString(columnIndex, new String(data, 0, numRead));
        }
        catch (IOException ie) {
            throw new PSQLException(GT.tr("Provided Reader failed.", new Object[0]), null, (Throwable)ie);
        }
    }

    @Override
    public synchronized void updateDate(int columnIndex, Date x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateDouble(int columnIndex, double x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateFloat(int columnIndex, float x) throws SQLException {
        this.updateValue(columnIndex, Float.valueOf(x));
    }

    @Override
    public synchronized void updateInt(int columnIndex, int x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateLong(int columnIndex, long x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateNull(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        String columnTypeName = this.getPGType(columnIndex);
        this.updateValue(columnIndex, new NullObject(columnTypeName));
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.updateObject(columnIndex, x);
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkUpdateable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Can''t refresh the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.isBeforeFirst() || this.isAfterLast() || this.rows.isEmpty()) {
            return;
        }
        StringBuilder selectSQL = new StringBuilder("select ");
        ResultSetMetaData rsmd = this.getMetaData();
        PGResultSetMetaData pgmd = (PGResultSetMetaData)((Object)rsmd);
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            if (i > 1) {
                selectSQL.append(", ");
            }
            selectSQL.append(pgmd.getBaseColumnName(i));
        }
        selectSQL.append(" from ").append(this.onlyTable).append(this.tableName).append(" where ");
        int numKeys = this.primaryKeys.size();
        for (int i = 0; i < numKeys; ++i) {
            PrimaryKey primaryKey = this.primaryKeys.get(i);
            selectSQL.append(primaryKey.name).append("= ?");
            if (i >= numKeys - 1) continue;
            selectSQL.append(" and ");
        }
        if (this.connection.getLogger().logDebug()) {
            this.connection.getLogger().debug("selecting " + selectSQL.toString());
        }
        this.selectStatement = this.connection.prepareStatement(selectSQL.toString(), 1004, 1008);
        int j = 0;
        int i = 1;
        while (j < numKeys) {
            this.selectStatement.setObject(i, this.primaryKeys.get(j).getValue());
            ++j;
            ++i;
        }
        PgResultSet rs = (PgResultSet)this.selectStatement.executeQuery();
        if (rs.next()) {
            this.rowBuffer = rs.this_row;
        }
        this.rows.set(this.current_row, this.rowBuffer);
        this.this_row = this.rowBuffer;
        this.connection.getLogger().debug("done updates");
        rs.close();
        this.selectStatement.close();
        this.selectStatement = null;
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        int i;
        this.checkUpdateable();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Cannot call updateRow() when on the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.isBeforeFirst() || this.isAfterLast() || this.rows.isEmpty()) {
            throw new PSQLException(GT.tr("Cannot update the ResultSet because it is either before the start or after the end of the results.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (!this.doingUpdates) {
            return;
        }
        StringBuilder updateSQL = new StringBuilder("UPDATE " + this.onlyTable + this.tableName + " SET  ");
        int numColumns = this.updateValues.size();
        Iterator<String> columns = this.updateValues.keySet().iterator();
        int i2 = 0;
        while (columns.hasNext()) {
            String column = columns.next();
            Utils.escapeIdentifier(updateSQL, column);
            updateSQL.append(" = ?");
            if (i2 < numColumns - 1) {
                updateSQL.append(", ");
            }
            ++i2;
        }
        updateSQL.append(" WHERE ");
        int numKeys = this.primaryKeys.size();
        for (i = 0; i < numKeys; ++i) {
            PrimaryKey primaryKey = this.primaryKeys.get(i);
            Utils.escapeIdentifier(updateSQL, primaryKey.name);
            updateSQL.append(" = ?");
            if (i >= numKeys - 1) continue;
            updateSQL.append(" and ");
        }
        if (this.connection.getLogger().logDebug()) {
            this.connection.getLogger().debug("updating " + updateSQL.toString());
        }
        this.updateStatement = this.connection.prepareStatement(updateSQL.toString());
        i = 0;
        for (Object o : this.updateValues.values()) {
            this.updateStatement.setObject(i + 1, o);
            ++i;
        }
        int j = 0;
        while (j < numKeys) {
            this.updateStatement.setObject(i + 1, this.primaryKeys.get(j).getValue());
            ++j;
            ++i;
        }
        this.updateStatement.executeUpdate();
        this.updateStatement.close();
        this.updateStatement = null;
        this.updateRowBuffer();
        this.connection.getLogger().debug("copying data");
        System.arraycopy(this.rowBuffer, 0, this.this_row, 0, this.rowBuffer.length);
        this.rows.set(this.current_row, this.rowBuffer);
        this.connection.getLogger().debug("done updates");
        this.updateValues.clear();
        this.doingUpdates = false;
    }

    @Override
    public synchronized void updateShort(int columnIndex, short x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateString(int columnIndex, String x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateTime(int columnIndex, Time x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public synchronized void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    @Override
    public synchronized void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    @Override
    public synchronized void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public synchronized void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    boolean isUpdateable() throws SQLException {
        this.checkClosed();
        if (this.resultsetconcurrency == 1007) {
            throw new PSQLException(GT.tr("ResultSets with concurrency CONCUR_READ_ONLY cannot be updated.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.updateable) {
            return true;
        }
        this.connection.getLogger().debug("checking if rs is updateable");
        this.parseQuery();
        if (!this.singleTable) {
            this.connection.getLogger().debug("not a single table");
            return false;
        }
        this.connection.getLogger().debug("getting primary keys");
        this.primaryKeys = new ArrayList<PrimaryKey>();
        this.usingOID = false;
        int oidIndex = this.findColumnIndex("oid");
        int i = 0;
        int numPKcolumns = 0;
        if (oidIndex > 0) {
            ++i;
            ++numPKcolumns;
            this.primaryKeys.add(new PrimaryKey(oidIndex, "oid"));
            this.usingOID = true;
        } else {
            String[] s = PgResultSet.quotelessTableName(this.tableName);
            String quotelessTableName = s[0];
            String quotelessSchemaName = s[1];
            ResultSet rs = this.connection.getMetaData().getPrimaryKeys("", quotelessSchemaName, quotelessTableName);
            while (rs.next()) {
                ++numPKcolumns;
                String columnName = rs.getString(4);
                int index = this.findColumnIndex(columnName);
                if (index <= 0) continue;
                ++i;
                this.primaryKeys.add(new PrimaryKey(index, columnName));
            }
            rs.close();
        }
        if (this.connection.getLogger().logDebug()) {
            this.connection.getLogger().debug("no of keys=" + i);
        }
        if (i < 1) {
            throw new PSQLException(GT.tr("No primary key found for table {0}.", this.tableName), PSQLState.DATA_ERROR);
        }
        boolean bl = this.updateable = i == numPKcolumns;
        if (this.connection.getLogger().logDebug()) {
            this.connection.getLogger().debug("checking primary key " + this.updateable);
        }
        return this.updateable;
    }

    public static String[] quotelessTableName(String fullname) {
        String[] parts = new String[]{null, ""};
        StringBuilder acc = new StringBuilder();
        boolean betweenQuotes = false;
        block4: for (int i = 0; i < fullname.length(); ++i) {
            char c = fullname.charAt(i);
            switch (c) {
                case '\"': {
                    if (i < fullname.length() - 1 && fullname.charAt(i + 1) == '\"') {
                        ++i;
                        acc.append(c);
                        continue block4;
                    }
                    betweenQuotes = !betweenQuotes;
                    continue block4;
                }
                case '.': {
                    if (betweenQuotes) {
                        acc.append(c);
                        continue block4;
                    }
                    parts[1] = acc.toString();
                    acc = new StringBuilder();
                    continue block4;
                }
                default: {
                    acc.append(betweenQuotes ? c : Character.toLowerCase(c));
                }
            }
        }
        parts[0] = acc.toString();
        return parts;
    }

    private void parseQuery() {
        String l_sql = this.originalQuery.toString(null);
        StringTokenizer st = new StringTokenizer(l_sql, " \r\t\n");
        boolean tableFound = false;
        boolean tablesChecked = false;
        String name = "";
        this.singleTable = true;
        while (!tableFound && !tablesChecked && st.hasMoreTokens()) {
            name = st.nextToken();
            if (!"from".equalsIgnoreCase(name)) continue;
            this.tableName = st.nextToken();
            if ("only".equalsIgnoreCase(this.tableName)) {
                this.tableName = st.nextToken();
                this.onlyTable = "ONLY ";
            }
            tableFound = true;
        }
    }

    private void updateRowBuffer() throws SQLException {
        block9: for (Map.Entry<String, Object> entry : this.updateValues.entrySet()) {
            int columnIndex = this.findColumn(entry.getKey()) - 1;
            Object valueObject = entry.getValue();
            if (valueObject instanceof PGobject) {
                String value = ((PGobject)valueObject).getValue();
                this.rowBuffer[columnIndex] = value == null ? null : this.connection.encodeString(value);
                continue;
            }
            switch (this.getSQLType(columnIndex + 1)) {
                case 91: {
                    this.rowBuffer[columnIndex] = this.connection.encodeString(this.connection.getTimestampUtils().toString(this.getDefaultCalendar(), (Date)valueObject));
                    continue block9;
                }
                case 92: {
                    this.rowBuffer[columnIndex] = this.connection.encodeString(this.connection.getTimestampUtils().toString(this.getDefaultCalendar(), (Time)valueObject));
                    continue block9;
                }
                case 93: {
                    this.rowBuffer[columnIndex] = this.connection.encodeString(this.connection.getTimestampUtils().toString(this.getDefaultCalendar(), (Timestamp)valueObject));
                    continue block9;
                }
                case 0: {
                    continue block9;
                }
                case -4: 
                case -3: 
                case -2: {
                    if (this.isBinary(columnIndex + 1)) {
                        this.rowBuffer[columnIndex] = (byte[])valueObject;
                        continue block9;
                    }
                    try {
                        this.rowBuffer[columnIndex] = PGbytea.toPGString((byte[])valueObject).getBytes("ISO-8859-1");
                        continue block9;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new PSQLException(GT.tr("The JVM claims not to support the encoding: {0}", "ISO-8859-1"), PSQLState.UNEXPECTED_ERROR, (Throwable)e);
                    }
                }
            }
            this.rowBuffer[columnIndex] = this.connection.encodeString(String.valueOf(valueObject));
        }
    }

    public BaseStatement getPGStatement() {
        return this.statement;
    }

    @Override
    public String getRefCursor() {
        return this.refCursorName;
    }

    private void setRefCursor(String refCursorName) {
        this.refCursorName = refCursorName;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw new PSQLException(GT.tr("Fetch size must be a value greater to or equal to 0.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.onInsertRow) {
            throw new PSQLException(GT.tr("Can''t use relative move methods while on the insert row.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.current_row + 1 >= this.rows.size()) {
            if (this.cursor == null || this.maxRows > 0 && this.row_offset + this.rows.size() >= this.maxRows) {
                this.current_row = this.rows.size();
                this.this_row = null;
                this.rowBuffer = null;
                return false;
            }
            this.row_offset += this.rows.size();
            int fetchRows = this.fetchSize;
            if (this.maxRows != 0 && (fetchRows == 0 || this.row_offset + fetchRows > this.maxRows)) {
                fetchRows = this.maxRows - this.row_offset;
            }
            this.connection.getQueryExecutor().fetch(this.cursor, new CursorResultHandler(), fetchRows);
            this.current_row = 0;
            if (this.rows.isEmpty()) {
                this.this_row = null;
                this.rowBuffer = null;
                return false;
            }
        } else {
            ++this.current_row;
        }
        this.initRowBuffer();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            this.rows = null;
            if (this.cursor != null) {
                this.cursor.close();
                this.cursor = null;
            }
        }
        finally {
            ((PgStatement)this.statement).checkCompletion();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.wasNullFlag;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        if (this.isBinary(columnIndex) && this.getSQLType(columnIndex) != 12) {
            Field field = this.fields[columnIndex - 1];
            Object obj = this.internalGetObject(columnIndex, field);
            if (obj == null) {
                return null;
            }
            if (obj instanceof java.util.Date) {
                int oid = field.getOID();
                return this.connection.getTimestampUtils().timeToString((java.util.Date)obj, oid == 1184 || oid == 1266);
            }
            if ("hstore".equals(this.getPGType(columnIndex))) {
                return HStoreConverter.toString((Map)obj);
            }
            return this.trimString(columnIndex, obj.toString());
        }
        Encoding encoding = this.connection.getEncoding();
        try {
            return this.trimString(columnIndex, encoding.decode(this.this_row[columnIndex - 1]));
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Invalid character data was found.  This is most likely caused by stored data containing characters that are invalid for the character set the database was created in.  The most common example of this is storing 8bit data in a SQL_ASCII database.", new Object[0]), PSQLState.DATA_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return false;
        }
        if (this.isBinary(columnIndex)) {
            int col = columnIndex - 1;
            return this.readDoubleValue(this.this_row[col], this.fields[col].getOID(), "boolean") == 1.0;
        }
        return PgResultSet.toBoolean(this.getString(columnIndex));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return 0;
        }
        if (this.isBinary(columnIndex)) {
            int col = columnIndex - 1;
            return (byte)this.readLongValue(this.this_row[col], this.fields[col].getOID(), -128L, 127L, "byte");
        }
        String s = this.getString(columnIndex);
        if (s != null) {
            if ((s = s.trim()).isEmpty()) {
                return 0;
            }
            try {
                return Byte.parseByte(s);
            }
            catch (NumberFormatException e) {
                try {
                    BigDecimal n = new BigDecimal(s);
                    BigInteger i = n.toBigInteger();
                    int gt = i.compareTo(BYTEMAX);
                    int lt = i.compareTo(BYTEMIN);
                    if (gt > 0 || lt < 0) {
                        throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "byte", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    }
                    return i.byteValue();
                }
                catch (NumberFormatException ex) {
                    throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "byte", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                }
            }
        }
        return 0;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return 0;
        }
        if (this.isBinary(columnIndex)) {
            int col = columnIndex - 1;
            int oid = this.fields[col].getOID();
            if (oid == 21) {
                return ByteConverter.int2(this.this_row[col], 0);
            }
            return (short)this.readLongValue(this.this_row[col], oid, -32768L, 32767L, "short");
        }
        String s = this.getFixedString(columnIndex);
        if (s != null) {
            s = s.trim();
            try {
                return Short.parseShort(s);
            }
            catch (NumberFormatException e) {
                try {
                    BigDecimal n = new BigDecimal(s);
                    BigInteger i = n.toBigInteger();
                    int gt = i.compareTo(SHORTMAX);
                    int lt = i.compareTo(SHORTMIN);
                    if (gt > 0 || lt < 0) {
                        throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "short", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    }
                    return i.shortValue();
                }
                catch (NumberFormatException ne) {
                    throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "short", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                }
            }
        }
        return 0;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return 0;
        }
        if (this.isBinary(columnIndex)) {
            int col = columnIndex - 1;
            int oid = this.fields[col].getOID();
            if (oid == 23) {
                return ByteConverter.int4(this.this_row[col], 0);
            }
            return (int)this.readLongValue(this.this_row[col], oid, Integer.MIN_VALUE, Integer.MAX_VALUE, "int");
        }
        Encoding encoding = this.connection.getEncoding();
        if (encoding.hasAsciiNumbers()) {
            try {
                return this.getFastInt(columnIndex);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return PgResultSet.toInt(this.getFixedString(columnIndex));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return 0L;
        }
        if (this.isBinary(columnIndex)) {
            int col = columnIndex - 1;
            int oid = this.fields[col].getOID();
            if (oid == 20) {
                return ByteConverter.int8(this.this_row[col], 0);
            }
            return this.readLongValue(this.this_row[col], oid, Long.MIN_VALUE, Long.MAX_VALUE, "long");
        }
        Encoding encoding = this.connection.getEncoding();
        if (encoding.hasAsciiNumbers()) {
            try {
                return this.getFastLong(columnIndex);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return PgResultSet.toLong(this.getFixedString(columnIndex));
    }

    private long getFastLong(int columnIndex) throws SQLException, NumberFormatException {
        int start;
        boolean neg;
        byte[] bytes = this.this_row[columnIndex - 1];
        if (bytes.length == 0) {
            throw FAST_NUMBER_FAILED;
        }
        long val = 0L;
        if (bytes[0] == 45) {
            neg = true;
            start = 1;
            if (bytes.length == 1 || bytes.length > 19) {
                throw FAST_NUMBER_FAILED;
            }
        } else {
            start = 0;
            neg = false;
            if (bytes.length > 18) {
                throw FAST_NUMBER_FAILED;
            }
        }
        while (start < bytes.length) {
            byte b;
            if ((b = bytes[start++]) < 48 || b > 57) {
                throw FAST_NUMBER_FAILED;
            }
            val *= 10L;
            val += (long)(b - 48);
        }
        if (neg) {
            val = -val;
        }
        return val;
    }

    private int getFastInt(int columnIndex) throws SQLException, NumberFormatException {
        int start;
        boolean neg;
        byte[] bytes = this.this_row[columnIndex - 1];
        if (bytes.length == 0) {
            throw FAST_NUMBER_FAILED;
        }
        int val = 0;
        if (bytes[0] == 45) {
            neg = true;
            start = 1;
            if (bytes.length == 1 || bytes.length > 10) {
                throw FAST_NUMBER_FAILED;
            }
        } else {
            start = 0;
            neg = false;
            if (bytes.length > 9) {
                throw FAST_NUMBER_FAILED;
            }
        }
        while (start < bytes.length) {
            byte b;
            if ((b = bytes[start++]) < 48 || b > 57) {
                throw FAST_NUMBER_FAILED;
            }
            val *= 10;
            val += b - 48;
        }
        if (neg) {
            val = -val;
        }
        return val;
    }

    private BigDecimal getFastBigDecimal(int columnIndex) throws SQLException, NumberFormatException {
        int numNonSignChars;
        int start;
        boolean neg;
        byte[] bytes = this.this_row[columnIndex - 1];
        if (bytes.length == 0) {
            throw FAST_NUMBER_FAILED;
        }
        int scale = 0;
        long val = 0L;
        if (bytes[0] == 45) {
            neg = true;
            start = 1;
            if (bytes.length == 1 || bytes.length > 19) {
                throw FAST_NUMBER_FAILED;
            }
        } else {
            start = 0;
            neg = false;
            if (bytes.length > 18) {
                throw FAST_NUMBER_FAILED;
            }
        }
        int periodsSeen = 0;
        while (start < bytes.length) {
            byte b;
            if ((b = bytes[start++]) < 48 || b > 57) {
                if (b == 46) {
                    scale = bytes.length - start;
                    ++periodsSeen;
                    continue;
                }
                throw FAST_NUMBER_FAILED;
            }
            val *= 10L;
            val += (long)(b - 48);
        }
        int n = numNonSignChars = neg ? bytes.length - 1 : bytes.length;
        if (periodsSeen > 1 || periodsSeen == numNonSignChars) {
            throw FAST_NUMBER_FAILED;
        }
        if (neg) {
            val = -val;
        }
        return BigDecimal.valueOf(val, scale);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return 0.0f;
        }
        if (this.isBinary(columnIndex)) {
            int col = columnIndex - 1;
            int oid = this.fields[col].getOID();
            if (oid == 700) {
                return ByteConverter.float4(this.this_row[col], 0);
            }
            return (float)this.readDoubleValue(this.this_row[col], oid, "float");
        }
        return PgResultSet.toFloat(this.getFixedString(columnIndex));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return 0.0;
        }
        if (this.isBinary(columnIndex)) {
            int col = columnIndex - 1;
            int oid = this.fields[col].getOID();
            if (oid == 701) {
                return ByteConverter.float8(this.this_row[col], 0);
            }
            return this.readDoubleValue(this.this_row[col], oid, "double");
        }
        return PgResultSet.toDouble(this.getFixedString(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        int sqlType;
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        if (this.isBinary(columnIndex) && (sqlType = this.getSQLType(columnIndex)) != 2 && sqlType != 3) {
            Object obj = this.internalGetObject(columnIndex, this.fields[columnIndex - 1]);
            if (obj == null) {
                return null;
            }
            if (obj instanceof Long || obj instanceof Integer || obj instanceof Byte) {
                BigDecimal res = BigDecimal.valueOf(((Number)obj).longValue());
                res = this.scaleBigDecimal(res, scale);
                return res;
            }
            return this.toBigDecimal(this.trimMoney(String.valueOf(obj)), scale);
        }
        Encoding encoding = this.connection.getEncoding();
        if (encoding.hasAsciiNumbers()) {
            try {
                BigDecimal res = this.getFastBigDecimal(columnIndex);
                res = this.scaleBigDecimal(res, scale);
                return res;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return this.toBigDecimal(this.getFixedString(columnIndex), scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        if (this.isBinary(columnIndex)) {
            return this.this_row[columnIndex - 1];
        }
        if (this.connection.haveMinimumCompatibleVersion(ServerVersion.v7_2)) {
            if (this.fields[columnIndex - 1].getOID() == 17) {
                return this.trimBytes(columnIndex, PGbytea.toBytes(this.this_row[columnIndex - 1]));
            }
            return this.trimBytes(columnIndex, this.this_row[columnIndex - 1]);
        }
        if (this.fields[columnIndex - 1].getOID() == 26) {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            LargeObject lob = lom.open(this.getLong(columnIndex));
            byte[] buf = lob.read(lob.size());
            lob.close();
            return this.trimBytes(columnIndex, buf);
        }
        return this.trimBytes(columnIndex, this.this_row[columnIndex - 1]);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, null);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, null);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        if (this.connection.haveMinimumCompatibleVersion(ServerVersion.v7_2)) {
            try {
                return new ByteArrayInputStream(this.getString(columnIndex).getBytes("ASCII"));
            }
            catch (UnsupportedEncodingException l_uee) {
                throw new PSQLException(GT.tr("The JVM claims not to support the encoding: {0}", "ASCII"), PSQLState.UNEXPECTED_ERROR, (Throwable)l_uee);
            }
        }
        return this.getBinaryStream(columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        if (this.connection.haveMinimumCompatibleVersion(ServerVersion.v7_2)) {
            try {
                return new ByteArrayInputStream(this.getString(columnIndex).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException l_uee) {
                throw new PSQLException(GT.tr("The JVM claims not to support the encoding: {0}", "UTF-8"), PSQLState.UNEXPECTED_ERROR, (Throwable)l_uee);
            }
        }
        return this.getBinaryStream(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        if (this.connection.haveMinimumCompatibleVersion(ServerVersion.v7_2)) {
            byte[] b = this.getBytes(columnIndex);
            if (b != null) {
                return new ByteArrayInputStream(b);
            }
        } else if (this.fields[columnIndex - 1].getOID() == 26) {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            LargeObject lob = lom.open(this.getLong(columnIndex));
            return lob.getInputStream();
        }
        return null;
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName), null);
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName), null);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), null);
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warnings = null;
    }

    protected void addWarning(SQLWarning warnings) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(warnings);
        } else {
            this.warnings = warnings;
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        Field field = this.fields[columnIndex - 1];
        if (field == null) {
            this.wasNullFlag = true;
            return null;
        }
        Object result = this.internalGetObject(columnIndex, field);
        if (result != null) {
            return result;
        }
        if (this.isBinary(columnIndex)) {
            return this.connection.getObject(this.getPGType(columnIndex), null, this.this_row[columnIndex - 1]);
        }
        return this.connection.getObject(this.getPGType(columnIndex), this.getString(columnIndex), null);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        this.checkClosed();
        int col = this.findColumnIndex(columnName);
        if (col == 0) {
            throw new PSQLException(GT.tr("The column name {0} was not found in this ResultSet.", columnName), PSQLState.UNDEFINED_COLUMN);
        }
        return col;
    }

    public static Map<String, Integer> createColumnNameIndexMap(Field[] fields, boolean isSanitiserDisabled) {
        HashMap<String, Integer> columnNameIndexMap = new HashMap<String, Integer>(fields.length * 2);
        for (int i = fields.length - 1; i >= 0; --i) {
            String columnLabel = fields[i].getColumnLabel();
            if (isSanitiserDisabled) {
                columnNameIndexMap.put(columnLabel, i + 1);
                continue;
            }
            columnNameIndexMap.put(columnLabel.toLowerCase(Locale.US), i + 1);
        }
        return columnNameIndexMap;
    }

    private int findColumnIndex(String columnName) {
        Integer index;
        if (this.columnNameIndexMap == null) {
            if (this.originalQuery != null) {
                this.columnNameIndexMap = this.originalQuery.getResultSetColumnNameIndexMap();
            }
            if (this.columnNameIndexMap == null) {
                this.columnNameIndexMap = PgResultSet.createColumnNameIndexMap(this.fields, this.connection.isColumnSanitiserDisabled());
            }
        }
        if ((index = this.columnNameIndexMap.get(columnName)) != null) {
            return index;
        }
        index = this.columnNameIndexMap.get(columnName.toLowerCase(Locale.US));
        if (index != null) {
            this.columnNameIndexMap.put(columnName, index);
            return index;
        }
        index = this.columnNameIndexMap.get(columnName.toUpperCase(Locale.US));
        if (index != null) {
            this.columnNameIndexMap.put(columnName, index);
            return index;
        }
        return 0;
    }

    public int getColumnOID(int field) {
        return this.fields[field - 1].getOID();
    }

    public String getFixedString(int col) throws SQLException {
        return this.trimMoney(this.getString(col));
    }

    private String trimMoney(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() < 2) {
            return s;
        }
        char ch = s.charAt(0);
        if (ch > '-') {
            return s;
        }
        if (ch == '(') {
            s = "-" + PGtokenizer.removePara(s).substring(1);
        } else if (ch == '$') {
            s = s.substring(1);
        } else if (ch == '-' && s.charAt(1) == '$') {
            s = "-" + s.substring(2);
        }
        return s;
    }

    protected String getPGType(int column) throws SQLException {
        Field field = this.fields[column - 1];
        this.initSqlType(field);
        return field.getPGType();
    }

    protected int getSQLType(int column) throws SQLException {
        Field field = this.fields[column - 1];
        this.initSqlType(field);
        return field.getSQLType();
    }

    private void initSqlType(Field field) throws SQLException {
        if (field.isTypeInitialized()) {
            return;
        }
        TypeInfo typeInfo = this.connection.getTypeInfo();
        int oid = field.getOID();
        String pgType = typeInfo.getPGType(oid);
        int sqlType = typeInfo.getSQLType(pgType);
        field.setSQLType(sqlType);
        field.setPGType(pgType);
    }

    private void checkUpdateable() throws SQLException {
        this.checkClosed();
        if (!this.isUpdateable()) {
            throw new PSQLException(GT.tr("ResultSet is not updateable.  The query that generated this result set must select only one table, and must select all primary keys from that table. See the JDBC 2.1 API Specification, section 5.6 for more details.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        if (this.updateValues == null) {
            this.updateValues = new HashMap((int)((double)this.fields.length / 0.75), 0.75f);
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.rows == null) {
            throw new PSQLException(GT.tr("This ResultSet is closed.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    protected boolean isResultSetClosed() {
        return this.rows == null;
    }

    protected void checkColumnIndex(int column) throws SQLException {
        if (column < 1 || column > this.fields.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", column, this.fields.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    protected void checkResultSet(int column) throws SQLException {
        this.checkClosed();
        if (this.this_row == null) {
            throw new PSQLException(GT.tr("ResultSet not positioned properly, perhaps you need to call next.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        this.checkColumnIndex(column);
        this.wasNullFlag = this.this_row[column - 1] == null;
    }

    protected boolean isBinary(int column) {
        return this.fields[column - 1].getFormat() == 1;
    }

    public static boolean toBoolean(String s) {
        if (s != null) {
            if ((s = s.trim()).equalsIgnoreCase("t") || s.equalsIgnoreCase("true") || s.equals("1")) {
                return true;
            }
            if (s.equalsIgnoreCase("f") || s.equalsIgnoreCase("false") || s.equals("0")) {
                return false;
            }
            try {
                if (Double.parseDouble(s) == 1.0) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static int toInt(String s) throws SQLException {
        if (s != null) {
            try {
                s = s.trim();
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                try {
                    BigDecimal n = new BigDecimal(s);
                    BigInteger i = n.toBigInteger();
                    int gt = i.compareTo(INTMAX);
                    int lt = i.compareTo(INTMIN);
                    if (gt > 0 || lt < 0) {
                        throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "int", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    }
                    return i.intValue();
                }
                catch (NumberFormatException ne) {
                    throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "int", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                }
            }
        }
        return 0;
    }

    public static long toLong(String s) throws SQLException {
        if (s != null) {
            try {
                s = s.trim();
                return Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                try {
                    BigDecimal n = new BigDecimal(s);
                    BigInteger i = n.toBigInteger();
                    int gt = i.compareTo(LONGMAX);
                    int lt = i.compareTo(LONGMIN);
                    if (gt > 0 || lt < 0) {
                        throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "long", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                    }
                    return i.longValue();
                }
                catch (NumberFormatException ne) {
                    throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "long", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
                }
            }
        }
        return 0L;
    }

    public static BigDecimal toBigDecimal(String s) throws SQLException {
        if (s == null) {
            return null;
        }
        try {
            s = s.trim();
            return new BigDecimal(s);
        }
        catch (NumberFormatException e) {
            throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "BigDecimal", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
    }

    public BigDecimal toBigDecimal(String s, int scale) throws SQLException {
        if (s == null) {
            return null;
        }
        BigDecimal val = PgResultSet.toBigDecimal(s);
        return this.scaleBigDecimal(val, scale);
    }

    private BigDecimal scaleBigDecimal(BigDecimal val, int scale) throws PSQLException {
        if (scale == -1) {
            return val;
        }
        try {
            return val.setScale(scale);
        }
        catch (ArithmeticException e) {
            throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "BigDecimal", val), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
    }

    public static float toFloat(String s) throws SQLException {
        if (s != null) {
            try {
                s = s.trim();
                return Float.parseFloat(s);
            }
            catch (NumberFormatException e) {
                throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "float", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
            }
        }
        return 0.0f;
    }

    public static double toDouble(String s) throws SQLException {
        if (s != null) {
            try {
                s = s.trim();
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                throw new PSQLException(GT.tr("Bad value for type {0} : {1}", "double", s), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
            }
        }
        return 0.0;
    }

    private void initRowBuffer() {
        this.this_row = this.rows.get(this.current_row);
        if (this.resultsetconcurrency == 1008) {
            this.rowBuffer = new byte[this.this_row.length][];
            System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        } else {
            this.rowBuffer = null;
        }
    }

    private boolean isColumnTrimmable(int columnIndex) throws SQLException {
        switch (this.getSQLType(columnIndex)) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private byte[] trimBytes(int p_columnIndex, byte[] p_bytes) throws SQLException {
        if (this.maxFieldSize > 0 && p_bytes.length > this.maxFieldSize && this.isColumnTrimmable(p_columnIndex)) {
            byte[] l_bytes = new byte[this.maxFieldSize];
            System.arraycopy(p_bytes, 0, l_bytes, 0, this.maxFieldSize);
            return l_bytes;
        }
        return p_bytes;
    }

    private String trimString(int p_columnIndex, String p_string) throws SQLException {
        if (this.maxFieldSize > 0 && p_string.length() > this.maxFieldSize && this.isColumnTrimmable(p_columnIndex)) {
            return p_string.substring(0, this.maxFieldSize);
        }
        return p_string;
    }

    private double readDoubleValue(byte[] bytes, int oid, String targetType) throws PSQLException {
        switch (oid) {
            case 21: {
                return ByteConverter.int2(bytes, 0);
            }
            case 23: {
                return ByteConverter.int4(bytes, 0);
            }
            case 20: {
                return ByteConverter.int8(bytes, 0);
            }
            case 700: {
                return ByteConverter.float4(bytes, 0);
            }
            case 701: {
                return ByteConverter.float8(bytes, 0);
            }
        }
        throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", Oid.toString(oid), targetType), PSQLState.DATA_TYPE_MISMATCH);
    }

    private long readLongValue(byte[] bytes, int oid, long minVal, long maxVal, String targetType) throws PSQLException {
        long val;
        switch (oid) {
            case 21: {
                val = ByteConverter.int2(bytes, 0);
                break;
            }
            case 23: {
                val = ByteConverter.int4(bytes, 0);
                break;
            }
            case 20: {
                val = ByteConverter.int8(bytes, 0);
                break;
            }
            case 700: {
                val = (long)ByteConverter.float4(bytes, 0);
                break;
            }
            case 701: {
                val = (long)ByteConverter.float8(bytes, 0);
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Cannot convert the column of type {0} to requested type {1}.", Oid.toString(oid), targetType), PSQLState.DATA_TYPE_MISMATCH);
            }
        }
        if (val < minVal || val > maxVal) {
            throw new PSQLException(GT.tr("Bad value for type {0} : {1}", targetType, val), PSQLState.NUMERIC_VALUE_OUT_OF_RANGE);
        }
        return val;
    }

    protected void updateValue(int columnIndex, Object value) throws SQLException {
        this.checkUpdateable();
        if (!this.onInsertRow && (this.isBeforeFirst() || this.isAfterLast() || this.rows.isEmpty())) {
            throw new PSQLException(GT.tr("Cannot update the ResultSet because it is either before the start or after the end of the results.", new Object[0]), PSQLState.INVALID_CURSOR_STATE);
        }
        this.checkColumnIndex(columnIndex);
        boolean bl = this.doingUpdates = !this.onInsertRow;
        if (value == null) {
            this.updateNull(columnIndex);
        } else {
            PGResultSetMetaData md = (PGResultSetMetaData)((Object)this.getMetaData());
            this.updateValues.put(md.getBaseColumnName(columnIndex), value);
        }
    }

    protected Object getUUID(String data) throws SQLException {
        UUID uuid;
        try {
            uuid = UUID.fromString(data);
        }
        catch (IllegalArgumentException iae) {
            throw new PSQLException(GT.tr("Invalid UUID data.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)iae);
        }
        return uuid;
    }

    protected Object getUUID(byte[] data) throws SQLException {
        return new UUID(ByteConverter.int8(data, 0), ByteConverter.int8(data, 8));
    }

    void addRows(List<byte[][]> tuples) {
        this.rows.addAll(tuples);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateRef(int,Ref)");
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateRef(String,Ref)");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBlob(int,Blob)");
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBlob(String,Blob)");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateClob(int,Clob)");
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateClob(String,Clob)");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        this.updateArray(this.findColumn(columnName), x);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        if (type == null) {
            throw new SQLException("type is null");
        }
        int sqlType = this.getSQLType(columnIndex);
        if (type == BigDecimal.class) {
            if (sqlType == 2 || sqlType == 3) {
                return type.cast(this.getBigDecimal(columnIndex));
            }
            throw new SQLException("conversion to " + type + " from " + sqlType + " not supported");
        }
        if (type == String.class) {
            if (sqlType == 1 || sqlType == 12) {
                return type.cast(this.getString(columnIndex));
            }
            throw new SQLException("conversion to " + type + " from " + sqlType + " not supported");
        }
        if (type == Boolean.class) {
            if (sqlType == 16 || sqlType == -7) {
                boolean booleanValue = this.getBoolean(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return type.cast(booleanValue);
            }
            throw new SQLException("conversion to " + type + " from " + sqlType + " not supported");
        }
        if (type == Integer.class) {
            if (sqlType == 5 || sqlType == 4) {
                int intValue = this.getInt(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return type.cast(intValue);
            }
            throw new SQLException("conversion to " + type + " from " + sqlType + " not supported");
        }
        if (type == Long.class) {
            if (sqlType == -5) {
                long longValue = this.getLong(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return type.cast(longValue);
            }
            throw new SQLException("conversion to " + type + " from " + sqlType + " not supported");
        }
        if (type == Float.class) {
            if (sqlType == 7) {
                float floatValue = this.getFloat(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return type.cast(Float.valueOf(floatValue));
            }
            throw new SQLException("conversion to " + type + " from " + sqlType + " not supported");
        }
        if (type == Double.class) {
            if (sqlType == 6 || sqlType == 8) {
                double doubleValue = this.getDouble(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return type.cast(doubleValue);
            }
            throw new SQLException("conversion to " + type + " from " + sqlType + " not supported");
        }
        if (type == Date.class) {
            if (sqlType == 91) {
                return type.cast(this.getDate(columnIndex));
            }
            throw new SQLException("conversion to " + type + " from " + sqlType + " not supported");
        }
        if (type == Time.class) {
            if (sqlType == 92) {
                return type.cast(this.getTime(columnIndex));
            }
            throw new SQLException("conversion to " + type + " from " + sqlType + " not supported");
        }
        if (type == Timestamp.class) {
            if (sqlType == 93) {
                return type.cast(this.getTimestamp(columnIndex));
            }
            throw new SQLException("conversion to " + type + " from " + sqlType + " not supported");
        }
        if (type == Calendar.class) {
            if (sqlType == 93) {
                Timestamp timestampValue = this.getTimestamp(columnIndex);
                Calendar calendar = Calendar.getInstance(this.getDefaultCalendar().getTimeZone());
                calendar.setTimeInMillis(timestampValue.getTime());
                return type.cast(calendar);
            }
            throw new SQLException("conversion to " + type + " from " + sqlType + " not supported");
        }
        if (type == Blob.class) {
            if (sqlType == 2004 || sqlType == -2 || sqlType == -5) {
                return type.cast(this.getBlob(columnIndex));
            }
            throw new SQLException("conversion to " + type + " from " + sqlType + " not supported");
        }
        if (type == Clob.class) {
            if (sqlType == 2005 || sqlType == -5) {
                return type.cast(this.getClob(columnIndex));
            }
            throw new SQLException("conversion to " + type + " from " + sqlType + " not supported");
        }
        if (type == NClob.class) {
            if (sqlType == 2011) {
                return type.cast(this.getNClob(columnIndex));
            }
            throw new SQLException("conversion to " + type + " from " + sqlType + " not supported");
        }
        if (type == Array.class) {
            if (sqlType == 2003) {
                return type.cast(this.getArray(columnIndex));
            }
            throw new SQLException("conversion to " + type + " from " + sqlType + " not supported");
        }
        if (type == SQLXML.class) {
            if (sqlType == 2009) {
                return type.cast(this.getSQLXML(columnIndex));
            }
            throw new SQLException("conversion to " + type + " from " + sqlType + " not supported");
        }
        if (type == UUID.class) {
            return type.cast(this.getObject(columnIndex));
        }
        if (type == InetAddress.class) {
            Object addressString = this.getObject(columnIndex);
            if (addressString == null) {
                return null;
            }
            try {
                return type.cast(InetAddress.getByName(((PGobject)addressString).getValue()));
            }
            catch (UnknownHostException e) {
                throw new SQLException("could not create inet address from string '" + addressString + "'");
            }
        }
        if (PGobject.class.isAssignableFrom(type)) {
            Object object = this.isBinary(columnIndex) ? this.connection.getObject(this.getPGType(columnIndex), null, this.this_row[columnIndex - 1]) : this.connection.getObject(this.getPGType(columnIndex), this.getString(columnIndex), null);
            return type.cast(object);
        }
        throw new SQLException("unsupported conversion to " + type);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    @Override
    public Object getObject(String s, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(s, map);
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(i, map);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRowId(int)");
    }

    @Override
    public RowId getRowId(String columnName) throws SQLException {
        return this.getRowId(this.findColumn(columnName));
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateRowId(int, RowId)");
    }

    @Override
    public void updateRowId(String columnName, RowId x) throws SQLException {
        this.updateRowId(this.findColumn(columnName), x);
    }

    @Override
    public int getHoldability() throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getHoldability()");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.rows == null;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNString(int, String)");
    }

    @Override
    public void updateNString(String columnName, String nString) throws SQLException {
        this.updateNString(this.findColumn(columnName), nString);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNClob(int, NClob)");
    }

    @Override
    public void updateNClob(String columnName, NClob nClob) throws SQLException {
        this.updateNClob(this.findColumn(columnName), nClob);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNClob(int, Reader)");
    }

    @Override
    public void updateNClob(String columnName, Reader reader) throws SQLException {
        this.updateNClob(this.findColumn(columnName), reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNClob(int, Reader, long)");
    }

    @Override
    public void updateNClob(String columnName, Reader reader, long length) throws SQLException {
        this.updateNClob(this.findColumn(columnName), reader, length);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNClob(int)");
    }

    @Override
    public NClob getNClob(String columnName) throws SQLException {
        return this.getNClob(this.findColumn(columnName));
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBlob(int, InputStream, long)");
    }

    @Override
    public void updateBlob(String columnName, InputStream inputStream, long length) throws SQLException {
        this.updateBlob(this.findColumn(columnName), inputStream, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBlob(int, InputStream)");
    }

    @Override
    public void updateBlob(String columnName, InputStream inputStream) throws SQLException {
        this.updateBlob(this.findColumn(columnName), inputStream);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateClob(int, Reader, long)");
    }

    @Override
    public void updateClob(String columnName, Reader reader, long length) throws SQLException {
        this.updateClob(this.findColumn(columnName), reader, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateClob(int, Reader)");
    }

    @Override
    public void updateClob(String columnName, Reader reader) throws SQLException {
        this.updateClob(this.findColumn(columnName), reader);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        String data = this.getString(columnIndex);
        if (data == null) {
            return null;
        }
        return new PgSQLXML(this.connection, data);
    }

    @Override
    public SQLXML getSQLXML(String columnName) throws SQLException {
        return this.getSQLXML(this.findColumn(columnName));
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.updateValue(columnIndex, xmlObject);
    }

    @Override
    public void updateSQLXML(String columnName, SQLXML xmlObject) throws SQLException {
        this.updateSQLXML(this.findColumn(columnName), xmlObject);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNString(int)");
    }

    @Override
    public String getNString(String columnName) throws SQLException {
        return this.getNString(this.findColumn(columnName));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNCharacterStream(int)");
    }

    @Override
    public Reader getNCharacterStream(String columnName) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnName));
    }

    public void updateNCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNCharacterStream(int, Reader, int)");
    }

    public void updateNCharacterStream(String columnName, Reader x, int length) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNCharacterStream(int, Reader)");
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader x) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnName), x);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateNCharacterStream(int, Reader, long)");
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader x, long length) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateCharaceterStream(int, Reader, long)");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateCharaceterStream(int, Reader)");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBinaryStream(int, InputStream, long)");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream inputStream, long length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), inputStream, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateBinaryStream(int, InputStream)");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), inputStream);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateAsciiStream(int, InputStream, long)");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream inputStream, long length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), inputStream, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "updateAsciiStream(int, InputStream)");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), inputStream);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    private Calendar getDefaultCalendar() {
        TimestampUtils timestampUtils = this.connection.getTimestampUtils();
        if (timestampUtils.hasFastDefaultTimeZone()) {
            return timestampUtils.getSharedCalendar(null);
        }
        Calendar sharedCalendar = timestampUtils.getSharedCalendar(this.defaultTimeZone);
        if (this.defaultTimeZone == null) {
            this.defaultTimeZone = sharedCalendar.getTimeZone();
        }
        return sharedCalendar;
    }

    static class NullObject
    extends PGobject {
        NullObject(String type) {
            this.setType(type);
        }

        @Override
        public String getValue() {
            return null;
        }
    }

    private class PrimaryKey {
        int index;
        String name;

        PrimaryKey(int index, String name) {
            this.index = index;
            this.name = name;
        }

        Object getValue() throws SQLException {
            return PgResultSet.this.getObject(this.index);
        }
    }

    public class CursorResultHandler
    extends ResultHandlerBase {
        @Override
        public void handleResultRows(Query fromQuery, Field[] fields, List<byte[][]> tuples, ResultCursor cursor) {
            PgResultSet.this.rows = tuples;
            PgResultSet.this.cursor = cursor;
        }

        @Override
        public void handleCommandStatus(String status, int updateCount, long insertOID) {
            this.handleError(new PSQLException(GT.tr("Unexpected command status: {0}.", status), PSQLState.PROTOCOL_VIOLATION));
        }

        @Override
        public void handleCompletion() throws SQLException {
            SQLWarning warning = this.getWarning();
            if (warning != null) {
                PgResultSet.this.addWarning(warning);
            }
            super.handleCompletion();
        }
    }
}

