/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.Revision;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.util.Dot;
import net.sourceforge.schemaspy.util.HtmlEncoder;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.view.HtmlColumnsPage;
import net.sourceforge.schemaspy.view.StyleSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlFormatter {
    protected final boolean encodeComments = Config.getInstance().isEncodeCommentsEnabled();
    protected final boolean displayNumRows = Config.getInstance().isNumRowsEnabled();
    private final boolean isMetered = Config.getInstance().isMeterEnabled();

    protected HtmlFormatter() {
    }

    protected void writeHeader(Database database, Table table, String string, boolean bl, List<String> list, LineWriter lineWriter) throws IOException {
        Object object;
        lineWriter.writeln("<!DOCTYPE HTML PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN' 'http://www.w3.org/TR/html4/loose.dtd'>");
        lineWriter.writeln("<html>");
        lineWriter.writeln("<head>");
        lineWriter.writeln("  <!-- SchemaSpy rev " + new Revision() + " -->");
        lineWriter.write("  <title>SchemaSpy - ");
        lineWriter.write(this.getDescription(database, table, string, false));
        lineWriter.writeln("</title>");
        lineWriter.write("  <link rel=stylesheet href='");
        if (table != null) {
            lineWriter.write("../");
        }
        lineWriter.writeln("schemaSpy.css' type='text/css'>");
        lineWriter.writeln("  <meta HTTP-EQUIV='Content-Type' CONTENT='text/html; charset=" + Config.getInstance().getCharset() + "'>");
        lineWriter.writeln("  <SCRIPT LANGUAGE='JavaScript' TYPE='text/javascript' SRC='" + (table == null ? "" : "../") + "jquery.js'></SCRIPT>");
        lineWriter.writeln("  <SCRIPT LANGUAGE='JavaScript' TYPE='text/javascript' SRC='" + (table == null ? "" : "../") + "schemaSpy.js'></SCRIPT>");
        if (table != null) {
            lineWriter.writeln("  <SCRIPT LANGUAGE='JavaScript' TYPE='text/javascript'>");
            lineWriter.writeln("    table='" + table + "';");
            lineWriter.writeln("  </SCRIPT>");
        }
        if (list != null) {
            lineWriter.writeln("  <SCRIPT LANGUAGE='JavaScript' TYPE='text/javascript'>");
            object = list.iterator();
            while (object.hasNext()) {
                String string2 = object.next();
                lineWriter.writeln("    " + string2);
            }
            lineWriter.writeln("  </SCRIPT>");
        }
        lineWriter.writeln("</head>");
        lineWriter.writeln("<body>");
        this.writeTableOfContents(bl, lineWriter);
        lineWriter.writeln("<div class='content' style='clear:both;'>");
        lineWriter.writeln("<table width='100%' border='0' cellpadding='0'>");
        lineWriter.writeln(" <tr>");
        lineWriter.write("  <td class='heading' valign='middle'>");
        lineWriter.write("<span class='header'>");
        if (table == null) {
            lineWriter.write("SchemaSpy Analysis of ");
        }
        lineWriter.write(this.getDescription(database, table, string, true));
        lineWriter.write("</span>");
        if (table == null && database.getDescription() != null) {
            lineWriter.write("<span class='description'>" + database.getDescription().replace("\\=", "=") + "</span>");
        }
        Object object2 = object = table == null ? null : table.getComments();
        if (object != null) {
            lineWriter.write("<div style='padding: 0px 4px;'>");
            if (this.encodeComments) {
                for (int i = 0; i < ((String)object).length(); ++i) {
                    lineWriter.write(HtmlEncoder.encodeToken(((String)object).charAt(i)));
                }
            } else {
                lineWriter.write((String)object);
            }
            lineWriter.writeln("</div><p>");
        }
        lineWriter.writeln("</td>");
        lineWriter.writeln("  <td class='heading' align='right' valign='top' title='John Currier - Creator of Cool Tools'><span class='indent'>Generated by</span><br><span class='indent'><span class='signature'><a href='http://schemaspy.sourceforge.net' target='_blank'>SchemaSpy</a></span></span></td>");
        lineWriter.writeln(" </tr>");
        lineWriter.writeln("</table>");
    }

    protected void writeHeader(Database database, Table table, String string, boolean bl, LineWriter lineWriter) throws IOException {
        this.writeHeader(database, table, string, bl, null, lineWriter);
    }

    protected void writeGeneratedBy(String string, LineWriter lineWriter) throws IOException {
        lineWriter.write("<span class='container'>");
        lineWriter.write("Generated by <span class='signature'><a href='http://schemaspy.sourceforge.net' target='_blank'>SchemaSpy</a></span> on ");
        lineWriter.write(string);
        lineWriter.writeln("</span>");
    }

    protected void writeTableOfContents(boolean bl, LineWriter lineWriter) throws IOException {
        String string = this.getPathToRoot();
        lineWriter.writeln("<table id='headerHolder' cellspacing='0' cellpadding='0'><tr><td>");
        lineWriter.writeln("<div id='header'>");
        lineWriter.writeln(" <ul>");
        if (Config.getInstance().isOneOfMultipleSchemas()) {
            lineWriter.writeln("  <li><a href='" + string + "../index.html' title='All Schemas Evaluated'>Schemas</a></li>");
        }
        lineWriter.writeln("  <li" + (this.isMainIndex() ? " id='current'" : "") + "><a href='" + string + "index.html' title='All tables and views in the schema'>Tables</a></li>");
        lineWriter.writeln("  <li" + (this.isRelationshipsPage() ? " id='current'" : "") + "><a href='" + string + "relationships.html' title='Diagram of table relationships'>Relationships</a></li>");
        if (bl) {
            lineWriter.writeln("  <li" + (this.isOrphansPage() ? " id='current'" : "") + "><a href='" + string + "utilities.html' title='View of tables with neither parents nor children'>Utility&nbsp;Tables</a></li>");
        }
        lineWriter.writeln("  <li" + (this.isConstraintsPage() ? " id='current'" : "") + "><a href='" + string + "constraints.html' title='Useful for diagnosing error messages that just give constraint name or number'>Constraints</a></li>");
        lineWriter.writeln("  <li" + (this.isAnomaliesPage() ? " id='current'" : "") + "><a href='" + string + "anomalies.html' title=\"Things that might not be quite right\">Anomalies</a></li>");
        lineWriter.writeln("  <li" + (this.isColumnsPage() ? " id='current'" : "") + "><a href='" + string + HtmlColumnsPage.getInstance().getColumnInfos().get(0) + "' title=\"All of the columns in the schema\">Columns</a></li>");
        lineWriter.writeln("  <li><a href='http://sourceforge.net/donate/index.php?group_id=137197' title='Please help keep SchemaSpy alive' target='_blank'>Donate</a></li>");
        lineWriter.writeln(" </ul>");
        lineWriter.writeln("</div>");
        lineWriter.writeln("</td></tr></table>");
    }

    protected String getDescription(Database database, Table table, String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (table != null) {
            if (table.isView()) {
                stringBuilder.append("View ");
            } else {
                stringBuilder.append("Table ");
            }
        }
        if (bl) {
            stringBuilder.append("<span title='Database'>");
        }
        stringBuilder.append(database.getName());
        if (bl) {
            stringBuilder.append("</span>");
        }
        if (database.getSchema() != null) {
            stringBuilder.append('.');
            if (bl) {
                stringBuilder.append("<span title='Schema'>");
            }
            stringBuilder.append(database.getSchema());
            if (bl) {
                stringBuilder.append("</span>");
            }
        }
        if (table != null) {
            stringBuilder.append('.');
            if (bl) {
                stringBuilder.append("<span title='Table'>");
            }
            stringBuilder.append(table.getName());
            if (bl) {
                stringBuilder.append("</span>");
            }
        }
        if (string != null) {
            stringBuilder.append(" - ");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    protected boolean sourceForgeLogoEnabled() {
        return Config.getInstance().isLogoEnabled();
    }

    protected void writeLegend(boolean bl, LineWriter lineWriter) throws IOException {
        this.writeLegend(bl, true, lineWriter);
    }

    protected void writeLegend(boolean bl, boolean bl2, LineWriter lineWriter) throws IOException {
        lineWriter.writeln(" <table class='legend' border='0'>");
        lineWriter.writeln("  <tr>");
        lineWriter.writeln("   <td class='dataTable' valign='bottom'>Legend:</td>");
        if (this.sourceForgeLogoEnabled()) {
            lineWriter.writeln("   <td class='container' align='right' valign='top'><a href='http://sourceforge.net' target='_blank'><img src='http://sourceforge.net/sflogo.php?group_id=137197&amp;type=1' alt='SourceForge.net' border='0' height='31' width='88'></a></td>");
        }
        lineWriter.writeln("  </tr>");
        lineWriter.writeln("  <tr><td class='container' colspan='2'>");
        lineWriter.writeln("   <table class='dataTable' border='1'>");
        lineWriter.writeln("    <tbody>");
        lineWriter.writeln("    <tr><td class='primaryKey'>Primary key columns</td></tr>");
        lineWriter.writeln("    <tr><td class='indexedColumn'>Columns with indexes</td></tr>");
        if (bl) {
            lineWriter.writeln("    <tr class='impliedRelationship'><td class='detail'><span class='impliedRelationship'>Implied relationships</span></td></tr>");
        }
        if (bl2) {
            lineWriter.writeln("    <tr><td class='excludedColumn'>Excluded column relationships</td></tr>");
            if (!bl) {
                lineWriter.writeln("    <tr class='impliedRelationship'><td class='legendDetail'>Dashed lines show implied relationships</td></tr>");
            }
            lineWriter.writeln("    <tr><td class='legendDetail'>&lt; <em>n</em> &gt; number of related tables</td></tr>");
        }
        lineWriter.writeln("   </table>");
        lineWriter.writeln("  </td></tr>");
        lineWriter.writeln(" </table>");
        this.writeFeedMe(lineWriter);
        lineWriter.writeln("&nbsp;");
    }

    protected void writeFeedMe(LineWriter lineWriter) throws IOException {
        if (Config.getInstance().isAdsEnabled()) {
            StyleSheet styleSheet = StyleSheet.getInstance();
            lineWriter.writeln("<div style=\"margin-right: 2pt;\">");
            lineWriter.writeln("<script type=\"text/javascript\"><!--");
            lineWriter.writeln("google_ad_client = \"pub-9598353634003340\";");
            lineWriter.writeln("google_ad_channel =\"SchemaSpy-generated\";");
            lineWriter.writeln("google_ad_width = 234;");
            lineWriter.writeln("google_ad_height = 60;");
            lineWriter.writeln("google_ad_format = \"234x60_as\";");
            lineWriter.writeln("google_ad_type = \"text\";");
            lineWriter.writeln("google_color_border = \"" + styleSheet.getTableHeadBackground().substring(1) + "\";");
            lineWriter.writeln("google_color_link = \"" + styleSheet.getLinkColor().substring(1) + "\";");
            lineWriter.writeln("google_color_text = \"000000\";");
            lineWriter.writeln("//-->");
            lineWriter.writeln("</script>");
            lineWriter.writeln("<script type=\"text/javascript\"");
            lineWriter.writeln("src=\"http://pagead2.googlesyndication.com/pagead/show_ads.js\">");
            lineWriter.writeln("</script>");
            lineWriter.writeln("</div>");
        }
    }

    protected void writeExcludedColumns(Set<TableColumn> set, Table table, LineWriter lineWriter) throws IOException {
        Set<TableColumn> set2;
        if (table == null) {
            set2 = set;
        } else {
            set2 = new HashSet<TableColumn>();
            for (TableColumn tableColumn : set) {
                if (!tableColumn.isAllExcluded() && tableColumn.getTable().equals(table)) continue;
                set2.add(tableColumn);
            }
        }
        if (set2.size() > 0) {
            lineWriter.writeln("<span class='excludedRelationship'>");
            lineWriter.writeln("<br>Excluded from diagram's relationships: ");
            for (TableColumn tableColumn : set2) {
                if (tableColumn.getTable().equals(table)) continue;
                lineWriter.write("<a href=\"" + this.getPathToRoot() + "tables/");
                lineWriter.write(tableColumn.getTable().getName());
                lineWriter.write(".html\">");
                lineWriter.write(tableColumn.getTable().getName());
                lineWriter.write(".");
                lineWriter.write(tableColumn.getName());
                lineWriter.writeln("</a>&nbsp;");
            }
            lineWriter.writeln("</span>");
        }
    }

    protected void writeInvalidGraphvizInstallation(LineWriter lineWriter) throws IOException {
        lineWriter.writeln("<br>SchemaSpy was unable to generate a diagram of table relationships.");
        lineWriter.writeln("<br>SchemaSpy requires Graphviz " + Dot.getInstance().getSupportedVersions().substring(4) + " from <a href='http://www.graphviz.org' target='_blank'>www.graphviz.org</a>.");
    }

    protected void writeFooter(LineWriter lineWriter) throws IOException {
        lineWriter.writeln("</div>");
        if (this.isMetered) {
            lineWriter.writeln("<span style='float: right;' title='This link is only on the SchemaSpy sample pages'>");
            lineWriter.writeln("<!-- Site Meter -->");
            lineWriter.writeln("<script type='text/javascript' src='http://s28.sitemeter.com/js/counter.js?site=s28schemaspy'>");
            lineWriter.writeln("</script>");
            lineWriter.writeln("<noscript>");
            lineWriter.writeln("<a href='http://s28.sitemeter.com/stats.asp?site=s28schemaspy' target='_top'>");
            lineWriter.writeln("<img src='http://s28.sitemeter.com/meter.asp?site=s28schemaspy' alt='Site Meter' border='0'/></a>");
            lineWriter.writeln("</noscript>");
            lineWriter.writeln("<!-- Copyright (c)2006 Site Meter -->");
            lineWriter.writeln("</span>");
        }
        lineWriter.writeln("</body>");
        lineWriter.writeln("</html>");
    }

    protected String getPathToRoot() {
        return "";
    }

    protected boolean isMainIndex() {
        return false;
    }

    protected boolean isRelationshipsPage() {
        return false;
    }

    protected boolean isOrphansPage() {
        return false;
    }

    protected boolean isConstraintsPage() {
        return false;
    }

    protected boolean isAnomaliesPage() {
        return false;
    }

    protected boolean isColumnsPage() {
        return false;
    }
}

