/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tessboxeditor;

import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import net.sourceforge.tessboxeditor.GuiWithMRU;
import net.sourceforge.tessboxeditor.datamodel.TessBox;

public class GuiWithEdit
extends GuiWithMRU {
    @Override
    void jMenuItemMergeActionPerformed(ActionEvent actionEvent) {
        Rectangle rectangle;
        if (this.boxes == null) {
            return;
        }
        List<TessBox> list = this.boxes.getSelectedBoxes();
        if (list.size() <= 1) {
            JOptionPane.showMessageDialog(this, "Please select more than one box for Merge operation.");
            return;
        }
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = 0;
        String string = "";
        short s = 0;
        int n5 = 0;
        for (TessBox tessBox : list) {
            string = string + tessBox.getChrs();
            s = tessBox.getPage();
            n5 = this.boxes.toList().indexOf(tessBox);
            rectangle = tessBox.getRect();
            n = Math.min(n, rectangle.x);
            n2 = Math.min(n2, rectangle.y);
            n3 = Math.max(n3, rectangle.x + rectangle.width);
            n4 = Math.max(n4, rectangle.y + rectangle.height);
            this.boxes.remove(tessBox);
        }
        if (string.length() > 0) {
            TessBox tessBox = new TessBox(string, new Rectangle(n, n2, n3 - n, n4 - n2), s);
            tessBox.setSelected(true);
            this.boxes.add(n5, tessBox);
            int n6 = this.boxes.toList().indexOf(tessBox);
            this.tableModel.setDataVector((Object[][])this.boxes.getTableDataList().toArray((T[])new String[0][5]), this.headers);
            this.jTable.setRowSelectionInterval(n6, n6);
            rectangle = this.jTable.getCellRect(n6, 0, true);
            this.jTable.scrollRectToVisible(rectangle);
        }
        this.jLabelImage.repaint();
        this.updateSave(true);
    }

    @Override
    void jMenuItemSplitActionPerformed(ActionEvent actionEvent) {
        if (this.boxes == null) {
            return;
        }
        List<TessBox> list = this.boxes.getSelectedBoxes();
        if (list.size() <= 0) {
            JOptionPane.showMessageDialog(this, "Please select a box to split.");
            return;
        }
        if (list.size() > 1) {
            JOptionPane.showMessageDialog(this, "Please select only one box for Split operation.");
            return;
        }
        boolean bl = false;
        int n = actionEvent.getModifiers();
        if ((n & 2) == 2 || (n & 8) == 8 || (n & 4) == 4) {
            bl = true;
        }
        TessBox tessBox = list.get(0);
        int n2 = this.boxes.toList().indexOf(tessBox);
        Rectangle rectangle = tessBox.getRect();
        if (!bl) {
            rectangle.width /= 2;
            this.tableModel.setValueAt(String.valueOf(rectangle.width), n2, 3);
        } else {
            rectangle.height /= 2;
            this.tableModel.setValueAt(String.valueOf(rectangle.height), n2, 4);
        }
        TessBox tessBox2 = new TessBox(tessBox.getChrs(), new Rectangle(rectangle), tessBox.getPage());
        tessBox2.setSelected(true);
        this.boxes.add(n2 + 1, tessBox2);
        Rectangle rectangle2 = tessBox2.getRect();
        if (!bl) {
            rectangle2.x += rectangle2.width;
        } else {
            rectangle2.y += rectangle2.height;
        }
        Object[] objectArray = new Object[]{tessBox2.getChrs(), rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height};
        this.tableModel.insertRow(n2 + 1, objectArray);
        this.jTable.setRowSelectionInterval(n2, n2 + 1);
        this.resetReadout();
        this.jLabelImage.repaint();
        this.updateSave(true);
    }

    @Override
    void jMenuItemInsertActionPerformed(ActionEvent actionEvent) {
        if (this.boxes == null) {
            return;
        }
        List<TessBox> list = this.boxes.getSelectedBoxes();
        if (list.size() <= 0) {
            JOptionPane.showMessageDialog(this, "Please select the box to insert after.");
            return;
        }
        if (list.size() > 1) {
            JOptionPane.showMessageDialog(this, "Please select only one box for Insert operation.");
            return;
        }
        TessBox tessBox = list.get(0);
        int n = this.boxes.toList().indexOf(tessBox);
        TessBox tessBox2 = new TessBox(tessBox.getChrs(), new Rectangle(tessBox.getRect()), tessBox.getPage());
        tessBox2.setSelected(true);
        this.boxes.add(++n, tessBox2);
        Rectangle rectangle = tessBox2.getRect();
        rectangle.x += 15;
        Object[] objectArray = new Object[]{tessBox2.getChrs(), rectangle.x, rectangle.y, rectangle.width, rectangle.height};
        this.tableModel.insertRow(n, objectArray);
        this.jTable.setRowSelectionInterval(n, n);
        this.jLabelImage.repaint();
        this.updateSave(true);
    }

    @Override
    void jMenuItemDeleteActionPerformed(ActionEvent actionEvent) {
        if (this.boxes == null) {
            return;
        }
        List<TessBox> list = this.boxes.getSelectedBoxes();
        if (list.size() <= 0) {
            JOptionPane.showMessageDialog(this, "Please select a box or more to delete.");
            return;
        }
        for (TessBox tessBox : list) {
            int n = this.boxes.toList().indexOf(tessBox);
            this.boxes.remove(tessBox);
            this.tableModel.removeRow(n);
        }
        this.resetReadout();
        this.jLabelImage.repaint();
        this.updateSave(true);
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GuiWithEdit().setVisible(true);
            }
        });
    }
}

