/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tessboxeditor;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sourceforge.tessboxeditor.GuiWithSpinner;
import net.sourceforge.tessboxeditor.components.MyTableCellEditor;
import net.sourceforge.vietpad.components.FontDialog;

public class GuiWithFont
extends GuiWithSpinner {
    private static final Logger logger = Logger.getLogger(GuiWithFont.class.getName());

    public GuiWithFont() {
        this.font = new Font(prefs.get("fontName", MAC_OS_X ? "Lucida Grande" : "Tahoma"), prefs.getInt("fontStyle", 0), prefs.getInt("fontSize", 12));
        this.changeFont(this.font);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void jMenuItemFontActionPerformed(ActionEvent actionEvent) {
        FontDialog fontDialog = new FontDialog(this);
        fontDialog.setAttributes(this.font);
        fontDialog.setVisible(true);
        if (fontDialog.succeeded()) {
            this.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            this.getGlassPane().setVisible(true);
            try {
                this.font = fontDialog.getFont();
                this.changeFont(this.font);
            }
            catch (Exception exception) {
                try {
                    logger.log(Level.WARNING, exception.getMessage(), exception);
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GuiWithFont.this.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                            GuiWithFont.this.getGlassPane().setVisible(false);
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }

    private void changeFont(Font font) {
        this.jTextAreaBoxData.setFont(font);
        this.jTextAreaBoxData.validate();
        this.jTextAreaOutput.setFont(font);
        Font font2 = font.deriveFont(14.0f);
        this.jTextFieldCharacter.setFont(font2);
        this.jTextFieldCharacter.validate();
        this.jTextFieldFind.setFont(font2);
        this.jTextFieldFind.validate();
        this.jTextFieldChar.setFont(font2);
        Font font3 = this.jTable.getFont().deriveFont(font.getSize2D());
        this.jTable.setFont(font3);
        FontMetrics fontMetrics = this.jTable.getFontMetrics(font3);
        this.jTable.setRowHeight(fontMetrics.getHeight());
        this.rowHeader.setFont(font3);
        ((MyTableCellEditor)this.jTable.getDefaultEditor(String.class)).setFont(font);
        this.jTable.revalidate();
        this.jPanelCoord.revalidate();
        this.jLabelImage.setFont(font);
        this.jTextAreaValidationResult.setFont(font);
    }

    @Override
    void quit() {
        prefs.put("fontName", this.font.getName());
        prefs.putInt("fontSize", this.font.getSize());
        prefs.putInt("fontStyle", this.font.getStyle());
        super.quit();
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GuiWithFont().setVisible(true);
            }
        });
    }
}

