/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.sourceforge.schemaspy.model.ForeignKeyConstraint;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.model.TableIndex;
import net.sourceforge.schemaspy.util.DOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlTableFormatter {
    private static final XmlTableFormatter instance = new XmlTableFormatter();
    private static final Pattern validXmlChars = Pattern.compile("^[ -\ud7ff\ue000-\ufffd\\p{L}\\p{M}\\p{Z}\\p{S}\\p{N}\\p{P}]*$");

    private XmlTableFormatter() {
    }

    public static XmlTableFormatter getInstance() {
        return instance;
    }

    public void appendTables(Element element, Collection<Table> collection) {
        TreeSet<Table> treeSet = new TreeSet<Table>(new Comparator<Table>(){

            @Override
            public int compare(Table table, Table table2) {
                return table.getName().compareToIgnoreCase(table2.getName());
            }
        });
        treeSet.addAll(collection);
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("tables");
        element.appendChild(element2);
        for (Table table : treeSet) {
            this.appendTable(element2, table);
        }
    }

    private void appendTable(Element element, Table table) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("table");
        element.appendChild(element2);
        if (table.getId() != null) {
            DOMUtil.appendAttribute(element2, "id", String.valueOf(table.getId()));
        }
        if (table.getSchema() != null) {
            DOMUtil.appendAttribute(element2, "schema", table.getSchema());
        }
        DOMUtil.appendAttribute(element2, "name", table.getName());
        if (table.getNumRows() != -1) {
            DOMUtil.appendAttribute(element2, "numRows", String.valueOf(table.getNumRows()));
        }
        DOMUtil.appendAttribute(element2, "type", table.isView() ? "VIEW" : "TABLE");
        DOMUtil.appendAttribute(element2, "remarks", table.getComments() == null ? "" : table.getComments());
        this.appendColumns(element2, table);
        this.appendPrimaryKeys(element2, table);
        this.appendIndexes(element2, table);
        this.appendCheckConstraints(element2, table);
        this.appendView(element2, table);
    }

    private void appendColumns(Element element, Table table) {
        for (TableColumn tableColumn : table.getColumns()) {
            this.appendColumn(element, tableColumn);
        }
    }

    private Node appendColumn(Node node, TableColumn tableColumn) {
        ForeignKeyConstraint foreignKeyConstraint;
        Element element;
        Document document = node.getOwnerDocument();
        Element element2 = document.createElement("column");
        node.appendChild(element2);
        DOMUtil.appendAttribute(element2, "id", String.valueOf(tableColumn.getId()));
        DOMUtil.appendAttribute(element2, "name", tableColumn.getName());
        DOMUtil.appendAttribute(element2, "type", tableColumn.getType());
        DOMUtil.appendAttribute(element2, "size", String.valueOf(tableColumn.getLength()));
        DOMUtil.appendAttribute(element2, "digits", String.valueOf(tableColumn.getDecimalDigits()));
        DOMUtil.appendAttribute(element2, "nullable", String.valueOf(tableColumn.isNullable()));
        DOMUtil.appendAttribute(element2, "autoUpdated", String.valueOf(tableColumn.isAutoUpdated()));
        if (tableColumn.getDefaultValue() != null) {
            Object object = tableColumn.getDefaultValue().toString();
            if (XmlTableFormatter.isBinary((String)object)) {
                object = this.asBinary((String)object);
                DOMUtil.appendAttribute(element2, "defaultValueIsBinary", "true");
            }
            DOMUtil.appendAttribute(element2, "defaultValue", (String)object);
        }
        DOMUtil.appendAttribute(element2, "remarks", tableColumn.getComments() == null ? "" : tableColumn.getComments());
        for (TableColumn tableColumn2 : tableColumn.getChildren()) {
            element = document.createElement("child");
            element2.appendChild(element);
            foreignKeyConstraint = tableColumn.getChildConstraint(tableColumn2);
            DOMUtil.appendAttribute(element, "foreignKey", foreignKeyConstraint.getName());
            DOMUtil.appendAttribute(element, "table", tableColumn2.getTable().getName());
            DOMUtil.appendAttribute(element, "column", tableColumn2.getName());
            DOMUtil.appendAttribute(element, "implied", String.valueOf(foreignKeyConstraint.isImplied()));
            DOMUtil.appendAttribute(element, "onDeleteCascade", String.valueOf(foreignKeyConstraint.isCascadeOnDelete()));
        }
        for (TableColumn tableColumn2 : tableColumn.getParents()) {
            element = document.createElement("parent");
            element2.appendChild(element);
            foreignKeyConstraint = tableColumn.getParentConstraint(tableColumn2);
            DOMUtil.appendAttribute(element, "foreignKey", foreignKeyConstraint.getName());
            DOMUtil.appendAttribute(element, "table", tableColumn2.getTable().getName());
            DOMUtil.appendAttribute(element, "column", tableColumn2.getName());
            DOMUtil.appendAttribute(element, "implied", String.valueOf(foreignKeyConstraint.isImplied()));
            DOMUtil.appendAttribute(element, "onDeleteCascade", String.valueOf(foreignKeyConstraint.isCascadeOnDelete()));
        }
        return element2;
    }

    private void appendPrimaryKeys(Element element, Table table) {
        Document document = element.getOwnerDocument();
        int n = 1;
        for (TableColumn tableColumn : table.getPrimaryColumns()) {
            Element element2 = document.createElement("primaryKey");
            element.appendChild(element2);
            DOMUtil.appendAttribute(element2, "column", tableColumn.getName());
            DOMUtil.appendAttribute(element2, "sequenceNumberInPK", String.valueOf(n++));
        }
    }

    private void appendCheckConstraints(Element element, Table table) {
        Document document = element.getOwnerDocument();
        Map<String, String> map = table.getCheckConstraints();
        if (map != null && !map.isEmpty()) {
            for (String string : map.keySet()) {
                Element element2 = document.createElement("checkConstraint");
                element.appendChild(element2);
                DOMUtil.appendAttribute(element2, "name", string);
                DOMUtil.appendAttribute(element2, "constraint", map.get(string).toString());
            }
        }
    }

    private void appendIndexes(Node node, Table table) {
        boolean bl = table.getId() != null;
        Set<TableIndex> set = table.getIndexes();
        if (set != null && !set.isEmpty()) {
            set = new TreeSet<TableIndex>(set);
            Document document = node.getOwnerDocument();
            for (TableIndex tableIndex : set) {
                Element element = document.createElement("index");
                if (bl) {
                    DOMUtil.appendAttribute(element, "id", String.valueOf(tableIndex.getId()));
                }
                DOMUtil.appendAttribute(element, "name", tableIndex.getName());
                DOMUtil.appendAttribute(element, "unique", String.valueOf(tableIndex.isUnique()));
                for (TableColumn tableColumn : tableIndex.getColumns()) {
                    Element element2 = document.createElement("column");
                    DOMUtil.appendAttribute(element2, "name", tableColumn.getName());
                    DOMUtil.appendAttribute(element2, "ascending", String.valueOf(tableIndex.isAscending(tableColumn)));
                    element.appendChild(element2);
                }
                node.appendChild(element);
            }
        }
    }

    private void appendView(Element element, Table table) {
        String string;
        if (table.isView() && (string = table.getViewSql()) != null) {
            DOMUtil.appendAttribute(element, "viewSql", string);
        }
    }

    private static boolean isBinary(String string) {
        return !validXmlChars.matcher(string).matches();
    }

    private String asBinary(String string) {
        byte[] byArray = string.getBytes();
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(String.format("%02X", byArray[i]));
        }
        return stringBuilder.toString();
    }
}

