/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction;

import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.Presenter;
import com.jbidwatcher.util.config.JConfig;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;

public class AuctionEntryHTMLPresenter
implements Presenter {
    private final AuctionEntry mAuctionEntry;
    public static final String newRow = "<tr><td>";
    public static final String newCol = "</td><td>";
    public static final String endRow = "</td></tr>";

    public AuctionEntryHTMLPresenter(AuctionEntry mAuctionEntry) {
        this.mAuctionEntry = mAuctionEntry;
    }

    @Override
    public String buildInfo(boolean includeEvents) {
        String prompt = "";
        prompt = prompt + "<b>" + this.mAuctionEntry.getTitle() + "</b> (" + this.mAuctionEntry.getIdentifier() + ")<br>";
        prompt = prompt + "<table>";
        boolean addedThumbnail = false;
        if (this.mAuctionEntry.getThumbnail() != null) {
            String thumb = this.mAuctionEntry.getThumbnail();
            try {
                ImageIcon thumbnail = new ImageIcon(new URL(thumb));
                if (thumbnail.getImageLoadStatus() == 8) {
                    int h = thumbnail.getIconHeight();
                    int w = thumbnail.getIconWidth();
                    int long_side = Math.max(h, w);
                    float scale = 192.0f / (float)long_side;
                    h = (int)((float)h * scale);
                    w = (int)((float)w * scale);
                    prompt = prompt + "<tr><td><img src=\"" + this.mAuctionEntry.getThumbnail() + "\" height=" + h + " width=" + w + ">" + newCol + "<table>";
                    addedThumbnail = true;
                }
            }
            catch (MalformedURLException e) {
                JConfig.log().handleDebugException("Couldn't load the thumbnail image", e);
            }
        }
        prompt = this.buildInfoBody(prompt, includeEvents, addedThumbnail);
        return prompt;
    }

    private String buildRow(String label, Object value) {
        return newRow + label + newCol + (value != null ? value.toString() : "null") + endRow;
    }

    private String buildInfoBody(String prompt, boolean includeEvents, boolean addedThumbnail) {
        if (!this.mAuctionEntry.isFixed()) {
            prompt = prompt + this.buildRow("Currently", this.mAuctionEntry.getCurrentPrice() + " (" + this.mAuctionEntry.getNumBidders() + " Bids)");
            String bidder = this.mAuctionEntry.getHighBidder();
            prompt = prompt + this.buildRow("High bidder", bidder == null ? "(n/a)" : bidder);
        } else {
            prompt = prompt + this.buildRow("Price", this.mAuctionEntry.getCurrentPrice());
        }
        if (this.mAuctionEntry.isFixed() && this.mAuctionEntry.getQuantity() > 1) {
            prompt = prompt + this.buildRow("Quantity", this.mAuctionEntry.getQuantity());
        }
        if (JConfig.debugging() && JConfig.scriptingEnabled()) {
            prompt = prompt + this.buildRow("Sticky", Boolean.toString(this.mAuctionEntry.isSticky()));
            prompt = prompt + this.buildRow("Category", this.mAuctionEntry.getCategory());
        }
        if (this.mAuctionEntry.isBidOn()) {
            prompt = prompt + this.buildRow("Your max bid", this.mAuctionEntry.getBid());
            if (this.mAuctionEntry.getBidQuantity() != 1) {
                prompt = prompt + this.buildRow("Quantity of", this.mAuctionEntry.getBidQuantity());
            }
        }
        if (this.mAuctionEntry.isSniped()) {
            prompt = prompt + this.buildRow("Sniped for", this.mAuctionEntry.getSnipeAmount());
            if (this.mAuctionEntry.getSnipeQuantity() != 1) {
                prompt = prompt + this.buildRow("Quantity of", this.mAuctionEntry.getSnipeQuantity());
            }
            prompt = prompt + "<tr><td>Sniping at " + this.mAuctionEntry.getSnipeTime() / 1000L + " seconds before the end." + endRow;
        }
        if (this.mAuctionEntry.getShipping() != null && !this.mAuctionEntry.getShipping().isNull()) {
            prompt = prompt + this.buildRow("Shipping", this.mAuctionEntry.getShipping());
        }
        if (!this.mAuctionEntry.getInsurance().isNull()) {
            prompt = prompt + this.buildRow("Insurance (" + (this.mAuctionEntry.isInsuranceOptional() ? "optional" : "required") + ")", this.mAuctionEntry.getInsurance());
        }
        prompt = prompt + this.buildRow("Seller", this.mAuctionEntry.getSellerName());
        prompt = this.mAuctionEntry.isComplete() ? prompt + this.buildRow("Listing ended at ", this.mAuctionEntry.getEndDate()) : prompt + this.buildRow("Listing ends at", this.mAuctionEntry.getEndDate());
        if (this.mAuctionEntry.getLastUpdated() != null) {
            prompt = prompt + this.buildRow("Last updated at", this.mAuctionEntry.getLastUpdated());
        }
        if (addedThumbnail) {
            prompt = prompt + "</table></td></tr>";
        }
        prompt = prompt + "</table>";
        if (!this.mAuctionEntry.isFixed() && !this.mAuctionEntry.getBuyNow().isNull()) {
            if (this.mAuctionEntry.isComplete()) {
                prompt = prompt + "<b>You could have used Buy It Now for " + this.mAuctionEntry.getBuyNow() + "</b><br>";
            } else {
                prompt = prompt + "<b>Or you could buy it now, for " + this.mAuctionEntry.getBuyNow() + ".</b><br>";
                prompt = prompt + "Note: <i>To 'Buy Now' through this program,<br>      select 'Buy' from the context menu.</i><br>";
            }
        }
        if (this.mAuctionEntry.isComplete()) {
            prompt = prompt + "<i>Listing has ended.</i><br>";
        }
        if (this.mAuctionEntry.getComment() != null) {
            prompt = prompt + "<br><u>Comment</u><br>";
            prompt = prompt + "<b>" + this.mAuctionEntry.getComment() + "</b><br>";
        }
        if (includeEvents) {
            prompt = prompt + "<b><u>Events</u></b><blockquote>" + this.mAuctionEntry.getStatusHistory() + "</blockquote>";
        }
        return prompt;
    }

    @Override
    public String buildComment(boolean showThumbnail) {
        boolean hasThumb;
        boolean hasComment = this.mAuctionEntry.getComment() != null;
        boolean bl = hasThumb = showThumbnail && this.mAuctionEntry.getThumbnail() != null;
        if (JConfig.queryConfiguration("display.thumbnail", "true").equals("false")) {
            hasThumb = false;
        }
        if (!hasComment && !hasThumb) {
            return null;
        }
        StringBuffer wholeHTML = new StringBuffer("<html><body>");
        if (hasThumb && hasComment) {
            wholeHTML.append("<table><tr><td><img src=\"").append(this.mAuctionEntry.getThumbnail()).append("\"></td><td>").append(this.mAuctionEntry.getComment()).append("</td></tr></table>");
        } else if (hasThumb) {
            wholeHTML.append("<img src=\"").append(this.mAuctionEntry.getThumbnail()).append("\">");
        } else {
            wholeHTML.append(this.mAuctionEntry.getComment());
        }
        wholeHTML.append("</body></html>");
        return wholeHTML.toString();
    }
}

