/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction.event;

import com.jbidwatcher.util.db.ActiveRecord;
import com.jbidwatcher.util.db.Table;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class EventStatus
extends ActiveRecord {
    private String mAuctionIdentifier;
    private static Table sDB = null;

    public EventStatus() {
    }

    public EventStatus(String what, Date when) {
        this.setMessage(what);
        this.setLoggedAt(when);
        this.setRepeatCount(1);
    }

    public EventStatus(String what, Date when, Integer entryId, String identifier, String title) {
        this.setMessage(what);
        this.setLoggedAt(when);
        this.setRepeatCount(1);
        this.setEntryId(entryId);
        this.setAuctionIdentifier(identifier);
        this.setTitle(title);
    }

    public String toBulkString() {
        String count = "";
        if (this.getRepeatCount() > 1) {
            count = " (" + this.getRepeatCount() + ")";
        }
        String outStatus = this.getLoggedAt() + ": " + this.getMessage() + count;
        return outStatus;
    }

    public String toString() {
        String count = "";
        if (this.getRepeatCount() > 1) {
            count = " (" + this.getRepeatCount() + ")";
        }
        String outStatus = this.getLoggedAt() + ": " + this.getAuctionIdentifier() + " (" + this.getTitle() + ") - " + this.getMessage() + count;
        return outStatus;
    }

    protected static String getTableName() {
        return "events";
    }

    @Override
    protected Table getDatabase() {
        if (sDB == null) {
            sDB = EventStatus.openDB(EventStatus.getTableName());
        }
        return sDB;
    }

    public static EventStatus findFirstBy(String key, String value) {
        return (EventStatus)ActiveRecord.findFirstBy(EventStatus.class, key, value);
    }

    public static EventStatus find(Integer id) {
        return (EventStatus)ActiveRecord.findFirstBy(EventStatus.class, "id", Integer.toString(id));
    }

    public static List<EventStatus> findAllByEntry(Integer entryId, String identifier) {
        if (entryId == null) {
            return null;
        }
        List<? extends ActiveRecord> records = ActiveRecord.findAllBy(EventStatus.class, "entry_id", Integer.toString(entryId), "created_at ASC");
        if (records != null) {
            ArrayList<EventStatus> results = new ArrayList<EventStatus>(records.size());
            for (ActiveRecord activeRecord : records) {
                EventStatus es = (EventStatus)activeRecord;
                es.setAuctionIdentifier(identifier);
                results.add(es);
            }
            return results;
        }
        return null;
    }

    private String getAuctionIdentifier() {
        return this.mAuctionIdentifier;
    }

    public void setAuctionIdentifier(String identifier) {
        this.mAuctionIdentifier = identifier;
    }

    public String getMessage() {
        return this.getString("message");
    }

    public Date getLoggedAt() {
        return this.getDate("created_at");
    }

    public int getRepeatCount() {
        return this.getInteger("repeat_count", 1);
    }

    public String getTitle() {
        return this.getString("title");
    }

    public String getEntryId() {
        return this.getString("entry_id");
    }

    public void setMessage(String message) {
        this.setString("message", message);
    }

    public void setLoggedAt(Date loggedAt) {
        this.setDate("created_at", loggedAt);
    }

    public void setRepeatCount(int repeatCount) {
        this.setInteger("repeat_count", repeatCount);
    }

    public void setTitle(String title) {
        this.setString("title", title);
    }

    public void setEntryId(Integer entryId) {
        this.setInteger("entry_id", entryId);
    }

    public boolean deleteForEntry(int id) {
        return this.deleteAllEntries(Integer.toString(id));
    }

    public boolean deleteAllEntries(String entries) {
        return this.getDatabase().deleteBy("entry_id IN (" + entries + ")");
    }
}

