/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.jbidwatcher.auction.Auctions;
import com.jbidwatcher.auction.EntryCorral;
import com.jbidwatcher.auction.MultiSnipeManager;
import com.jbidwatcher.ui.AuctionsUIModel;
import com.jbidwatcher.ui.JBidContext;
import com.jbidwatcher.ui.JTabManager;
import com.jbidwatcher.ui.myTableCellRenderer;
import java.awt.Color;
import java.awt.event.ActionListener;

public class AuctionListHolder {
    private Auctions mAuctionList;
    private AuctionsUIModel mAuctionUI;
    private boolean mDeletable = true;
    private static JBidContext sFrameContext;
    private static JBidContext sTableContext;
    private static ActionListener sCornerButtonListener;

    public boolean isDeletable() {
        return this.mDeletable;
    }

    void setBackground(Color presetBackground) {
        this.mAuctionUI.setBackground(presetBackground);
    }

    @Inject
    AuctionListHolder(JTabManager tabs, EntryCorral entryCorral, myTableCellRenderer cellRenderer, MultiSnipeManager multiManager, @Assisted String name, @Assisted(value="completed") boolean _completed, @Assisted(value="deletable") boolean deletable) {
        this.mAuctionList = new Auctions(entryCorral, name);
        if (_completed) {
            this.mAuctionList.setComplete();
        }
        this.mAuctionUI = new AuctionsUIModel(this.mAuctionList, cellRenderer, multiManager, sTableContext, sFrameContext, sCornerButtonListener);
        this.mDeletable = deletable;
        tabs.add(name, this.mAuctionUI.getPanel(), this.mAuctionUI.getTable());
    }

    public Auctions getList() {
        return this.mAuctionList;
    }

    public AuctionsUIModel getUI() {
        return this.mAuctionUI;
    }

    public static void setFrameContext(JBidContext frameContext) {
        sFrameContext = frameContext;
    }

    public static void setTableContext(JBidContext tableContext) {
        sTableContext = tableContext;
    }

    public static void setCornerButtonListener(ActionListener listener) {
        sCornerButtonListener = listener;
    }
}

