/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.jbidwatcher.util.config.JConfig;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class JPrintable
implements Printable,
Runnable {
    JTable tableView;
    protected int m_maxNumPage = 1;
    private static Thread m_thr = null;

    public JPrintable(JTable _myTable) {
        this.tableView = _myTable;
    }

    public void doPrint() {
        m_thr = new Thread((Runnable)this, "Printing");
        m_thr.start();
    }

    @Override
    public void run() {
        this.myPrint();
    }

    public void myPrint() {
        PrinterJob pj = PrinterJob.getPrinterJob();
        PageFormat pf = pj.defaultPage();
        pf.setOrientation(0);
        pj.setPrintable(this, pf);
        if (!pj.printDialog()) {
            return;
        }
        try {
            pj.print();
        }
        catch (Exception pe) {
            JConfig.log().handleException("Failed to print: " + pe, pe);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex >= this.m_maxNumPage) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        g2.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        int fontHeight = g2.getFontMetrics().getHeight();
        int fontDescent = g2.getFontMetrics().getDescent();
        double pageHeight = pageFormat.getImageableHeight() - (double)fontHeight;
        double pageWidth = pageFormat.getImageableWidth();
        double tableWidth = this.tableView.getColumnModel().getTotalColumnWidth();
        double scale = 1.0;
        if (tableWidth >= pageWidth) {
            scale = pageWidth / tableWidth;
        }
        g2.setFont(this.tableView.getFont());
        g2.setColor(Color.black);
        g2.drawString("Page: " + (pageIndex + 1), (int)pageWidth / 2 - 35, (int)(pageHeight + (double)fontHeight - (double)fontDescent));
        TableColumnModel colModel = this.tableView.getColumnModel();
        int nColumns = colModel.getColumnCount();
        int[] x = new int[nColumns];
        x[0] = 0;
        g2.scale(scale, scale);
        JPrintable.prepColumnWidths(nColumns, colModel, x);
        g2.setFont(this.tableView.getFont());
        FontMetrics fm = g2.getFontMetrics();
        int h = fm.getHeight();
        double headerHeightOnPage = (double)this.tableView.getTableHeader().getHeight() * scale;
        double tableWidthOnPage = tableWidth * scale;
        double oneRowHeight = (double)(this.tableView.getRowHeight() + this.tableView.getRowMargin()) * scale;
        int numRowsOnAPage = (int)((pageHeight - headerHeightOnPage) / oneRowHeight);
        int y = (int)headerHeightOnPage + fm.getMaxAscent() + fm.getLeading();
        this.m_maxNumPage = (int)Math.ceil((double)this.tableView.getRowCount() / (double)numRowsOnAPage);
        if (pageIndex >= this.m_maxNumPage) {
            return 1;
        }
        int iniRow = pageIndex * numRowsOnAPage;
        int endRow = Math.min(this.tableView.getRowCount(), iniRow + numRowsOnAPage);
        StringBuffer sbuf = new StringBuffer();
        Rectangle r = new Rectangle(0, 0, 0, 0);
        for (int nRow = iniRow; nRow < endRow; ++nRow) {
            for (int nCol = 0; nCol < nColumns; ++nCol) {
                Object obj = this.tableView.getValueAt(nRow, nCol);
                int width = this.tableView.getColumnModel().getColumn(nCol).getWidth();
                if (obj instanceof Icon) {
                    Icon drawme = (Icon)obj;
                    int trueX = x[nCol] + (width / 2 - drawme.getIconWidth() / 2);
                    g2.setClip(trueX, y, drawme.getIconWidth(), drawme.getIconHeight());
                    drawme.paintIcon(this.tableView, g2, trueX, y);
                    continue;
                }
                sbuf.setLength(0);
                if (obj != null) {
                    sbuf.append(obj.toString());
                }
                r.setBounds(x[nCol], y, width, h);
                g2.setClip(r);
                g2.drawString(sbuf.toString(), x[nCol], y + fm.getMaxAscent());
            }
            y += h;
        }
        g2.scale(1.0 / scale, 1.0 / scale);
        g2.setClip(0, 0, (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(headerHeightOnPage));
        g2.scale(scale, scale);
        this.tableView.getTableHeader().paint(g2);
        System.gc();
        return 0;
    }

    private static void prepColumnWidths(int nColumns, TableColumnModel colModel, int[] x) {
        for (int nCol = 0; nCol < nColumns; ++nCol) {
            TableColumn tk = colModel.getColumn(nCol);
            int width = tk.getWidth();
            if (nCol + 1 >= nColumns) continue;
            x[nCol + 1] = x[nCol] + width;
        }
    }
}

