/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.config;

import com.jbidwatcher.my.MyJBidwatcher;
import com.jbidwatcher.ui.config.JConfigTab;
import com.jbidwatcher.ui.util.JBEditorPane;
import com.jbidwatcher.ui.util.JPasteListener;
import com.jbidwatcher.ui.util.OptionUI;
import com.jbidwatcher.ui.util.SpringUtilities;
import com.jbidwatcher.util.config.JConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class JConfigMyJBidwatcherTab
extends JConfigTab {
    private final MyJBidwatcher myJBidwatcher;
    private JCheckBox mEnable;
    private JTextField mEmail;
    private JTextField mPassword;
    private JButton mCreateOrUpdate;
    private JLabel mStatusLabel;
    private Map<JCheckBox, String> mConfigurationMap = new HashMap<JCheckBox, String>();
    private Map<JCheckBox, String> mEnabledMap = new HashMap<JCheckBox, String>();
    private JLabel mListingStats;
    private JLabel mCategoryStats;
    private JLabel mSSLEnabled;
    private static final ImageIcon successIcon = new ImageIcon(JConfig.getResource("/icons/status_green_16.png"));
    private static final ImageIcon failIcon = new ImageIcon(JConfig.getResource("/icons/status_red_16.png"));

    @Override
    public String getTabName() {
        return "My JBidwatcher";
    }

    @Override
    public void cancel() {
        this.mStatusLabel.setIcon(null);
        this.mStatusLabel.setText("");
    }

    @Override
    public void apply() {
        String password;
        String email = this.mEmail.getText();
        if (this.myJBidwatcher.getAccountInfo(email, password = this.mPassword.getText())) {
            JConfig.setConfiguration("my.jbidwatcher.id", email);
            JConfig.setConfiguration("my.jbidwatcher.key", password);
        }
        if (JConfig.queryConfiguration("my.jbidwatcher.allow.sync") != null) {
            for (JCheckBox cb : this.mConfigurationMap.keySet()) {
                String cfg = this.mConfigurationMap.get(cb);
                JConfig.setConfiguration(cfg, Boolean.toString(cb.isSelected()));
            }
        }
        this.mStatusLabel.setIcon(null);
        this.mStatusLabel.setText("");
    }

    @Override
    public void updateValues() {
        String email = JConfig.queryConfiguration("my.jbidwatcher.id", "");
        String pass = JConfig.queryConfiguration("my.jbidwatcher.key", "");
        this.mEnable.setSelected(JConfig.queryConfiguration("my.jbidwatcher.enabled", "false").equals("true"));
        for (JCheckBox cb : this.mEnabledMap.keySet()) {
            String cfg = this.mEnabledMap.get(cb);
            cb.setEnabled(this.mEnable.isSelected() && JConfig.queryConfiguration(cfg, "false").equals("true"));
        }
        this.mEmail.setText(email);
        this.mPassword.setText(pass);
        this.mListingStats.setText(this.left("listings"));
        this.mCategoryStats.setText(this.left("categories"));
        this.mSSLEnabled.setText(this.sslState());
        for (ActionListener al : this.mEnable.getActionListeners()) {
            al.actionPerformed(new ActionEvent(this.mEnable, 1001, "Redraw"));
        }
    }

    private void setComponentTooltip(JComponent comp, String text) {
        comp.setToolTipText(text);
        comp.getAccessibleContext().setAccessibleDescription(text);
    }

    private JPanel buildUserSettings(JPasteListener pasteListener) {
        JPanel jp = new JPanel(new BorderLayout());
        jp.setBorder(BorderFactory.createTitledBorder("My JBidwatcher User Settings"));
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new SpringLayout());
        this.mEmail = new JTextField();
        this.mEmail.addMouseListener(pasteListener);
        this.setComponentTooltip(this.mEmail, "Email address to use for your My JBidwatcher account.");
        final JLabel emailLabel = new JLabel("Email Address:");
        emailLabel.setLabelFor(this.mEmail);
        innerPanel.add(emailLabel);
        innerPanel.add(this.mEmail);
        this.mPassword = new JTextField();
        this.mPassword.addMouseListener(pasteListener);
        this.setComponentTooltip(this.mPassword, "My JBidwatcher access key");
        final JLabel passwordLabel = new JLabel("Access Key:");
        passwordLabel.setLabelFor(this.mPassword);
        innerPanel.add(passwordLabel);
        innerPanel.add(this.mPassword);
        Box button = Box.createHorizontalBox();
        this.mStatusLabel = new JLabel("");
        this.mCreateOrUpdate = new JButton("Test Access");
        this.mCreateOrUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String action = event.getActionCommand();
                if (action == null) {
                    return;
                }
                if (JConfigMyJBidwatcherTab.this.myJBidwatcher.getAccountInfo(JConfigMyJBidwatcherTab.this.mEmail.getText(), JConfigMyJBidwatcherTab.this.mPassword.getText())) {
                    JConfigMyJBidwatcherTab.this.mStatusLabel.setIcon(successIcon);
                    JConfigMyJBidwatcherTab.this.mStatusLabel.setText("success!");
                    if (JConfig.queryConfiguration("my.jbidwatcher.sync") == null) {
                        JConfig.setConfiguration("my.jbidwatcher.sync", "true");
                    }
                    JConfigMyJBidwatcherTab.this.updateValues();
                } else {
                    JConfigMyJBidwatcherTab.this.mStatusLabel.setIcon(failIcon);
                    JConfigMyJBidwatcherTab.this.mStatusLabel.setText("failed.");
                }
            }
        });
        button.add(this.mCreateOrUpdate);
        button.add(this.mStatusLabel);
        innerPanel.add(new JLabel());
        innerPanel.add(button);
        SpringUtilities.makeCompactGrid(innerPanel, 3, 2, 6, 6, 6, 1);
        this.mEnable = new JCheckBox();
        this.mEnable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean selected = JConfigMyJBidwatcherTab.this.mEnable.isSelected();
                emailLabel.setEnabled(selected);
                JConfigMyJBidwatcherTab.this.mEmail.setEnabled(selected);
                JConfigMyJBidwatcherTab.this.mEmail.setEditable(selected);
                passwordLabel.setEnabled(selected);
                JConfigMyJBidwatcherTab.this.mPassword.setEnabled(selected);
                JConfigMyJBidwatcherTab.this.mPassword.setEditable(selected);
                JConfigMyJBidwatcherTab.this.mCreateOrUpdate.setEnabled(selected);
                for (JCheckBox cb : JConfigMyJBidwatcherTab.this.mEnabledMap.keySet()) {
                    if (cb == JConfigMyJBidwatcherTab.this.mEnable) continue;
                    cb.setEnabled(selected && JConfig.queryConfiguration((String)JConfigMyJBidwatcherTab.this.mEnabledMap.get(cb), "false").equals("true"));
                }
                for (JCheckBox cb : JConfigMyJBidwatcherTab.this.mConfigurationMap.keySet()) {
                    if (cb == JConfigMyJBidwatcherTab.this.mEnable) continue;
                    cb.setSelected(selected && JConfig.queryConfiguration((String)JConfigMyJBidwatcherTab.this.mConfigurationMap.get(cb), "false").equals("true"));
                }
            }
        });
        JLabel enableLabel = new JLabel("Enable My JBidwatcher");
        enableLabel.setLabelFor(this.mEnable);
        this.mConfigurationMap.put(this.mEnable, "my.jbidwatcher.enabled");
        jp.add((Component)JConfigMyJBidwatcherTab.makeLine(this.mEnable, enableLabel), "North");
        jp.add((Component)innerPanel, "Center");
        return jp;
    }

    public JConfigMyJBidwatcherTab(MyJBidwatcher myJBidwatcher, JPasteListener pasteListener) {
        this.myJBidwatcher = myJBidwatcher;
        String prefix = "<html><body><div style=\"font-size: 0.96em;\"><center><i>";
        String suffix = "</i></center></div></body></html>";
        String link = "<a href=\"http://my.jbidwatcher.com\">My JBidwatcher</a>";
        JBEditorPane jep = OptionUI.getHTMLLabel(prefix + "Signing up for " + link + " is welcome, and free right now, but <b>not</b> required for JBidwatcher operation." + suffix);
        this.setLayout(new BorderLayout());
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add((Component)this.buildUserSettings(pasteListener), "North");
        jp.add((Component)this.buildExtraSettings(), "South");
        this.add((Component)JConfigMyJBidwatcherTab.panelPack(jp), "Center");
        this.add((Component)jep, "North");
        this.updateValues();
    }

    private JPanel buildExtraSettings() {
        JPanel jp = new JPanel(new BorderLayout());
        jp.setBorder(BorderFactory.createTitledBorder("My JBidwatcher Settings"));
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new SpringLayout());
        innerPanel.add(this.createSettingsCheckbox("Upload item info to My JBidwatcher", "sync"));
        innerPanel.add(this.createSettingsCheckbox("Upload item HTML", "uploadhtml"));
        innerPanel.add(this.createSettingsCheckbox("Upload snipes to Gixen", "gixen"));
        innerPanel.add(this.createSettingsCheckbox("Allow setting snipes in My JBidwatcher", "snipes"));
        innerPanel.add(this.createSettingsCheckbox("Use My JBidwatcher as a fallback parser", "parser"));
        innerPanel.add(new JLabel());
        this.mListingStats = new JLabel(this.left("listings"));
        this.mListingStats.setFont(this.mListingStats.getFont().deriveFont(1));
        this.mCategoryStats = new JLabel(this.left("categories"));
        this.mCategoryStats.setFont(this.mCategoryStats.getFont().deriveFont(1));
        innerPanel.add(this.mListingStats);
        innerPanel.add(this.mCategoryStats);
        innerPanel.add(new JLabel(""));
        this.mSSLEnabled = new JLabel();
        this.mSSLEnabled.setText(this.sslState());
        this.mSSLEnabled.setFont(this.mSSLEnabled.getFont().deriveFont(3));
        JPanel tmp = new JPanel(new BorderLayout());
        tmp.add((Component)this.mSSLEnabled, "East");
        innerPanel.add(tmp);
        SpringUtilities.makeCompactGrid(innerPanel, 5, 2, 6, 6, 6, 1);
        jp.add((Component)innerPanel, "Center");
        return jp;
    }

    private String sslState() {
        return JConfig.queryConfiguration("my.jbidwatcher.allow.ssl", "false").equals("true") ? "SSL Enabled" : "SSL Disabled";
    }

    private JCheckBox createSettingsCheckbox(String text, String identifier) {
        String cfgAllowed = "my.jbidwatcher.allow." + identifier;
        boolean allowed = JConfig.queryConfiguration(cfgAllowed, "false").equals("true");
        String cfgSetting = "my.jbidwatcher." + identifier;
        boolean set = JConfig.queryConfiguration(cfgSetting, "false").equals("true");
        JCheckBox cb = new JCheckBox(text);
        cb.setEnabled(allowed);
        cb.setSelected(set);
        this.mConfigurationMap.put(cb, cfgSetting);
        this.mEnabledMap.put(cb, cfgAllowed);
        return cb;
    }

    private String left(String type) {
        String listings = JConfig.queryConfiguration("my.jbidwatcher.allow." + type, "unknown");
        if (listings.equals("-1")) {
            listings = "unlimited";
        }
        return listings + " " + type + " remaining";
    }
}

