/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.util;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RuntimeInfo
extends JFrame
implements ActionListener {
    private static final double BYTES_PER_MB = 1048576.0;
    private static final String UPDATE_CMD = "update";
    private static final String GC_CMD = "gc";
    private static final DecimalFormat myValueFormatter = new DecimalFormat("##0.0");
    private Runtime myRuntime = Runtime.getRuntime();
    private JLabel myMaxMemoryLbl;
    private JLabel myMemoryUseLbl;

    public RuntimeInfo() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add((Component)this.makeInfoPanel(), "Center");
        contentPane.add((Component)this.makeBtnPanel(), "South");
        this.pack();
        this.setVisible(true);
    }

    private JPanel makeInfoPanel() {
        JPanel panel = new JPanel(new GridLayout(2, 2));
        panel.add(new JLabel("Max Memory:"));
        this.myMaxMemoryLbl = new JLabel(this.getMaxMemory());
        panel.add(this.myMaxMemoryLbl);
        panel.add(new JLabel("Memory use:"));
        this.myMemoryUseLbl = new JLabel(this.getMemoryUse());
        panel.add(this.myMemoryUseLbl);
        return panel;
    }

    private JPanel makeBtnPanel() {
        JButton gcBtn = new JButton("GC");
        gcBtn.setActionCommand(GC_CMD);
        gcBtn.addActionListener(this);
        JButton updateBtn = new JButton("Update");
        updateBtn.setActionCommand(UPDATE_CMD);
        updateBtn.addActionListener(this);
        JPanel panel = new JPanel();
        panel.add(gcBtn);
        panel.add(updateBtn);
        return panel;
    }

    private void updateInfo() {
        this.myMaxMemoryLbl.setText(this.getMaxMemory());
        this.myMemoryUseLbl.setText(this.getMemoryUse());
    }

    private long getBytesUsed() {
        long totalMem = this.myRuntime.totalMemory();
        long freeMem = this.myRuntime.freeMemory();
        return totalMem - freeMem;
    }

    private String getMemoryUse() {
        long bytesUsed = this.getBytesUsed();
        double megabytesUsed = (double)bytesUsed / 1048576.0;
        return myValueFormatter.format(megabytesUsed) + " MB";
    }

    private String getMaxMemory() {
        long maxBytes = this.myRuntime.maxMemory();
        double maxMegabytes = (double)maxBytes / 1048576.0;
        return myValueFormatter.format(maxMegabytes) + " MB";
    }

    private void doGarbageCollection() {
        try {
            System.gc();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.sleep(100L);
            System.gc();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(UPDATE_CMD)) {
            this.updateInfo();
        } else if (cmd.equals(GC_CMD)) {
            this.doGarbageCollection();
            this.updateInfo();
        }
    }
}

