/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util;

import com.jbidwatcher.util.config.JConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class GZip {
    private static byte[] _byteHold = new byte[1];
    private static final Boolean _sync = Boolean.TRUE;
    private static final byte[] gzipHdrData = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 2, -1};
    byte[] _gzTest = new byte[2];
    byte[] _data;
    int _uclength;
    int _uccrc32;
    boolean nowrap = true;
    CRC32 _crc32Calculator = new CRC32();
    static int incrementme;

    public byte[] getCompressedData() {
        return this._data;
    }

    public StringBuffer getUncompressedData() {
        return GZip.uncompress(this._data, this.nowrap);
    }

    public StringBuffer getUncompressedData(boolean xt_nowrap) {
        return GZip.uncompress(this._data, xt_nowrap);
    }

    public long getLength() {
        return this._uclength;
    }

    public long getCRC() {
        return this._uccrc32;
    }

    public void reset() {
        this._data = null;
        this._uclength = 0;
        this._uccrc32 = 0;
        this._crc32Calculator.reset();
    }

    public void setData(byte[] newData, int len, int crc) {
        this._data = newData;
        this._uclength = len;
        this._uccrc32 = crc;
    }

    public void setData(byte[] newData) {
        this._crc32Calculator.reset();
        this._crc32Calculator.update(newData);
        this._uccrc32 = (int)this._crc32Calculator.getValue();
        this._uclength = newData.length;
        this._data = this.compress(newData);
    }

    public int readInt(FileInputStream fis) throws IOException {
        int a = fis.read();
        int b = fis.read();
        int c = fis.read();
        int d = fis.read();
        return a + b << 8 + c << 16 + d << 24;
    }

    public void load(File fp) throws IOException {
        FileInputStream fis = new FileInputStream(fp);
        fis.read(this._gzTest);
        if (this._gzTest[0] == 31 && this._gzTest[1] == -117) {
            if (fis.skip(8L) == 8L) {
                this._data = new byte[(int)fp.length() - 18 + 16];
                fis.read(this._data, 0, (int)fp.length() - 18);
                this._uccrc32 = this.readInt(fis);
                this._uclength = this.readInt(fis);
                this.nowrap = true;
            }
        } else {
            this._data = new byte[(int)fp.length()];
            System.arraycopy(this._gzTest, 0, this._data, 0, 2);
            this.nowrap = false;
            fis.read(this._data, 2, this._data.length - 2);
        }
        fis.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] compress(byte[] inBytes) {
        byte[] newData;
        Deflater df = new Deflater(9);
        if (inBytes == null) {
            return null;
        }
        Boolean bl = _sync;
        synchronized (bl) {
            if (_byteHold == null || _byteHold.length < inBytes.length) {
                _byteHold = new byte[inBytes.length * 2];
            }
            df.setInput(inBytes);
            df.finish();
            int deflatedBytes = df.deflate(_byteHold);
            newData = new byte[deflatedBytes -= 4];
            System.arraycopy(_byteHold, 0, newData, 0, deflatedBytes);
        }
        return newData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer uncompress(byte[] curPage, boolean nowrap) {
        Inflater infl = new Inflater(nowrap);
        if (curPage == null) {
            return null;
        }
        Boolean bl = _sync;
        synchronized (bl) {
            int prevLength = _byteHold.length;
            if (prevLength < curPage.length) {
                _byteHold = new byte[curPage.length];
            }
            infl.setInput(curPage);
            try {
                int inflatedBytes;
                int accumOutputBytes = inflatedBytes = infl.inflate(_byteHold);
                while (!infl.finished() && inflatedBytes != 0) {
                    byte[] outdata = _byteHold;
                    prevLength = _byteHold.length;
                    if (accumOutputBytes >= prevLength - 2048) {
                        try {
                            inflatedBytes = 0;
                            _byteHold = new byte[_byteHold.length * 3];
                            System.arraycopy(outdata, 0, _byteHold, 0, accumOutputBytes);
                            inflatedBytes = infl.inflate(_byteHold, accumOutputBytes, prevLength * 2);
                        }
                        catch (OutOfMemoryError oome) {
                            JConfig.log().handleException("FAILING to allocate more bytes @ " + _byteHold.length * 3, oome);
                        }
                    } else {
                        inflatedBytes = infl.inflate(_byteHold, accumOutputBytes, prevLength - accumOutputBytes);
                    }
                    accumOutputBytes += inflatedBytes;
                }
                return new StringBuffer(new String(_byteHold, 0, accumOutputBytes));
            }
            catch (DataFormatException dfe) {
                JConfig.log().handleException("Failed to uncompress data: " + dfe, dfe);
                return null;
            }
        }
    }

    private void writeInt(FileOutputStream fos, int outie) throws IOException {
        byte a = (byte)((outie & 0xFF000000) >> 24);
        byte b = (byte)((outie & 0xFF0000) >> 16);
        byte c = (byte)((outie & 0xFF00) >> 8);
        byte d = (byte)(outie & 0xFF);
        fos.write(d);
        fos.write(c);
        fos.write(b);
        fos.write(a);
    }

    public void save(String fileName) {
        File fp = new File(fileName);
        if (fp.exists()) {
            File oldFP = new File(fileName + "~");
            if (oldFP.exists()) {
                oldFP.delete();
            }
            fp.renameTo(oldFP);
        }
        try {
            FileOutputStream fos = new FileOutputStream(fp);
            fos.write(gzipHdrData, 0, gzipHdrData.length);
            fos.write(this._data, 2, this._data.length - 2);
            this.writeInt(fos, this._uccrc32);
            this.writeInt(fos, this._uclength);
            fos.close();
        }
        catch (IOException ioe) {
            JConfig.log().handleDebugException("Error writing " + fileName, ioe);
        }
    }
}

