/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util;

import com.cyberfox.util.config.ErrorHandler;

public class ScrollingBuffer
implements ErrorHandler {
    private final StringBuffer sLogBuffer;
    private int mMaxSize;

    public ScrollingBuffer(int maxBufferSize) {
        this.mMaxSize = maxBufferSize;
        this.sLogBuffer = new StringBuffer(this.mMaxSize);
    }

    public StringBuffer getLog() {
        return this.sLogBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLog(String s) {
        if (s == null) {
            return;
        }
        StringBuffer stringBuffer = this.sLogBuffer;
        synchronized (stringBuffer) {
            if (s.length() + this.sLogBuffer.length() > this.mMaxSize) {
                int newline = this.sLogBuffer.indexOf("\n", s.length());
                this.sLogBuffer.delete(0, newline);
            }
            this.sLogBuffer.append(s);
            this.sLogBuffer.append("\n");
        }
    }

    @Override
    public void exception(String log, String message, String trace) {
        this.addLog(log);
        this.addLog(message);
        this.addLog(trace);
    }

    @Override
    public void close() {
        this.sLogBuffer.append("--- Log file was reset at this point ---\n");
    }
}

