CREATE TABLE auctions (
  id integer NOT NULL generated by default as identity (START WITH 1, INCREMENT BY 1),
  identifier varchar(255) default NULL,
  current_bid decimal(10,2) default NULL,
  buy_now decimal(10,2) default NULL,
  minimum_bid decimal(10,2) default NULL,
  shipping decimal(10,2) default NULL,
  insurance decimal(10,2) default NULL,
  usd_current decimal(10,2) default NULL,
  usd_buy_now decimal(10,2) default NULL,
  currency varchar(10) default NULL,
  started_at timestamp default NULL,
  ending_at timestamp default NULL,
  high_bidder varchar(255) default NULL,
  high_bidder_email varchar(255) default NULL,
  title varchar(255) default NULL,
  quantity integer default NULL,
  bid_count integer default NULL,
  seller_id integer default NULL,
  location varchar(255) default NULL,
  paypal smallint default NULL,
  reserve_met smallint default NULL,
  private smallint default NULL,
  reserve smallint default NULL,
  dutch smallint default NULL,
  no_thumbnail smallint default NULL,
  has_thumbnail smallint default NULL,
  fixed_price smallint default NULL,
  optional_insurance smallint default NULL,
  outbid smallint default NULL,
  ended smallint default NULL,
  created_at timestamp default NULL,
  updated_at timestamp default NULL,
  PRIMARY KEY  (id)
)

CREATE INDEX IDX_Auction_EndTime ON auctions(ending_at)

CREATE INDEX IDX_Auction_Seller ON auctions(seller_id)

CREATE INDEX IDX_Auction_Identifier ON auctions(identifier)

CREATE INDEX IDX_Auction_Title ON auctions(title)

CREATE TABLE categories (
  id integer NOT NULL generated by default as identity (START WITH 1, INCREMENT BY 1),
  name varchar(255) default NULL,
  PRIMARY KEY  (id)
)

CREATE TABLE entries (
  id integer NOT NULL generated by default as identity (START WITH 1, INCREMENT BY 1),
  auction_id integer default NULL,
  comment varchar(255) default NULL,
  shipping decimal(10,2) default NULL,
  last_bid_amount decimal(10,2) default NULL,
  last_bid_quantity integer default NULL,
  last_bid_at timestamp default NULL,
  currency varchar(10),
  multisnipe_id integer default NULL,
  snipe_id integer default NULL,
  category_id integer default NULL,
  last_updated_at timestamp default NULL,
  ended smallint default NULL,
  invalid smallint default NULL,
  sticky smallint default NULL,
  deleted smallint default NULL,
  last_error_page clob,
  identifier varchar(255) default NULL,
  winning smallint default NULL,
  created_at timestamp default NULL,
  updated_at timestamp default NULL,
  watcher_count integer default NULL,
  sniped_amount DECIMAL(10, 2) DEFAULT NULL,
  auto_canceled SMALLINT,
  was_sniped SMALLINT DEFAULT 0,
  PRIMARY KEY (id)
)

CREATE INDEX IDX_Entry_Category ON entries(category_id)

CREATE INDEX IDX_Entry_Auctions ON entries(auction_id)

CREATE INDEX IDX_Entry_Identifier ON entries(identifier)

CREATE INDEX IDX_Entries_LastUpdated ON entries (last_updated_at)

CREATE INDEX IDX_Entries_Ended ON entries (ended)

CREATE TABLE events (
  id integer NOT NULL generated by default as identity (START WITH 1, INCREMENT BY 1),
  entry_id integer default NULL,
  repeat_count integer default 0,
  created_at timestamp default NULL,
  message varchar(255) default NULL,
  title varchar(255) default NULL,
  PRIMARY KEY  (id)
)

CREATE INDEX IDX_Events_Entries ON events(entry_id)

CREATE TABLE multisnipes (
  id integer NOT NULL generated by default as identity (START WITH 1, INCREMENT BY 1),
  identifier varchar(255) default NULL,
  default_bid decimal(10,2) default NULL,
  default_quantity integer default NULL,
  currency varchar(10),
  want_count integer default NULL,
  won_count integer default NULL,
  color varchar(255) default NULL,
  name varchar(255) default NULL,
  created_at timestamp default NULL,
  subtract_shipping smallint default NULL,
  PRIMARY KEY  (id)
)

CREATE INDEX IDX_Multisnipes_identifier ON multisnipes(identifier)

CREATE TABLE sellers (
  id integer NOT NULL generated by default as identity (START WITH 1, INCREMENT BY 1),
  seller varchar(255) default NULL,
  feedback integer default NULL,
  feedback_percentage DECIMAL(5,2) default NULL,
  comments varchar(255) default NULL,
  PRIMARY KEY  (id)
)

CREATE INDEX IDX_Sellers_Seller ON sellers(seller)

CREATE TABLE snipes (
  id integer NOT NULL generated by default as identity (START WITH 1, INCREMENT BY 1),
  amount decimal(10,2) default NULL,
  currency varchar(10),
  quantity integer default NULL,
  delta integer default NULL,
  user_id integer default NULL,
  status varchar(255) default NULL,
  PRIMARY KEY  (id)
)

CREATE TABLE deleted (
  id integer NOT NULL generated by default as identity (START WITH 1, INCREMENT BY 1),
  identifier varchar(255) default NULL,
  created_at timestamp default NULL,
  PRIMARY KEY  (id)
)

CREATE INDEX IDX_Deleted_Identifier ON deleted(identifier)

CREATE TABLE archived_auctions (
  id integer NOT NULL,
  identifier varchar(255) default NULL,
  current_bid decimal(10,2) default NULL,
  buy_now decimal(10,2) default NULL,
  minimum_bid decimal(10,2) default NULL,
  shipping decimal(10,2) default NULL,
  insurance decimal(10,2) default NULL,
  usd_current decimal(10,2) default NULL,
  usd_buy_now decimal(10,2) default NULL,
  currency varchar(10) default NULL,
  started_at timestamp default NULL,
  ending_at timestamp default NULL,
  high_bidder varchar(255) default NULL,
  high_bidder_email varchar(255) default NULL,
  title varchar(255) default NULL,
  quantity integer default NULL,
  bid_count integer default NULL,
  seller_id integer default NULL,
  location varchar(255) default NULL,
  paypal smallint default NULL,
  reserve_met smallint default NULL,
  private smallint default NULL,
  reserve smallint default NULL,
  dutch smallint default NULL,
  no_thumbnail smallint default NULL,
  has_thumbnail smallint default NULL,
  fixed_price smallint default NULL,
  optional_insurance smallint default NULL,
  outbid smallint default NULL,
  PRIMARY KEY  (id)
)

CREATE INDEX IDX_Archive_Auction_Identifier ON archived_auctions(identifier)

CREATE TABLE time_queue (
  id integer NOT NULL generated by default as identity (START WITH 1, INCREMENT BY 1),
  destination varchar(255) default NULL,
  payload varchar(255) default NULL,
  fire_at timestamp default NULL,
  repeat_interval integer default NULL,
  repeat_count integer default NULL,
  PRIMARY KEY  (id)
)

CREATE INDEX IDX_TQ_Destination ON time_queue(destination, payload)

CREATE INDEX IDX_TQ_FireAt ON time_queue(fire_at)

CREATE TABLE my_jbidwatcher (
  id integer NOT NULL generated by default as identity (START WITH 1, INCREMENT BY 1),
  identifier varchar(255) default NULL,
  thumbnail_uploaded smallint default 0,
  last_synced_at timestamp default NULL,
  last_uploaded_html timestamp default NULL,
  snipe_submitted_at timestamp default NULL,
  currency varchar(10) default NULL,
  snipe_amount decimal(10,2) default NULL,
  PRIMARY KEY  (id)
)

CREATE INDEX IDX_MyJBidwatcher_Id ON my_jbidwatcher(identifier)

CREATE TABLE devices (
  id        INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY ( START WITH 1, INCREMENT BY 1),
  device_id VARCHAR(255) DEFAULT NULL,
  security_key VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (id)
)

CREATE INDEX IDX_Devices_Id ON devices (device_id)

CREATE TABLE schema_info (
  version integer default NULL
)

INSERT INTO schema_info (version) VALUES (26)
