/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram;

import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;

public class ClassDiagram
extends AbstractClassOrObjectDiagram {
    private String namespaceSeparator = ".";

    public ILeaf getOrCreateLeaf(Code code, LeafType leafType, USymbol uSymbol) {
        if (this.namespaceSeparator != null) {
            code = code.withSeparator(this.namespaceSeparator);
        }
        if (leafType == null) {
            code = code.eventuallyRemoveStartingAndEndingDoubleQuote();
            if (this.namespaceSeparator == null) {
                return this.getOrCreateLeafDefault(code, LeafType.CLASS, uSymbol);
            }
            if (super.leafExist(code = code.getFullyQualifiedCode(this.getCurrentGroup()))) {
                return this.getOrCreateLeafDefault(code, LeafType.CLASS, uSymbol);
            }
            return this.createEntityWithNamespace(code, Display.getWithNewlines(code.getShortName(this.getLeafs())), LeafType.CLASS, uSymbol);
        }
        if (this.namespaceSeparator == null) {
            return this.getOrCreateLeafDefault(code, LeafType.CLASS, uSymbol);
        }
        if (super.leafExist(code = code.getFullyQualifiedCode(this.getCurrentGroup()))) {
            return this.getOrCreateLeafDefault(code, leafType, uSymbol);
        }
        return this.createEntityWithNamespace(code, Display.getWithNewlines(code.getShortName(this.getLeafs())), leafType, uSymbol);
    }

    public ILeaf createLeaf(Code code, Display display, LeafType leafType, USymbol uSymbol) {
        if (this.namespaceSeparator != null) {
            code = code.withSeparator(this.namespaceSeparator);
        }
        if (leafType != LeafType.ABSTRACT_CLASS && leafType != LeafType.ANNOTATION && leafType != LeafType.CLASS && leafType != LeafType.INTERFACE && leafType != LeafType.ENUM && leafType != LeafType.LOLLIPOP && leafType != LeafType.NOTE) {
            return super.createLeaf(code, display, leafType, uSymbol);
        }
        if (this.namespaceSeparator == null) {
            return super.createLeaf(code, display, leafType, uSymbol);
        }
        if (super.leafExist(code = code.getFullyQualifiedCode(this.getCurrentGroup()))) {
            throw new IllegalArgumentException("Already known: " + code);
        }
        return this.createEntityWithNamespace(code, display, leafType, uSymbol);
    }

    private ILeaf createEntityWithNamespace(Code code, Display display, LeafType leafType, USymbol uSymbol) {
        IGroup iGroup = this.getCurrentGroup();
        String string = this.getNamespace(code);
        if (string != null && (EntityUtils.groupRoot(iGroup) || !iGroup.getCode().getFullName().equals(string))) {
            Code code2 = Code.of(string);
            iGroup = this.getOrCreateGroupInternal(code2, Display.getWithNewlines(string), code2, GroupType.PACKAGE, this.getRootGroup());
        }
        return this.createLeafInternal(code, display == null ? Display.getWithNewlines(code.getShortName(this.getLeafs())) : display, leafType, iGroup, uSymbol);
    }

    private final String getNamespace(Code code) {
        String string = code.getFullName();
        if (code.getNamespaceSeparator() == null) {
            throw new IllegalArgumentException(code.toString());
        }
        do {
            int n;
            if ((n = string.lastIndexOf(code.getNamespaceSeparator())) == -1) {
                return null;
            }
            string = string.substring(0, n);
        } while (this.getLeafs().containsKey(Code.of(string, code.getNamespaceSeparator())));
        return string;
    }

    public final boolean leafExist(Code code) {
        if (this.namespaceSeparator == null) {
            return super.leafExist(code);
        }
        code = code.withSeparator(this.namespaceSeparator);
        return super.leafExist(code.getFullyQualifiedCode(this.getCurrentGroup()));
    }

    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.CLASS;
    }

    public void setNamespaceSeparator(String string) {
        this.namespaceSeparator = string;
    }

    public String getNamespaceSeparator() {
        return this.namespaceSeparator;
    }
}

