/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.cli;

import com.itextpdf.text.DocumentException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import jpdftweak.cli.CommandOption;
import jpdftweak.core.PdfBookmark;
import jpdftweak.core.PdfInputFile;
import jpdftweak.core.PdfTweak;

public class BookmarksOption
implements CommandOption {
    private List<PdfBookmark> bookmarks = new ArrayList<PdfBookmark>();
    private boolean nobookmarks = false;

    public boolean supportsOption(String string) {
        return string.equals("-bookmark") || string.equals("-loadbookmarks");
    }

    public boolean setOption(String string, String string2) throws IOException {
        if (string.equals("-loadbookmarks")) {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2), "UTF-8"));
            while ((string3 = bufferedReader.readLine()) != null) {
                this.bookmarks.add(PdfBookmark.parseBookmark(string3));
            }
            bufferedReader.close();
        } else if (string2.equals("-")) {
            this.nobookmarks = true;
        } else {
            this.bookmarks.add(PdfBookmark.parseBookmark(string2));
        }
        return true;
    }

    public void run(PdfTweak pdfTweak, PdfInputFile pdfInputFile) throws IOException, DocumentException {
        if (this.nobookmarks) {
            pdfTweak.updateBookmarks(new PdfBookmark[0]);
        }
        if (this.bookmarks.size() > 0) {
            pdfTweak.updateBookmarks(this.bookmarks.toArray(new PdfBookmark[this.bookmarks.size()]));
        }
    }

    public String getSummary() {
        return " -bookmark               Add PDF bookmark(s)\n -loadbookmarks          Load PDF bookmarks from CSV file\n";
    }

    public String getHelp(String string) {
        return " -bookmark {BOOKMARK}\n    Add a pdf bookmark.\n -bookmark -\n    Remove all PDF bookmarks\n -loadbookmarks {FILE}\n    Load PDF bookmarks from CSV file.\n\n The file format is the same used by -savebookmarks; the -bookmark\n options needs single lines from it.";
    }
}

