/*
 * Decompiled with CFR 0.152.
 */
package jpdftweak.gui.tabs;

import com.itextpdf.text.DocumentException;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jpdftweak.core.PdfBookmark;
import jpdftweak.core.PdfInputFile;
import jpdftweak.core.PdfTweak;
import jpdftweak.gui.MainForm;
import jpdftweak.gui.TableComponent;
import jpdftweak.gui.tabs.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarkTab
extends Tab {
    private JButton load;
    private JButton importPDF;
    private JButton importCSV;
    private JButton exportCSV;
    private TableComponent bookmarks;
    private JCheckBox changeBookmarks;
    private final MainForm mainForm;

    public BookmarkTab(MainForm mainForm) {
        super((LayoutManager)new FormLayout("f:p:g, f:p", "f:p, f:p, f:p:g"));
        this.mainForm = mainForm;
        CellConstraints cellConstraints = new CellConstraints();
        this.changeBookmarks = new JCheckBox("Change chapter bookmarks");
        this.add((Component)this.changeBookmarks, cellConstraints.xy(1, 1));
        this.changeBookmarks.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BookmarkTab.this.updateEnabledState();
            }
        });
        this.load = new JButton("Load from document");
        this.add((Component)this.load, cellConstraints.xy(2, 1));
        this.load.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                List<PdfBookmark> list = BookmarkTab.this.mainForm.getInputTab().loadBookmarks();
                BookmarkTab.this.bookmarks.clear();
                BookmarkTab.this.appendBookmarks(list);
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 3));
        this.importPDF = new JButton("Import from PDF");
        jPanel.add(this.importPDF);
        this.importPDF.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = BookmarkTab.this.mainForm.getPdfChooser();
                if (jFileChooser.showOpenDialog(BookmarkTab.this.mainForm) == 0) {
                    try {
                        PdfInputFile pdfInputFile = new PdfInputFile(jFileChooser.getSelectedFile(), "");
                        BookmarkTab.this.bookmarks.clear();
                        BookmarkTab.this.appendBookmarks(pdfInputFile.getBookmarks(1));
                        pdfInputFile.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        JOptionPane.showMessageDialog(BookmarkTab.this.mainForm, iOException.getMessage(), "Error reading file", 0);
                    }
                }
            }
        });
        this.importCSV = new JButton("Import from CSV");
        jPanel.add(this.importCSV);
        this.importCSV.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                if (jFileChooser.showOpenDialog(BookmarkTab.this.mainForm) == 0) {
                    BookmarkTab.this.importCSV(jFileChooser.getSelectedFile());
                }
            }
        });
        this.exportCSV = new JButton("Export to CSV");
        jPanel.add(this.exportCSV);
        this.exportCSV.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                if (jFileChooser.showSaveDialog(BookmarkTab.this.mainForm) == 0) {
                    File file = jFileChooser.getSelectedFile();
                    if (file.exists() && JOptionPane.showConfirmDialog(BookmarkTab.this.mainForm, "Overwrite existing file?", "Confirm Overwrite", 0, 3) == 1) {
                        return;
                    }
                    BookmarkTab.this.exportCSV(file);
                }
            }
        });
        this.add((Component)jPanel, cellConstraints.xyw(1, 2, 2));
        this.bookmarks = new TableComponent(new String[]{"Depth", "Open", "Title", "Page", "Position", "Bold", "Italic", "Options"}, new Class[]{Integer.class, Boolean.class, String.class, Integer.class, String.class, Boolean.class, Boolean.class, String.class}, new Object[]{1, false, "", 1, "", false, false, ""});
        this.add((Component)this.bookmarks, cellConstraints.xyw(1, 3, 2));
        this.updateEnabledState();
    }

    protected void importCSV(File file) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            ArrayList<PdfBookmark> arrayList = new ArrayList<PdfBookmark>();
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#")) continue;
                arrayList.add(PdfBookmark.parseBookmark(string));
            }
            bufferedReader.close();
            this.bookmarks.clear();
            this.appendBookmarks(arrayList);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(this.mainForm, iOException.getMessage(), "Error reading file", 0);
        }
    }

    protected void exportCSV(File file) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            for (int i = 0; i < this.bookmarks.getRowCount(); ++i) {
                PdfBookmark pdfBookmark = this.getBookmark(this.bookmarks.getRow(i));
                bufferedWriter.write(pdfBookmark.toString());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(this.mainForm, iOException.getMessage(), "Error reading file", 0);
        }
    }

    protected void appendBookmarks(List<PdfBookmark> list) {
        for (PdfBookmark pdfBookmark : list) {
            this.bookmarks.addRow(pdfBookmark.getDepth(), pdfBookmark.isOpen(), pdfBookmark.getTitle(), pdfBookmark.getPage(), pdfBookmark.getPagePosition(), pdfBookmark.isBold(), pdfBookmark.isItalic(), pdfBookmark.getMoreOptions());
        }
    }

    protected PdfBookmark getBookmark(Object[] objectArray) {
        int n = (Integer)objectArray[0];
        boolean bl = (Boolean)objectArray[1];
        String string = (String)objectArray[2];
        int n2 = (Integer)objectArray[3];
        String string2 = (String)objectArray[4];
        boolean bl2 = (Boolean)objectArray[5];
        boolean bl3 = (Boolean)objectArray[6];
        String string3 = (String)objectArray[7];
        return new PdfBookmark(n, string, bl, n2, string2, bl2, bl3, string3);
    }

    protected void updateEnabledState() {
        this.load.setEnabled(this.changeBookmarks.isSelected());
        this.importPDF.setEnabled(this.changeBookmarks.isSelected());
        this.importCSV.setEnabled(this.changeBookmarks.isSelected());
        this.exportCSV.setEnabled(this.changeBookmarks.isSelected());
        this.bookmarks.setEnabled(this.changeBookmarks.isSelected());
    }

    @Override
    public String getTabName() {
        return "Bookmarks";
    }

    @Override
    public void checkRun() throws IOException {
        this.bookmarks.checkRun("chapter bookmarks");
    }

    @Override
    public PdfTweak run(PdfTweak pdfTweak) throws IOException, DocumentException {
        if (this.changeBookmarks.isSelected()) {
            PdfBookmark[] pdfBookmarkArray = new PdfBookmark[this.bookmarks.getRowCount()];
            for (int i = 0; i < pdfBookmarkArray.length; ++i) {
                pdfBookmarkArray[i] = this.getBookmark(this.bookmarks.getRow(i));
            }
            pdfTweak.updateBookmarks(pdfBookmarkArray);
        }
        return pdfTweak;
    }
}

